/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.ParameterInOutWrapper;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.result.SimpleSQLResultRunnable;
import org.eclipse.debug.core.ILaunchConfiguration;

public class OracleFunctionRunnable
extends SimpleSQLResultRunnable {
    protected ParameterInOutWrapper[] _pws;
    protected String _procName;

    public OracleFunctionRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration) {
        super(con, sql, closeCon, tracker, parentMonitor, databaseIdentifier, configuration);
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        try {
            ProcIdentifier proc = LaunchHelper.readProcIdentifier((ILaunchConfiguration)this._configuration);
            this._pws = LaunchHelper.getAllParameterWrappersByOrder((ProcIdentifier)proc);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        return super.prepareStatement(connection);
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        this._stmt = this.getConnection().prepareCall("{CALL ? := " + this._sql + "}");
        this.setInParameter(this._stmt, this._pws);
        ((CallableStatement)this._stmt).registerOutParameter(1, 12);
        boolean f = ((CallableStatement)this._stmt).execute();
        System.out.println("result=" + ((CallableStatement)this._stmt).getString(1));
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        if (this.isTerminated() || this.isCanceled()) {
            return false;
        }
        this.getStatementOutParam(this._stmt, this._pws);
        OperationCommand operationCommand = this.getOperationCommand();
        synchronized (operationCommand) {
            this.resultsViewAPI.showParameters(this.getOperationCommand(), this.convert(this._pws));
            this.resultsViewAPI.updateStatus(this.getOperationCommand(), 3);
        }
        return true;
    }

    protected void getStatementOutParam(Statement stmt, ParameterInOutWrapper[] pws) {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        int i = 0;
        while (i < pws.length) {
            pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            pws[i].getParameterDescriptor().getName();
            if (paramType == 1) {
                ++j;
            } else if (paramType == 5 || paramType == 4 || paramType == 2) {
                ++j;
                try {
                    String outValue = "0x";
                    Object o = cstmt.getObject(j);
                    if (o != null) {
                        if (o instanceof byte[]) {
                            byte[] os = (byte[])o;
                            outValue = SQLUtil.toHexString((byte[])os);
                        } else {
                            outValue = o.toString();
                        }
                    }
                    pws[i].setOutValue(outValue);
                }
                catch (SQLException e1) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e1);
                }
                catch (NumberFormatException e1) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e1);
                }
            }
            ++i;
        }
    }

    protected void setInParameter(Statement stmt, ParameterInOutWrapper[] pws) throws SQLException {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int k = 0;
        List values = null;
        try {
            values = LaunchHelper.readParameterList((ILaunchConfiguration)this._configuration);
        }
        catch (CoreException e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (CoreException)e);
        }
        DBHelper helper = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this.getDatabaseIdentifier()).getDBHelper();
        int i = 0;
        while (i < pws.length) {
            pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            if (helper != null) {
                paramType = helper.getCorrectParamType(paramType);
            }
            pws[i].getParameterDescriptor().getParamTypeAsString();
            pws[i].getParameterDescriptor().getName();
            if (paramType != 4 && paramType != 5 && (paramType == 1 || paramType == 2)) {
                String value = null;
                if (values != null && k < values.size()) {
                    value = (String)values.get(k++);
                }
                pws[i].setInValue(value);
            }
            ++i;
        }
    }

    private List convert(ParameterInOutWrapper[] pws) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        int i = 0;
        while (i < pws.length) {
            ParameterDescriptor pd = pws[i].getParameterDescriptor();
            String name = pd.getName();
            if (pd.getParamTypeAsString().equalsIgnoreCase("RETURN")) {
                name = "RETURN";
            }
            Parameter param = new Parameter(name, pd.getParamTypeAsString(), pws[i].getInValue(), pd.getTypeName(), pws[i].getOutValue());
            params.add(param);
            ++i;
        }
        return params;
    }
}

