/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.sql.Connection;
import java.util.HashMap;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.sqltools.core.services.OracleAdHocScriptRunnable;
import oracle.eclipse.tools.database.sqltools.core.services.OracleFunctionRunnable;
import oracle.eclipse.tools.database.sqltools.core.services.OracleStoredProcedureRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.services.ExecutionService;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.debug.core.ILaunchConfiguration;

public class OracleExecutionService
extends ExecutionService {
    public Runnable createStoredProcedureRunnable(Connection con, ILaunchConfiguration configuration, boolean closeCon, IConnectionTracker tracker, DatabaseIdentifier databaseIdentifier) {
        try {
            return new OracleStoredProcedureRunnable(con, configuration, closeCon, tracker, databaseIdentifier);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            return null;
        }
    }

    public Runnable createFunctionRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration, HashMap addInfo) {
        return new OracleFunctionRunnable(con, sql, closeCon, tracker, parentMonitor, databaseIdentifier, configuration);
    }

    public Runnable createAdHocScriptRunnable(Connection con, String sql, boolean closeCon, IConnectionTracker tracker, IProgressMonitor parentMonitor, DatabaseIdentifier databaseIdentifier, ILaunchConfiguration configuration, HashMap addInfo) {
        return new OracleAdHocScriptRunnable(con, sql, closeCon, tracker, parentMonitor, databaseIdentifier, configuration);
    }

    public String getDirectInvocationPrefix(int type) {
        String prefix = "";
        switch (type) {
            case 0: {
                prefix = "CALL ";
                break;
            }
            case 1: {
                prefix = "";
            }
        }
        return prefix;
    }
}

