/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools.core.services;

import java.sql.SQLException;
import java.util.List;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageSpecification;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.db.SourceUtil;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.modelbase.db.OraSchema;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.PackageSpecification;
import oracle.eclipse.tools.database.sqltools.OracleSQLObjectItem;
import oracle.eclipse.tools.database.sqltools.core.services.OracleProcIdentifier;
import org.eclipse.datatools.modelbase.sql.routines.Function;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.IControlConnectionManager;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.IDBItem;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.internal.core.AbstractControlConnection;
import org.eclipse.emf.common.util.EList;

public class OracleControlConnection
extends AbstractControlConnection
implements IControlConnection {
    public OracleControlConnection(IControlConnectionManager manager, DatabaseIdentifier databaseIdentifier) {
        super(manager, databaseIdentifier);
    }

    protected void aboutToDisconnect() {
    }

    public IDBItem createDBItem(ProcIdentifier proc) {
        OracleDatabase db = (OracleDatabase)ProfileUtil.getDatabase((DatabaseIdentifier)this._databaseIdentifier);
        if (db != null) {
            List schemas = db.getAllSchemas();
            for (Schema schema : schemas) {
                if (schema.getName() == null || !schema.getName().equals(proc.getOwnerName())) continue;
                if (proc.getType() == 3) {
                    EList tables = schema.getTables();
                    for (Table table : tables) {
                        EList triggers = table.getTriggers();
                        for (Trigger trigger : triggers) {
                            if (!table.getName().equals(proc.getTableName()) || !trigger.getName().equals(proc.getProcName())) continue;
                            return new OracleSQLObjectItem(proc, (SQLObject)trigger, this);
                        }
                    }
                    continue;
                }
                if (proc instanceof OracleProcIdentifier && ((OracleProcIdentifier)proc).getPackageName() != null) {
                    OracleProcIdentifier oraProcId = (OracleProcIdentifier)proc;
                    String type = oraProcId.getPackageType();
                    if (type.equals("PACKAGE BODY OBJECT") || type.equals("PACKAGE OBJECT")) {
                        int order = oraProcId.getOverloadOrder();
                        OraclePackageObject packObj = this.getPackageObject((OracleSchema)schema, oraProcId.getPackageName(), oraProcId.getPackageType(), proc.getProcName(), order);
                        if (packObj != null) {
                            return new OracleSQLObjectItem(proc, packObj, this);
                        }
                        return null;
                    }
                    EList packages = ((OracleSchema)schema).getPackages();
                    for (OraclePackage oraPack : packages) {
                        if (!oraPack.getName().equals(oraProcId.getProcName())) continue;
                        if (type.equals(oraPack.getOracleType())) {
                            return new OracleSQLObjectItem(proc, oraPack.getSpecification(), this);
                        }
                        if (oraPack.getBody() == null) continue;
                        return new OracleSQLObjectItem(proc, oraPack.getBody(), this);
                    }
                    return null;
                }
                EList routines = schema.getRoutines();
                for (Routine routine : routines) {
                    if (!(proc.getType() == 0 ? routine instanceof Procedure && routine.getName().equals(proc.getProcName()) : proc.getType() == 1 && routine instanceof Function && routine.getName().equals(proc.getProcName()))) continue;
                    return new OracleSQLObjectItem(proc, (SQLObject)routine, this);
                }
            }
        }
        return null;
    }

    public String getProcSource(ProcIdentifier proc) throws SQLException {
        OracleSQLObjectItem item = (OracleSQLObjectItem)this.getDBItem(proc);
        SQLObject routine = item.getRoutine();
        if (routine instanceof Routine) {
            Routine routine2 = (Routine)routine;
            Schema schema = routine2.getSchema();
            return this.getSource(schema, (SQLObject)routine2);
        }
        if (routine instanceof Trigger) {
            Trigger trigger = (Trigger)routine;
            Schema schema = trigger.getSchema();
            return this.getSource(schema, (SQLObject)trigger);
        }
        if (routine instanceof PackageSpecification) {
            OraclePackageSpecification pack = (OraclePackageSpecification)routine;
            OraSchema schema = pack.getOraclePackage().getSchema();
            return this.getSource(schema, pack);
        }
        if (routine instanceof PackageBody) {
            OraclePackageBody pack = (OraclePackageBody)routine;
            OraSchema schema = pack.getOraclePackage().getSchema();
            return this.getSource(schema, pack);
        }
        return null;
    }

    public void saveRoutine(ProcIdentifier proc, String code) throws SQLException {
        OracleSQLObjectItem item = (OracleSQLObjectItem)this.getDBItem(proc);
        item.save(code);
    }

    private OraclePackageObject getPackageObject(OracleSchema schema, String packageName, String packageType, String procName, int overloadOrder) {
        EList packages = schema.getPackages();
        for (OraclePackage oraPack : packages) {
            if (!oraPack.getName().equals(packageName)) continue;
            EList decls = null;
            if (packageType.equals("PACKAGE BODY OBJECT")) {
                PackageBody packBody = oraPack.getBody();
                if (packBody != null) {
                    decls = packBody.getDeclarations();
                }
            } else {
                PackageSpecification packSpec = oraPack.getSpecification();
                if (packSpec != null) {
                    decls = packSpec.getDeclarations();
                }
            }
            if (decls == null) continue;
            for (OraclePackageObject packObj : decls) {
                if (!packObj.getName().equals(procName) || packObj.getOrder() != overloadOrder) continue;
                return packObj;
            }
        }
        return null;
    }

    private String getSource(Schema schema, SQLObject o) {
        DatabaseObject dbObject = new DatabaseObject();
        dbObject.setName(o.getName());
        dbObject.setType(((OracleObject)o).getOracleType());
        dbObject.setId(((OracleObject)o).getId());
        dbObject.setOwner(schema.getName());
        dbObject.setOracleObject((OracleObject)o);
        SourceInput si = new SourceInput(dbObject);
        SourceUtil su = new SourceUtil();
        su.setConnection(((OracleSchema)schema).getConnection());
        return su.getSource(si, false, false, true);
    }
}

