/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.datatools.sqltools.data.internal.core.common.DefaultColumnDataAccessor;
import org.eclipse.datatools.sqltools.data.internal.core.common.data.DataSerializer;

public class TimestampColumnAccessor
extends DefaultColumnDataAccessor {
    public Object read(ResultSet rs, int col, int type, boolean snippet) throws SQLException, IOException {
        try {
            Timestamp t = rs.getTimestamp(col + 1);
            return t;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public String getWhereCond(Object val) {
        String s = this.getQuotedColumnName();
        if (val == null || val.toString().length() == 0) {
            s = String.valueOf(s) + " is null";
            return s;
        }
        return super.getWhereCond(val);
    }

    public String[] writeSetAssArgs(PreparedStatement pst, int column, Object val, int type) throws SQLException, IOException {
        if (val == null || val.toString().length() == 0) {
            pst.setNull(column + 1, 93);
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        if (type == 93) {
            pst.setTimestamp(column + 1, (Timestamp)val);
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        return super.writeSetAssArgs(pst, column, val, type);
    }

    public String[] writeWhereCondArgs(PreparedStatement pst, int column, Object val, int type) throws SQLException, IOException {
        if (val == null || val.toString().length() == 0) {
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        if (type == 93) {
            pst.setTimestamp(column + 1, (Timestamp)val);
            return new String[]{this.argString(this.getLabel(val, type), type)};
        }
        return new String[0];
    }

    protected String argString(String arg, int type) {
        String s = arg;
        if (s == null) {
            return "null";
        }
        if (s.length() > 64) {
            s = String.valueOf(s.substring(0, 64)) + "...";
        }
        if (DataSerializer.needsQuote((int)type)) {
            s = "'" + s + "'";
        }
        return s;
    }
}

