/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import oracle.dbtools.parser.LexerToken;
import oracle.eclipse.tools.database.connectivity.DBToolsMessages;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageObject;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlGenerator;
import oracle.eclipse.tools.database.sqltools.core.services.OracleProcIdentifier;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.internal.dbitem.SQLObjectItem;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;

public class OracleSQLObjectItem
extends SQLObjectItem {
    public OracleSQLObjectItem(ProcIdentifier proc, SQLObject routine, IControlConnection controlConn) {
        super(proc, routine, controlConn);
    }

    public String getCode() throws SQLException {
        return ((Routine)this.getRoutine()).getSource().getBody();
    }

    public void save(String code) throws SQLException {
        String oldName;
        String newName = this.getNewProcName(code);
        if (!newName.equalsIgnoreCase(oldName = this.getProcIdentifier().getProcName())) {
            throw new SQLException(DBToolsMessages.editProcNameErrorMsg);
        }
        OracleDdlGenerator ddlg = new OracleDdlGenerator();
        SQLObject[] elements = new SQLObject[]{this._routine};
        if (ddlg != null) {
            ddlg.getOptions(elements);
            String[] ddl = new String[]{"CREATE OR REPLACE " + code};
            this._controlConn.executeDDL(ddl);
        }
    }

    public ParameterDescriptor[] getParameterDescriptor() throws SQLException {
        if (this._parameterDescriptors == null && (this._routine instanceof Routine || this._routine instanceof OraclePackageObject)) {
            Connection conn = null;
            conn = this.getConnection();
            this._parameterDescriptors = OracleSQLObjectItem.getParameterDescriptors(this.getControlConnection().getDatabaseIdentifier(), conn, this.getProcIdentifier().getType(), this.getProcIdentifier());
            Map defaultparamvalue = new HashMap();
            Map typeNames = new HashMap();
            if (this._routine instanceof Routine) {
                String sql = this.getCode();
                defaultparamvalue = this.getParameterDefalutValues(sql);
                typeNames = this.getSPParamTypeNameMapFromParser(sql);
            }
            if (this._parameterDescriptors != null) {
                int i = 0;
                while (i < this._parameterDescriptors.length) {
                    String value;
                    ParameterDescriptor param = this._parameterDescriptors[i];
                    String typeName = (String)typeNames.get(param.getName());
                    if (typeName != null) {
                        param.setSqlTypeNameFromParser(typeName);
                    }
                    if (defaultparamvalue != null && (value = (String)defaultparamvalue.get(param.getName())) != null) {
                        if (SQLUtil.isStringType((int)param.getSqlDataType())) {
                            param.setDefaultValue(SQLUtil.unquote((String)value));
                        } else {
                            param.setDefaultValue(value);
                        }
                    }
                    ++i;
                }
            }
        }
        if (this._parameterDescriptors == null) {
            this._parameterDescriptors = new ParameterDescriptor[0];
        }
        return this._parameterDescriptors;
    }

    public Map getParameterDefalutValues(String sql) throws SQLException {
        return new HashMap();
    }

    public SQLObject getRoutine() {
        return this._routine;
    }

    private static ParameterDescriptor[] getParameterDescriptors(DatabaseIdentifier databaseIdentifier, Connection connection, int type, ProcIdentifier proc) throws SQLException {
        ParameterDescriptor[] parameterDescriptorArray;
        block15: {
            DatabaseMetaData md = null;
            ResultSet rs = null;
            try {
                ArrayList<ParameterDescriptor> parameters = new ArrayList<ParameterDescriptor>();
                md = connection.getMetaData();
                String catalog = null;
                int order = 0;
                if (proc instanceof OracleProcIdentifier && ((OracleProcIdentifier)proc).getPackageName() != null) {
                    catalog = ((OracleProcIdentifier)proc).getPackageName();
                    order = ((OracleProcIdentifier)proc).getOverloadOrder();
                }
                rs = md.getProcedureColumns(catalog, proc.getOwnerName(), proc.getProcName(), "%");
                while (rs.next()) {
                    String overloadStr;
                    String numOverload;
                    String retCat = rs.getString(1);
                    if (catalog == null && retCat != null || (numOverload = rs.getString("OVERLOAD")) != null && !(overloadStr = Integer.toString(order)).equals(numOverload)) continue;
                    String name = rs.getString(4);
                    short parmType = rs.getShort(5);
                    int sqlDataType = rs.getShort(6);
                    String dataTypeName = rs.getString(7);
                    if (dataTypeName.equalsIgnoreCase("double") && sqlDataType == 0) {
                        sqlDataType = 8;
                    }
                    int precision = rs.getInt(8);
                    rs.getInt(9);
                    short scale = rs.getShort(10);
                    rs.getShort(11);
                    short nullable = rs.getShort(12);
                    String comment = rs.getString(13);
                    ParameterDescriptor p = new ParameterDescriptor(databaseIdentifier, name, (int)parmType, sqlDataType, precision, scale, dataTypeName, nullable, comment);
                    parameters.add(p);
                }
                parameterDescriptorArray = parameters.toArray(new ParameterDescriptor[parameters.size()]);
                if (rs == null) break block15;
            }
            catch (Throwable throwable) {
                block17: {
                    if (rs != null) {
                        try {
                            try {
                                rs.close();
                            }
                            catch (SQLException sQLException) {
                                rs = null;
                                break block17;
                            }
                        }
                        catch (Throwable throwable2) {
                            rs = null;
                            throw throwable2;
                        }
                        rs = null;
                    }
                }
                throw throwable;
            }
            try {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    rs = null;
                }
            }
            finally {
                rs = null;
            }
        }
        return parameterDescriptorArray;
    }

    private String getNewProcName(String code) {
        LinkedList src = LexerToken.parse((String)code);
        ProcIdentifier proc = this.getProcIdentifier();
        if (proc instanceof OracleProcIdentifier && ((OracleProcIdentifier)proc).getPackageName() != null) {
            if (((OracleProcIdentifier)proc).getPackageType().equals("PACKAGE BODY")) {
                return ((LexerToken)src.get((int)2)).content;
            }
            return ((LexerToken)src.get((int)1)).content;
        }
        return ((LexerToken)src.get((int)1)).content;
    }
}

