/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.sqltools;

import oracle.eclipse.tools.database.sqltools.core.services.OracleConnectionService;
import oracle.eclipse.tools.database.sqltools.core.services.OracleExecutionService;
import oracle.eclipse.tools.database.sqltools.core.services.OracleHelper;
import oracle.eclipse.tools.database.sqltools.core.services.OracleSQLService;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.core.services.ExecutionService;
import org.eclipse.datatools.sqltools.core.services.SQLService;

public class OracleSQLDevToolsConfiguration
extends SQLDevToolsConfiguration {
    private ConnectionService connectionService = null;
    private DBHelper dBHelper = null;
    private ExecutionService executionService = null;
    private SQLService sQLService = null;

    public ConnectionService getConnectionService() {
        if (this.connectionService == null) {
            this.connectionService = new OracleConnectionService();
        }
        return this.connectionService;
    }

    public DBHelper getDBHelper() {
        if (this.dBHelper == null) {
            this.dBHelper = new OracleHelper();
        }
        return this.dBHelper;
    }

    public ExecutionService getExecutionService() {
        if (this.executionService == null) {
            this.executionService = new OracleExecutionService();
        }
        return this.executionService;
    }

    public boolean recognize(String product, String version) {
        return product.startsWith("Oracle") && (version.startsWith("10") || version.startsWith("11"));
    }

    public String[] getAssociatedConnectionProfileType() {
        return new String[]{"oracle.eclipse.tools.database.connectivity.db.connectionProfile"};
    }

    public SQLService getSQLService() {
        if (this.sQLService == null) {
            this.sQLService = new OracleSQLService();
        }
        return this.sQLService;
    }
}

