/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.kodo.server.internal;

import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.database.orm.kodo.server.internal.KodoUtil;
import oracle.eclipse.tools.weblogic.ejb.EJBProjectMessages;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public class KodoPreExportOp
extends AbstractDataModelOperation {
    public KodoPreExportOp() {
    }

    public KodoPreExportOp(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        IVirtualComponent component = (IVirtualComponent)this.model.getProperty("IJ2EEComponentExportDataModelProperties.COMPONENT");
        IRuntime runtime = (IRuntime)this.model.getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME");
        try {
            IProject project = component.getProject();
            if (KodoUtil.isUsingKodoJPAProvider(project)) {
                KodoUtil.enhanceProject(RuntimeBridgeUtil.bridge((IRuntime)runtime), project, (IProgressMonitor)subMonitor);
            }
            KodoUtil.checkReferencedProjects(RuntimeBridgeUtil.bridge((IRuntime)runtime), project, monitor);
        }
        catch (Exception e) {
            String msg = EJBProjectMessages.EJBPreExportOpEJBGenFailure;
            LoggingService.logException((String)"oracle.eclipse.tools.weblogic", (Throwable)e, (String)msg);
            return new Status(4, "oracle.eclipse.tools.weblogic", 0, msg, (Throwable)e);
        }
        return OK_STATUS;
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }
}

