/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import oracle.eclipse.tools.database.orm.internal.util.FileUtil;
import oracle.eclipse.tools.database.orm.internal.util.ObjectUtil;
import oracle.eclipse.tools.database.orm.internal.util.StringUtil;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class UrlUtil {
    public static final String FILE_PROTOCOL = "file";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String JAR_PROTOCOL = "jar";

    public static Reader getUrlTextContentReader(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        if (UrlUtil.isJarUrl(url)) {
            connection.setUseCaches(false);
        }
        InputStream stream = connection.getInputStream();
        return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL resolveUri(URL refUrl, String uriStr) {
        if (uriStr == null) {
            return null;
        }
        if ((uriStr = uriStr.trim()).equals("./")) {
            try {
                return new URL(refUrl.toString());
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        uriStr = uriStr.replace('|', ':');
        uriStr = StringUtil.strReplaceAll(uriStr, " ", "%20");
        try {
            if (refUrl == null) {
                URI uri = new URI(uriStr);
                if (uri.isAbsolute()) return uri.toURL();
                return null;
            }
            URI refUri = new URI(StringUtil.strReplaceAll(refUrl.toString(), " ", "%20"));
            String[] parts = uriStr.split("\\?");
            boolean isFile = UrlUtil.isFileUrl(refUrl);
            if (parts != null && parts.length == 2) {
                String string;
                URI resolved = null;
                resolved = parts[0].length() == 0 ? new URI(refUri.toString()) : refUri.resolve(parts[0]);
                String tempStr = resolved.toString();
                if (isFile) {
                    tempStr = StringUtil.strReplaceAll(tempStr, "%20", " ");
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(tempStr));
                if (isFile) {
                    string = "";
                    return new URL(stringBuilder.append(string).toString());
                }
                string = "?" + parts[1];
                return new URL(stringBuilder.append(string).toString());
            }
            URL u = refUri.resolve(uriStr).toURL();
            if (u == null) return u;
            if (!isFile) return u;
            String tempStr = u.toString();
            tempStr = StringUtil.strReplaceAll(u.toString(), "%20", " ");
            return new URL(tempStr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String makeRelative(URL parentUrl, URL childUrl) {
        if (childUrl == null) {
            return null;
        }
        String childFile = childUrl.getFile();
        String parentFile = parentUrl.getFile();
        return UrlUtil.getRelativePath(parentFile, childFile);
    }

    public static boolean isParentUrl(URL parentUrl, URL childUrl) {
        try {
            String tmp = StringUtil.strReplaceAll(parentUrl.toString(), " ", "%20");
            URI parentUri = new URI(tmp);
            tmp = StringUtil.strReplaceAll(childUrl.toString(), " ", "%20");
            URI childUri = new URI(tmp);
            URI relative = parentUri.relativize(childUri);
            if (relative.isAbsolute()) {
                return ObjectUtil.equalObjects(parentUrl.getProtocol(), childUrl.getProtocol()) && ObjectUtil.equalObjects(parentUrl.getHost(), childUrl.getHost()) && ObjectUtil.equalObjects(parentUrl.getPath(), childUrl.getPath());
            }
            return true;
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getUrlFileName(URL url) {
        int slashIndex;
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (path.length() == 0) {
            return null;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((slashIndex = path.lastIndexOf(47)) < 0) {
            return path;
        }
        return path.substring(slashIndex + 1);
    }

    public static boolean isFileUrl(URL url) {
        return url != null && FILE_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isJarUrl(URL url) {
        return url != null && JAR_PROTOCOL.equals(url.getProtocol());
    }

    public static boolean isHttpUrl(URL url) {
        if (url != null) {
            String protocol = url.getProtocol();
            return protocol != null && (HTTP_PROTOCOL.equals(protocol) || HTTPS_PROTOCOL.equals(protocol));
        }
        return false;
    }

    public static File getUrlFile(URL url) {
        if (UrlUtil.isFileUrl(url) && !UrlUtil.isJarUrl(url)) {
            File ret = new File(url.getFile());
            return ret;
        }
        return null;
    }

    public static URL getJarFileUrl(URL url) {
        if (!UrlUtil.isJarUrl(url)) {
            return null;
        }
        String file = url.getFile();
        int index = file.indexOf(33);
        if (index < 0) {
            return null;
        }
        String jarFileUrlStr = file.substring(0, index);
        try {
            return new URL(jarFileUrlStr);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getJarEntryFromJarUrl(URL url) {
        if (!UrlUtil.isJarUrl(url)) {
            return null;
        }
        String file = url.getFile();
        int index = file.indexOf(33);
        if (index < 0) {
            return null;
        }
        String s = file.substring(index + 1);
        if (s.startsWith("/")) {
            s = s.substring(1);
        }
        return s;
    }

    public static URL getJarEntryUrl(File jarFile, String entryName) {
        try {
            if (entryName.startsWith("/")) {
                entryName = entryName.substring(1);
            }
            String urlstr = "jar:" + FileUtil.getFileUrl(jarFile) + "!/" + entryName;
            return new URL(urlstr);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean hasTrailingSlash(URL url) {
        String path = url.toString();
        if (path == null || path.length() == 0) {
            return false;
        }
        int index = path.length() - 1;
        return path.charAt(index) == '/';
    }

    public static URL ensureNoTrailngSlash(URL url) {
        if (!UrlUtil.isFileUrl(url)) {
            return url;
        }
        String path = UrlUtil.removeTrailingSlash(url.toString());
        try {
            return new URL(path);
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    public static String removeTrailingSlash(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        int index = path.length() - 1;
        if (path.charAt(index) == '/') {
            return path.substring(0, index);
        }
        return path;
    }

    public static String getRelativePath(String parentFile, String childFile) {
        childFile = childFile.replace(File.separatorChar, '/');
        parentFile = parentFile.replace(File.separatorChar, '/');
        if ((childFile = UrlUtil.removeTrailingSlash(childFile)).equals(parentFile = UrlUtil.removeTrailingSlash(parentFile))) {
            return "./";
        }
        String commonSpec = childFile;
        int index = childFile.length();
        while (commonSpec.length() > 0) {
            index = commonSpec.lastIndexOf(47);
            if (index < 0) break;
            commonSpec = childFile.substring(0, index);
            if (!parentFile.startsWith(commonSpec)) continue;
            parentFile = parentFile.substring(commonSpec.length());
            childFile = childFile.substring(commonSpec.length());
            break;
        }
        StringBuffer buffer = new StringBuffer(childFile);
        String separator = "..";
        while (parentFile.length() > 0) {
            buffer.insert(0, separator);
            index = parentFile.lastIndexOf(47);
            if (index < 0) break;
            parentFile = parentFile.substring(0, index);
            separator = "../";
        }
        String result = buffer.toString();
        if (result.length() > 0 && result.charAt(0) == '/') {
            return result.substring(1);
        }
        return result;
    }

    public static boolean isRemote(String url) {
        return url.startsWith("http:") || url.startsWith("https:") || url.startsWith("www.");
    }

    public static File getTemplateFolder(String plugId, String strPath) {
        Bundle bundle = Platform.getBundle((String)plugId);
        Path path = new Path(strPath);
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        try {
            URL templUrl = FileLocator.resolve((URL)url);
            File templDir = UrlUtil.getUrlFile(templUrl);
            return templDir;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

