/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.eclipse.tools.database.orm.internal.util.MutableObjectRef;
import oracle.eclipse.tools.database.orm.internal.util.ObjectUtil;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class EclipseTypeUtil {
    private static Map mCachedTypes = null;

    static {
        mCachedTypes = new HashMap(19);
        String s = Integer.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Boolean.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Character.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Float.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Double.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Byte.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Short.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Long.TYPE.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Integer.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Boolean.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Character.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Float.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Double.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Byte.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Short.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Long.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = String.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
        s = Object.class.getName();
        mCachedTypes.put(s, Boolean.TRUE);
    }

    public static TypeDeclaration findTypeDeclaration(ASTNode node, String className) {
        final String simpleName = ObjectUtil.getClassName(className);
        final MutableObjectRef mor = new MutableObjectRef();
        node.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration td) {
                if (td.getName().getIdentifier().equals(simpleName)) {
                    mor.setObject(td);
                }
                return mor.getObject() == null;
            }
        });
        return (TypeDeclaration)mor.getObject();
    }

    public static MethodDeclaration findMethodDeclaration(ASTNode node, final String methodName) {
        if (node == null) {
            return null;
        }
        final MutableObjectRef mor = new MutableObjectRef();
        node.accept(new ASTVisitor(){

            public boolean visit(MethodDeclaration md) {
                if (md.getName().getIdentifier().equals(methodName)) {
                    mor.setObject(md);
                }
                return mor.getObject() == null;
            }
        });
        return (MethodDeclaration)mor.getObject();
    }

    public static VariableDeclarationFragment findFieldDeclaration(ASTNode node, final String fieldName) {
        if (node == null) {
            return null;
        }
        final MutableObjectRef mor = new MutableObjectRef();
        node.accept(new ASTVisitor(){

            public boolean visit(FieldDeclaration fd) {
                if (mor.getObject() == null) {
                    for (VariableDeclarationFragment vdf : fd.fragments()) {
                        if (!vdf.getName().getIdentifier().equals(fieldName)) continue;
                        mor.setObject(vdf);
                        break;
                    }
                }
                return mor.getObject() == null;
            }
        });
        return (VariableDeclarationFragment)mor.getObject();
    }

    public static Name newName(String qualifiedName, AST ast) {
        StringTokenizer t = new StringTokenizer(qualifiedName, ".", true);
        Object result = null;
        int balance = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    throw new IllegalArgumentException();
                }
                if (--balance >= 0) continue;
                throw new IllegalArgumentException();
            }
            ++balance;
            SimpleName name = ast.newSimpleName(s);
            result = result == null ? name : ast.newQualifiedName((Name)result, name);
        }
        if (balance != 1) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static Name newName(String qualifiedName, boolean isClass, CompilationUnit cu) {
        String packageName = ObjectUtil.getPackageName(qualifiedName);
        String className = ObjectUtil.getClassName(qualifiedName);
        if (packageName != null && className != null) {
            String importName;
            if (isClass) {
                importName = qualifiedName;
                qualifiedName = className;
            } else {
                importName = packageName;
                String s = ObjectUtil.getClassName(packageName);
                if (s == null) {
                    s = packageName;
                }
                qualifiedName = String.valueOf(s) + '.' + className;
            }
            EclipseTypeUtil.addImport(importName, cu);
        }
        return EclipseTypeUtil.newName(qualifiedName, cu.getAST());
    }

    public static ImportDeclaration findImportDeclaration(String importName, CompilationUnit cu) {
        List imports = cu.imports();
        int i = 0;
        int n = imports.size();
        while (i < n) {
            ImportDeclaration id = (ImportDeclaration)imports.get(i);
            String existingImport = id.getName().getFullyQualifiedName();
            boolean match = id.isOnDemand() ? ObjectUtil.equalObjects(ObjectUtil.getPackageName(importName), existingImport) : importName.equals(existingImport);
            if (match) {
                return id;
            }
            ++i;
        }
        return null;
    }

    public static boolean addImport(String importName, CompilationUnit cu) {
        if (EclipseTypeUtil.findImportDeclaration(importName, cu) == null) {
            AST ast = cu.getAST();
            ImportDeclaration id = ast.newImportDeclaration();
            id.setName(EclipseTypeUtil.newName(importName, ast));
            cu.imports().add(id);
            return true;
        }
        return false;
    }

    public static boolean isValidType(IJavaProject javaProject, String name, String superName) {
        if (superName == null && EclipseTypeUtil.isKnownType(name)) {
            return true;
        }
        return EclipseTypeUtil.isSuperType(javaProject, name, superName);
    }

    public static ICompilationUnit newCompilationUnitWorkingCopy(IJavaProject javaProject, String className, char[] javaSrc) {
        IPackageFragmentRoot packageFragmentRoot;
        block6: {
            packageFragmentRoot = null;
            try {
                IPackageFragmentRoot[] packageFragmentRoots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < packageFragmentRoots.length) {
                    if (!packageFragmentRoots[i].isArchive() && !packageFragmentRoots[i].isExternal()) {
                        packageFragmentRoot = packageFragmentRoots[i];
                        break;
                    }
                    ++i;
                }
                if (packageFragmentRoot != null) break block6;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        String pkg = ObjectUtil.getPackageName(className);
        if (pkg == null) {
            pkg = "";
        }
        IPackageFragment packageFragment = packageFragmentRoot.getPackageFragment(pkg);
        String fileName = String.valueOf(ObjectUtil.getClassName(className)) + ".java";
        ICompilationUnit cu = packageFragment.getCompilationUnit(fileName).getWorkingCopy(null);
        cu.getBuffer().setContents(javaSrc);
        return cu;
    }

    public static CompilationUnit getNodeCompilationUnit(ASTNode node) {
        while (node != null && !(node instanceof CompilationUnit)) {
            node = node.getParent();
        }
        return (CompilationUnit)node;
    }

    private static boolean isSuperType(IJavaProject javaProject, String name, String superName) {
        block6: {
            IType superType;
            IType type;
            block5: {
                try {
                    type = javaProject.findType(name);
                    if (superName != null) break block5;
                    if (type != null) {
                        return true;
                    }
                    break block6;
                }
                catch (JavaModelException javaModelException) {}
            }
            if (type != null && (superType = type.getJavaProject().findType(superName)) != null && type.newSupertypeHierarchy(null).contains(superType)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isKnownType(String name) {
        return mCachedTypes.containsKey(name);
    }
}

