/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.orm.internal;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.orm.internal.JPAConfigurator;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.resource.persistence.PersistenceXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class EclipseLinkConfigurator
extends JPAConfigurator {
    private static final String ERROR_WRITING_FILE = "Could not write to persistence.xml file.";
    private static final String ECLIPSELINK_JPA_PROVIDER = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final String RESOURCE_LOCAL = "RESOURCE_LOCAL";
    public static final String ECLIPSE_LINK_JAR_NAME = "eclipselink.jar";
    private static final String JDBC_DRIVER = "javax.persistence.jdbc.driver";
    private static final String JDBC_URL = "javax.persistence.jdbc.url";
    private static final String JDBC_USER = "javax.persistence.jdbc.user";
    private static final String JDBC_PASSWORD = "javax.persistence.jdbc.password";
    private static final String EL_TARGET_SERVER = "eclipselink.target-server";
    private static final String EL_LOGGING_LEVEL = "eclipselink.logging.level";
    private static final String EL_JDBC_DRIVER = "eclipselink.jdbc.driver";
    private static final String EL_JDBC_URL = "eclipselink.jdbc.url";
    private static final String EL_JDBC_USER = "eclipselink.jdbc.user";
    private static final String EL_JDBC_PASSWORD = "eclipselink.jdbc.password";
    private static String[] ECLIPSELINK_PROPERTIES = new String[]{"eclipselink.target-server", "javax.persistence.jdbc.driver", "javax.persistence.jdbc.url", "javax.persistence.jdbc.user", "javax.persistence.jdbc.password", "eclipselink.logging.level", "eclipselink.jdbc.driver", "eclipselink.jdbc.url", "eclipselink.jdbc.user", "eclipselink.jdbc.password"};
    private static EclipseLinkConfigurator instance = new EclipseLinkConfigurator();

    private EclipseLinkConfigurator() {
    }

    public static EclipseLinkConfigurator getInstance() {
        return instance;
    }

    @Override
    public void updatePersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        super.updatePersistenceXml(project, monitor);
        try {
            Set set;
            Iterator it;
            JpaProject jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            while (jpaProject == null) {
                Thread.sleep(500L);
                if (monitor.isCanceled()) {
                    return;
                }
                jpaProject = (JpaProject)project.getAdapter(JpaProject.class);
            }
            PersistenceXmlResourceProvider modelProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
            JptXmlResource persistenceResource = modelProvider.getXmlResource();
            XmlPersistence persistence = this.getPersistence(persistenceResource);
            XmlPersistenceUnit persistenceUnitResource = this.getPersistenceUnit(project, persistence);
            XmlPersistenceUnitTransactionType newTransactionType = PersistenceFactory.eINSTANCE.createXmlPersistenceUnitTransactionTypeFromString(null, RESOURCE_LOCAL);
            persistenceUnitResource.setTransactionType(newTransactionType);
            persistenceUnitResource.setProvider(ECLIPSELINK_JPA_PROVIDER);
            String targetServer = "None";
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            IRuntime serverRt = null;
            if (facetedProject != null && (it = (set = facetedProject.getTargetedRuntimes()).iterator()).hasNext()) {
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime rt = (org.eclipse.wst.common.project.facet.core.runtime.IRuntime)it.next();
                serverRt = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)rt);
                String id = serverRt.getRuntimeType().getId();
                if (IWeblogicServerRuntime.RUNTIME_TYPE_9_2 == serverRt.getRuntimeType()) {
                    targetServer = "WebLogic_9";
                } else if (id.startsWith("com.bea.weblogic10")) {
                    targetServer = "WebLogic_10";
                } else if (id.startsWith("com.bea.weblogic")) {
                    targetServer = "WebLogic";
                }
            }
            XmlProperties properties = this.getPersistenceUnitProperties(persistenceUnitResource);
            this.setProperty(properties, EL_TARGET_SERVER, targetServer);
            ConnectionProfile profile = jpaProject.getConnectionProfile();
            if (profile != null && serverRt != null) {
                if (IWeblogicServerRuntime.RUNTIME_TYPE_9_2 == serverRt.getRuntimeType() || IWeblogicServerRuntime.RUNTIME_TYPE_10_0 == serverRt.getRuntimeType()) {
                    this.setProperty(properties, EL_JDBC_DRIVER, profile.getDriverClassName());
                    this.setProperty(properties, EL_JDBC_URL, profile.getURL());
                    this.setProperty(properties, EL_JDBC_USER, profile.getUserName());
                    this.setProperty(properties, EL_JDBC_PASSWORD, profile.getUserPassword());
                    this.setProperty(properties, EL_LOGGING_LEVEL, "FINEST");
                } else {
                    this.setProperty(properties, JDBC_DRIVER, profile.getDriverClassName());
                    this.setProperty(properties, JDBC_URL, profile.getURL());
                    this.setProperty(properties, JDBC_USER, profile.getUserName());
                    this.setProperty(properties, JDBC_PASSWORD, profile.getUserPassword());
                    this.setProperty(properties, EL_LOGGING_LEVEL, "FINEST");
                }
            }
            persistenceResource.save(null);
        }
        catch (IOException ioe) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, ioe);
        }
        catch (Exception e) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, e);
        }
    }

    @Override
    public void cleanupPersistenceXml(IProject project, IProgressMonitor monitor) throws CoreException {
        super.cleanupPersistenceXml(project, monitor);
        try {
            PersistenceXmlResourceProvider modelProvider = PersistenceXmlResourceProvider.getDefaultXmlResourceProvider((IProject)project);
            JptXmlResource persistenceResource = modelProvider.getXmlResource();
            XmlPersistence persistence = this.getPersistence(persistenceResource);
            XmlPersistenceUnit persistenceUnitResource = this.getPersistenceUnit(project, persistence);
            persistenceUnitResource.setTransactionType(null);
            persistenceUnitResource.setProvider("");
            XmlProperties properties = this.getPersistenceUnitProperties(persistenceUnitResource);
            HashSet<String> propNames = new HashSet<String>();
            String[] stringArray = ECLIPSELINK_PROPERTIES;
            int n = ECLIPSELINK_PROPERTIES.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                propNames.add(s);
                ++n2;
            }
            Iterator it = properties.getProperties().iterator();
            while (it.hasNext()) {
                XmlProperty property = (XmlProperty)it.next();
                if (!propNames.contains(property.getName())) continue;
                it.remove();
            }
            persistenceResource.save(null);
        }
        catch (IOException ioe) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, ioe);
        }
        catch (Exception e) {
            throw OraclePlugin.createCoreException(ERROR_WRITING_FILE, e);
        }
    }

    static class TargetServer {
        public static final String None = "None";
        public static final String OC4J = "OC4J";
        public static final String SunAS9 = "SunAS9";
        public static final String WebSphere = "WebSphere";
        public static final String WebSphere_6_1 = "WebSphere_6_1";
        public static final String WebLogic = "WebLogic";
        public static final String WebLogic_9 = "WebLogic_9";
        public static final String WebLogic_10 = "WebLogic_10";
        public static final String JBoss = "JBoss";
        public static final String DEFAULT = "None";

        TargetServer() {
        }
    }
}

