/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.database.connectivity.operations.IColumnDescriptor;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IFKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IFKConstraintColumnPair;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ReferencedConstraintListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        BaseTable baseTable;
        UniqueConstraint parentConstraint;
        ICreateNewTableOperation operation;
        Table table;
        IFKConstraint fk = (IFKConstraint)event.property().element().nearest(IFKConstraint.class);
        String referedSchema = (String)fk.getReferencedSchema().content();
        String referedTable = (String)fk.getReferencedTable().content();
        String referedConstraint = (String)fk.getReferencedConstraint().content();
        fk.getAssociations().clear();
        if (referedSchema != null && referedTable != null && (table = (operation = (ICreateNewTableOperation)event.property().element().nearest(ICreateNewTableOperation.class)).resolveTableObject(referedSchema, referedTable)) instanceof BaseTable && (parentConstraint = this.findParentConstraint(baseTable = (BaseTable)table, referedConstraint)) != null) {
            EList pkCols = parentConstraint.getMembers();
            HashSet<String> matchedCols = new HashSet<String>();
            for (Object colObj : pkCols) {
                Column referencedCol = (Column)colObj;
                IFKConstraintColumnPair newPair = (IFKConstraintColumnPair)fk.getAssociations().insert();
                newPair.setReferencedColumn(referencedCol.getName());
                IColumnDescriptor srcCol = this.findSourceColumn(operation.getColumns(), matchedCols, referencedCol);
                if (srcCol == null) continue;
                newPair.setLocalColumn((String)srcCol.getName().content());
            }
        }
    }

    private UniqueConstraint findParentConstraint(BaseTable baseTable, String constraintName) {
        UniqueConstraint parentConstraint = null;
        List ucObjs = baseTable.getUniqueConstraints();
        for (Object ucObj : ucObjs) {
            UniqueConstraint uc = (UniqueConstraint)ucObj;
            if (!uc.getName().equalsIgnoreCase(constraintName)) continue;
            parentConstraint = uc;
            break;
        }
        return parentConstraint;
    }

    private IColumnDescriptor findSourceColumn(ElementList<IColumnDescriptor> srcCols, HashSet<String> matchedCols, Column referencedColumn) {
        IColumnDescriptor matchedCol = null;
        DataType targetType = referencedColumn.getDataType();
        String targetTypeName = targetType.getName();
        for (IColumnDescriptor srcCol : srcCols) {
            String colTypeName = (String)srcCol.getType().content();
            if (!colTypeName.equalsIgnoreCase(targetTypeName) || matchedCols.contains(srcCol.getName().content())) continue;
            matchedCol = srcCol;
            matchedCols.add((String)srcCol.getName().content());
            break;
        }
        return matchedCol;
    }
}

