/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import java.util.HashSet;
import oracle.eclipse.tools.database.connectivity.operations.ICheckConstraint;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IFKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IIndex;
import oracle.eclipse.tools.database.connectivity.operations.IPKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IUniqueConstraint;
import oracle.eclipse.tools.database.connectivity.operations.internal.NameValidatorResources;
import oracle.eclipse.tools.database.connectivity.operations.internal.OracleReservedWords;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public final class OracleNameValidator
extends ValidationService {
    private static final int MAX_NAME_LENGTH = 30;

    protected Status compute() {
        Value obj = (Value)this.context(Value.of(String.class));
        String name = (String)obj.content();
        if (name != null) {
            if (this.nameTooLong(name)) {
                String msg = NLS.bind((String)NameValidatorResources.nameTooLong, (Object)name);
                return Status.createErrorStatus((String)msg);
            }
            if (this.startsWithIlegalChar(name)) {
                String msg = NLS.bind((String)NameValidatorResources.nameStartsWithIllegalChar, (Object)name);
                return Status.createErrorStatus((String)msg);
            }
            if (this.containsIllegalChar(name)) {
                String msg = NLS.bind((String)NameValidatorResources.nameContainsIllegalChar, (Object)name);
                return Status.createErrorStatus((String)msg);
            }
            if (OracleReservedWords.constains(name)) {
                String msg = NLS.bind((String)NameValidatorResources.reservedWord, (Object)obj);
                return Status.createErrorStatus((String)msg);
            }
            ICreateNewTableOperation operation = (ICreateNewTableOperation)obj.nearest(ICreateNewTableOperation.class);
            if (operation != null && this.nameUsedByAnotherElement(operation, name)) {
                String msg = NLS.bind((String)NameValidatorResources.nameInUse, (Object)name);
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    public boolean nameTooLong(String name) {
        return name.length() > 30;
    }

    public boolean startsWithIlegalChar(String name) {
        char firstCh = Character.toUpperCase(name.charAt(0));
        return firstCh < 'A' || firstCh > 'Z';
    }

    public boolean containsIllegalChar(String name) {
        int size = name.length();
        int i = 0;
        while (i < size) {
            char ch = name.charAt(i);
            if (ch != '_' && !Character.isLetterOrDigit(ch)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean nameUsedByAnotherElement(ICreateNewTableOperation operation, String name) {
        String pkName;
        IPKConstraint pk;
        HashSet<String> nameSet = new HashSet<String>();
        String tableName = (String)operation.getName().content();
        if (tableName != null) {
            String upper = tableName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        if ((pk = (IPKConstraint)operation.getPrimaryKey().content()) != null && (pkName = (String)pk.getName().content()) != null) {
            String upper = pkName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        ElementList<IUniqueConstraint> uniqueCons = operation.getUniqueConstraints();
        for (IUniqueConstraint uc : uniqueCons) {
            String otherName = (String)uc.getName().content();
            if (otherName == null) continue;
            String upper = otherName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        ElementList<IFKConstraint> fks = operation.getForeignKeys();
        for (IFKConstraint fk : fks) {
            String otherName = (String)fk.getName().content();
            if (otherName == null) continue;
            String upper = otherName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        ElementList<ICheckConstraint> ccs = operation.getCheckConstraints();
        for (ICheckConstraint cc : ccs) {
            String otherName = (String)cc.getName().content();
            if (otherName == null) continue;
            String upper = otherName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        ElementList<IIndex> indices = operation.getIndices();
        for (IIndex index : indices) {
            String otherName = (String)index.getName().content();
            if (otherName == null) continue;
            String upper = otherName.toUpperCase();
            if (nameSet.contains(upper)) {
                return true;
            }
            nameSet.add(upper);
        }
        return false;
    }
}

