/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import oracle.eclipse.tools.common.util.StringUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.operations.ICheckConstraint;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IIndex;
import oracle.eclipse.tools.database.connectivity.operations.IPKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IUniqueConstraint;
import oracle.eclipse.tools.database.connectivity.operations.internal.NewTableDDLGenerator;
import oracle.eclipse.tools.database.connectivity.operations.internal.ObjectExistChecker;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.modeling.ProgressMonitor;
import org.eclipse.sapphire.modeling.Status;

public class NewTableOpMethods {
    private static Database database = null;
    private static DatabaseDefinition dbDefinition = null;
    private static final String TABLE_TYPE = "TABLE";
    private static final String INDEX_TYPE = "INDEX";

    public static Status execute(ICreateNewTableOperation operation, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new ProgressMonitor();
        }
        monitor.beginTask(Resources.executeTaskName, 3);
        Status status = NewTableOpMethods.finalValidation(operation);
        if (!status.ok()) {
            return status;
        }
        monitor.worked(1);
        String newTableDDL = (String)operation.getCustomizedDdl().content();
        if (StringUtil.isEmpty((String)newTableDDL)) {
            newTableDDL = NewTableOpMethods.exportDdl(operation);
        }
        monitor.worked(1);
        status = NewTableOpMethods.executeNewTableStmt(operation, newTableDDL);
        monitor.done();
        return status;
    }

    public static void reset(ICreateNewTableOperation operation) {
        database = null;
        dbDefinition = null;
    }

    public static Schema resolveSchemaObject(ICreateNewTableOperation operation, String schemaName) {
        Database db = NewTableOpMethods.resolveDatabase(operation);
        if (db != null) {
            Object list = null;
            list = db instanceof OracleDatabase ? ((OracleDatabase)db).getAllSchemas() : db.getSchemas();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object schemaObj = iterator.next();
                Schema schema2 = (Schema)schemaObj;
                if (!schema2.getName().equalsIgnoreCase(schemaName)) continue;
                return schema2;
            }
        }
        return null;
    }

    public static Table resolveTableObject(ICreateNewTableOperation operation, String schemaName, String tableName) {
        Table table = null;
        Schema schemaObj = NewTableOpMethods.resolveSchemaObject(operation, schemaName);
        if (schemaObj != null) {
            EList tableList = schemaObj.getTables();
            for (Object tableObj : tableList) {
                if (!((Table)tableObj).getName().equalsIgnoreCase(tableName)) continue;
                table = (Table)tableObj;
                break;
            }
        }
        return table;
    }

    public static Database resolveDatabase(ICreateNewTableOperation operation) {
        IConnectionProfile profile;
        IManagedConnection managedConnection;
        String connectionProfile;
        if (database == null && (connectionProfile = (String)operation.getConnectionProfile().content()) != null && (managedConnection = (profile = ProfileManager.getInstance().getProfileByName(connectionProfile)).getManagedConnection("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo")) != null) {
            try {
                ConnectionInfo connectionInfo = (ConnectionInfo)managedConnection.getConnection().getRawConnection();
                if (connectionInfo != null) {
                    database = connectionInfo.getSharedDatabase();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        return database;
    }

    public static DatabaseDefinition resolveDatabaseDefinition(ICreateNewTableOperation operation) {
        Database db;
        if (dbDefinition == null && (db = NewTableOpMethods.resolveDatabase(operation)) != null) {
            dbDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        }
        return dbDefinition;
    }

    public static String exportDdl(ICreateNewTableOperation operation) {
        return NewTableDDLGenerator.generateNewTableDDL(operation);
    }

    private static Status executeNewTableStmt(ICreateNewTableOperation operation, String newTableStmt) {
        Database database = operation.resolveDatabase();
        OracleDatabase oracleDb = (OracleDatabase)database;
        Connection conn = oracleDb.getConnection();
        String connectionProfile = (String)operation.getConnectionProfile().content();
        DatabaseIdentifier databaseIdentifier = new DatabaseIdentifier(connectionProfile, "");
        SQLDevToolsConfiguration f = SQLToolsFacade.getConfigurationByProfileName((String)databaseIdentifier.getProfileName());
        SQLService sqlService = f.getSQLService();
        String[] stmts = sqlService.splitSQL(newTableStmt);
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                String[] stringArray = stmts;
                int n = stmts.length;
                int n2 = 0;
                while (n2 < n) {
                    String sql = stringArray[n2];
                    stmt.execute(sql);
                    ++n2;
                }
            }
            catch (Exception e) {
                try {
                    String schema = (String)operation.getSchema().content();
                    String tableName = (String)operation.getName().content();
                    if (ObjectExistChecker.objectExist(conn, schema, tableName, TABLE_TYPE)) {
                        String dropTableSql = "drop table " + schema + "." + tableName + " cascade constraints";
                        stmt.execute(dropTableSql);
                    }
                }
                catch (SQLException se) {
                    Status status = Status.createErrorStatus((Throwable)se);
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException se2) {
                        return Status.createErrorStatus((Throwable)se2);
                    }
                    return status;
                }
                Status status = Status.createErrorStatus((Throwable)e);
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException se) {
                    return Status.createErrorStatus((Throwable)se);
                }
                return status;
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException se) {
                return Status.createErrorStatus((Throwable)se);
            }
        }
        return Status.createOkStatus();
    }

    private static Status finalValidation(ICreateNewTableOperation operation) {
        Status.CompositeStatusFactory status;
        block16: {
            status = Status.factoryForComposite();
            Database database = operation.resolveDatabase();
            OracleDatabase oracleDb = (OracleDatabase)database;
            Connection conn = oracleDb.getConnection();
            String owner = (String)operation.getSchema().content();
            String tableName = (String)operation.getName().content();
            try {
                try {
                    String pkName;
                    IPKConstraint pk;
                    if (ObjectExistChecker.objectExist(conn, owner, tableName, TABLE_TYPE)) {
                        String msg = NLS.bind((String)Resources.tableNameExist, (Object)tableName);
                        status.merge(Status.createErrorStatus((String)msg));
                    }
                    if ((pk = (IPKConstraint)operation.getPrimaryKey().content()) != null && ObjectExistChecker.objectExist(conn, owner, pkName = (String)pk.getName().content(), INDEX_TYPE)) {
                        String msg = NLS.bind((String)Resources.pkNameExist, (Object)pkName);
                        status.merge(Status.createErrorStatus((String)msg));
                    }
                    ElementList<IUniqueConstraint> uniqueConstraints = operation.getUniqueConstraints();
                    for (IUniqueConstraint uniqueConstraint : uniqueConstraints) {
                        String uniuqeName = (String)uniqueConstraint.getName().content();
                        if (!ObjectExistChecker.objectExist(conn, owner, uniuqeName, INDEX_TYPE)) continue;
                        String msg = NLS.bind((String)Resources.uniqueNameExist, (Object)uniuqeName);
                        status.merge(Status.createErrorStatus((String)msg));
                    }
                    ElementList<ICheckConstraint> checkConstraints = operation.getCheckConstraints();
                    for (ICheckConstraint checkConstraint : checkConstraints) {
                        String checkName = (String)checkConstraint.getName().content();
                        if (!ObjectExistChecker.objectExist(conn, owner, checkName, INDEX_TYPE)) continue;
                        String msg = NLS.bind((String)Resources.checkNameExist, (Object)checkName);
                        status.merge(Status.createErrorStatus((String)msg));
                    }
                    ElementList<IIndex> indices = operation.getIndices();
                    for (IIndex index : indices) {
                        String indexName = (String)index.getName().content();
                        if (!ObjectExistChecker.objectExist(conn, owner, indexName, INDEX_TYPE)) continue;
                        String msg = NLS.bind((String)Resources.indexNameExist, (Object)indexName);
                        status.merge(Status.createErrorStatus((String)msg));
                    }
                }
                catch (SQLException e) {
                    status.merge(Status.createErrorStatus((Throwable)e));
                    try {
                        ObjectExistChecker.close();
                    }
                    catch (SQLException e2) {
                        status.merge(Status.createErrorStatus((Throwable)e2));
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    ObjectExistChecker.close();
                }
                catch (SQLException e) {
                    status.merge(Status.createErrorStatus((Throwable)e));
                }
                throw throwable;
            }
            try {
                ObjectExistChecker.close();
            }
            catch (SQLException e) {
                status.merge(Status.createErrorStatus((Throwable)e));
            }
        }
        return status.create();
    }

    private static final class Resources
    extends NLS {
        public static String executeTaskName;
        public static String tableNameExist;
        public static String pkNameExist;
        public static String uniqueNameExist;
        public static String checkNameExist;
        public static String indexNameExist;

        static {
            Resources.initializeMessages((String)NewTableOpMethods.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

