/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IConstraintColumn;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import oracle.eclipse.tools.database.connectivity.operations.IIndex;
import oracle.eclipse.tools.database.connectivity.operations.IPKConstraint;
import oracle.eclipse.tools.database.connectivity.operations.IUniqueConstraint;
import oracle.eclipse.tools.database.connectivity.operations.internal.ConstraintColumnsValidator;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.modeling.Status;

public final class IndexColumnsValidator
extends ConstraintColumnsValidator {
    @Text(value="Index {0} columns match the primary key")
    private static LocalizableText containsSameColumnsAsPK;
    @Text(value="Index {0} columns match unique key {1}")
    private static LocalizableText containsSameColumnsAsUK;
    @Text(value="Index {0} columns match index {1}")
    private static LocalizableText containsSameColumnsAsIndex;
    private Listener listener;

    static {
        LocalizableText.init(IndexColumnsValidator.class);
    }

    protected void initValidationService() {
        super.initValidationService();
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                IndexColumnsValidator.this.refresh();
            }
        };
        ICreateNewTableOperation op = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
        op.attach(this.listener, "PrimaryKey/ConstraintColumns/ColumnName");
        op.attach(this.listener, "UniqueConstraints/ConstraintColumns/ColumnName");
        op.attach(this.listener, "Indices/IndexColumns/ColumnName");
    }

    protected Status compute() {
        ElementList list = (ElementList)this.context(ElementList.of(IConstraintColumn.class));
        IIndex index = (IIndex)list.nearest(IIndex.class);
        if (index.getName().validation().ok()) {
            ElementList<IConstraintColumn> pkCols;
            ICreateNewTableOperation operation = (ICreateNewTableOperation)list.nearest(ICreateNewTableOperation.class);
            IPKConstraint pk = (IPKConstraint)operation.getPrimaryKey().content();
            if (pk != null && this.containsSameColumns((ElementList<? extends IConstraintColumn>)list, pkCols = pk.getConstraintColumns()) && IndexColumnsValidator.columnsInSameOrder((ElementList<? extends IConstraintColumn>)list, pkCols)) {
                String msg = containsSameColumnsAsPK.format(new Object[]{index.getName().content()});
                return Status.createErrorStatus((String)msg);
            }
            ElementList<IUniqueConstraint> uniqueConstraints = operation.getUniqueConstraints();
            for (IUniqueConstraint uk : uniqueConstraints) {
                if (!this.containsSameColumns((ElementList<? extends IConstraintColumn>)list, uk.getConstraintColumns()) || !IndexColumnsValidator.columnsInSameOrder((ElementList<? extends IConstraintColumn>)list, uk.getConstraintColumns())) continue;
                String msg = containsSameColumnsAsUK.format(new Object[]{index.getName().content(), uk.getName().content()});
                return Status.createErrorStatus((String)msg);
            }
            ElementList<IIndex> indices = operation.getIndices();
            for (IIndex another : indices) {
                if (another == index || !this.containsSameColumns((ElementList<? extends IConstraintColumn>)list, another.getIndexColumns()) || !IndexColumnsValidator.columnsInSameOrder((ElementList<? extends IConstraintColumn>)list, another.getIndexColumns())) continue;
                String msg = containsSameColumnsAsIndex.format(new Object[]{index.getName().content(), another.getName().content()});
                return Status.createErrorStatus((String)msg);
            }
        }
        return Status.createOkStatus();
    }

    private static boolean columnsInSameOrder(ElementList<? extends IConstraintColumn> colList1, ElementList<? extends IConstraintColumn> colList2) {
        int size = colList1.size();
        int i = 0;
        while (i < size) {
            String name2;
            IConstraintColumn col1 = (IConstraintColumn)colList1.get(i);
            IConstraintColumn col2 = (IConstraintColumn)colList2.get(i);
            String name1 = (String)col1.getColumnName().content();
            if (!name1.equalsIgnoreCase(name2 = (String)col2.getColumnName().content())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void dispose() {
        if (this.listener != null) {
            ICreateNewTableOperation op = (ICreateNewTableOperation)this.context(ICreateNewTableOperation.class);
            op.detach(this.listener, "PrimaryKey/ConstraintColumns/ColumnName");
            op.detach(this.listener, "UniqueConstraints/ConstraintColumns/ColumnName");
            op.detach(this.listener, "Indices/IndexColumns/ColumnName");
            this.listener = null;
        }
        super.dispose();
    }
}

