/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.operations.internal;

import oracle.eclipse.tools.database.connectivity.operations.IColumnDescriptor;
import oracle.eclipse.tools.database.connectivity.operations.IConstraintColumn;
import oracle.eclipse.tools.database.connectivity.operations.ICreateNewTableOperation;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.services.ValidationService;

public abstract class ConstraintColumnsValidator
extends ValidationService {
    protected String getColType(String colName, ICreateNewTableOperation operation) {
        String type = null;
        ElementList<IColumnDescriptor> columns = operation.getColumns();
        for (IColumnDescriptor col : columns) {
            String name = (String)col.getName().content();
            if (name == null || !name.equalsIgnoreCase(colName)) continue;
            type = (String)col.getType().content();
            break;
        }
        return type;
    }

    protected boolean canBeKey(String colName, String colType, ICreateNewTableOperation operation) {
        boolean ret = false;
        DatabaseDefinition dbDefinition = operation.resolveDatabaseDefinition();
        if (colType != null) {
            PredefinedDataTypeDefinition typeDefinition;
            if (colType.equalsIgnoreCase("INTERVAL DAY") || colType.equalsIgnoreCase("INTERVAL YEAR")) {
                colType = "INTERVAL";
            }
            if ((typeDefinition = dbDefinition.getPredefinedDataTypeDefinition(colType)) != null && typeDefinition.isKeyConstraintSupported() && !colType.equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
                ret = true;
            }
        }
        return ret;
    }

    protected boolean containsSameColumns(ElementList<? extends IConstraintColumn> colList1, ElementList<? extends IConstraintColumn> colList2) {
        if (colList1.size() != colList2.size()) {
            return false;
        }
        for (IConstraintColumn col1 : colList1) {
            String colName1 = (String)col1.getColumnName().content();
            boolean foundMatch = false;
            if (colName1 != null) {
                for (IConstraintColumn col2 : colList2) {
                    String colName2 = (String)col2.getColumnName().content();
                    if (colName2 == null || !colName2.equalsIgnoreCase(colName1)) continue;
                    foundMatch = true;
                    break;
                }
            }
            if (foundMatch) continue;
            return false;
        }
        return true;
    }
}

