/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OracleTable;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlBuilder;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlGenerationOptions;
import oracle.eclipse.tools.database.connectivity.ddl.OracleDdlScript;
import oracle.eclipse.tools.database.modelbase.db.DatabaseLink;
import oracle.eclipse.tools.database.modelbase.db.Directory;
import oracle.eclipse.tools.database.modelbase.db.MaterializedView;
import oracle.eclipse.tools.database.modelbase.db.OraPackage;
import oracle.eclipse.tools.database.modelbase.db.OraPublicSynonym;
import oracle.eclipse.tools.database.modelbase.db.OraSchema;
import oracle.eclipse.tools.database.modelbase.db.OraSequence;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.PackageSpecification;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.definition.EngineeringOptionID;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.rte.EngineeringOptionCategory;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class OracleDdlGenerator
extends GenericDdlGenerator
implements IExecutableExtension {
    private OracleDdlBuilder builder = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.builder = new OracleDdlBuilder();
    }

    public String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        OracleDdlScript script = new OracleDdlScript();
        if (this.builder == null) {
            this.builder = new OracleDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        for (Object o : this.getAllContainedDisplayableElementSet(elements)) {
            String statement;
            if (o instanceof BaseTable) {
                if (!this.generateTables(options) || this.isFilteredOut((SQLObject)((BaseTable)o)) || (statement = this.builder.createTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || this.isFilteredOut((SQLObject)((ViewTable)o))) continue;
                statement = null;
                statement = o instanceof OracleMaterializedView ? this.builder.createMaterializedView((OracleMaterializedView)o, quoteIdentifiers, qualifyNames) : this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || this.isFilteredOut((SQLObject)((Procedure)o)) || (statement = this.builder.createProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || this.isFilteredOut((SQLObject)((UserDefinedFunction)o)) || (statement = this.builder.createUserDefinedFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedType) {
                if (!this.generateUserDefinedTypes(options) || this.isFilteredOut((SQLObject)((UserDefinedType)o)) || (statement = this.builder.createUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateUserDefinedTypeStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || this.isFilteredOut((SQLObject)((Trigger)o)) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || this.isFilteredOut((SQLObject)((CheckConstraint)o)) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || this.isFilteredOut((SQLObject)((UniqueConstraint)o)) || !((UniqueConstraint)o).getForeignKey().isEmpty() || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || this.isFilteredOut((SQLObject)((ForeignKey)o)) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || this.isFilteredOut((SQLObject)((Index)o)) || this.isPrimaryKeyIndex((Index)o) || this.isUniqueKeyIndex((Index)o) || ((Index)o).getMembers().size() == 0 || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateIndexStatement(statement);
                continue;
            }
            if (o instanceof PackageBody) {
                if (!this.generatePackageBody(options) || (statement = this.builder.createPackageBody((PackageBody)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreatePackageStatement(statement);
                continue;
            }
            if (o instanceof PackageSpecification) {
                if (!this.generatePackageSpecification(options) || (statement = this.builder.createPackageSpecification((PackageSpecification)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreatePackageStatement(statement);
                continue;
            }
            if (o instanceof OraSequence) {
                if (!this.generateOracleSequence(options) || this.isFilteredOut((SQLObject)((OraSequence)o)) || (statement = this.builder.createSequence((OraSequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateSequenceStatement(statement);
                continue;
            }
            if (!(o instanceof Synonym) || (!(o instanceof OraPublicSynonym) ? !this.generateOracleSynonym(options) || this.isFilteredOut((Synonym)o) : !this.generateOraclePublicSynonym(options) || this.isFilteredOut((OraPublicSynonym)o))) continue;
            statement = this.builder.createSynonym((Synonym)o, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            script.addCreateSynonymStatement(statement);
        }
        return script.getStatements();
    }

    public String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        OracleDdlScript script = new OracleDdlScript();
        if (this.builder == null) {
            this.builder = new OracleDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        for (Object o : this.getAllContainedDisplayableElementSet(elements)) {
            String statement;
            if (o instanceof BaseTable) {
                if (!this.generateTables(options) || this.isFilteredOut((SQLObject)((BaseTable)o)) || (statement = this.builder.dropTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof MaterializedView) {
                if (!this.generateViews(options) || this.isFilteredOut((SQLObject)((MaterializedView)o)) || (statement = this.builder.dropMaterializedView((MaterializedView)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropMaterializedViewStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || this.isFilteredOut((SQLObject)((ViewTable)o)) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || this.isFilteredOut((SQLObject)((Procedure)o)) || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || this.isFilteredOut((SQLObject)((UserDefinedFunction)o)) || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedType) {
                if (!this.generateUserDefinedTypes(options) || this.isFilteredOut((SQLObject)((UserDefinedType)o)) || (statement = this.builder.dropUserDefinedType((UserDefinedType)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropUserDefinedTypeStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || this.isFilteredOut((SQLObject)((CheckConstraint)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((UniqueConstraint)o)) || this.isFilteredOut((SQLObject)((UniqueConstraint)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || this.builder.isImplicitConstraint((TableConstraint)((ForeignKey)o)) || this.isFilteredOut((SQLObject)((ForeignKey)o)) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (o instanceof Index) {
                if (!this.generateIndexes(options) || this.isFilteredOut((SQLObject)((Index)o)) || this.isPrimaryKeyIndex((Index)o) || this.isUniqueKeyIndex((Index)o) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropIndexStatement(statement);
                continue;
            }
            if (o instanceof OraPackage) {
                if (!this.generatePackageSpecification(options) || this.isFilteredOut((OraPackage)o) || (statement = this.builder.dropPackage((OraPackage)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPackageStatement(statement);
                continue;
            }
            if (o instanceof PackageBody) {
                if (!this.generatePackageBody(options) || (statement = this.builder.dropPackageBody((PackageBody)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPackageStatement(statement);
                continue;
            }
            if (o instanceof PackageSpecification) {
                if (!this.generatePackageSpecification(options) || (statement = this.builder.dropPackageSpecification((PackageSpecification)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropPackageStatement(statement);
                continue;
            }
            if (o instanceof OraSequence) {
                if (!this.generateOracleSequence(options) || this.isFilteredOut((SQLObject)((OraSequence)o)) || (statement = this.builder.dropSequence((OraSequence)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropSequenceStatement(statement);
                continue;
            }
            if (o instanceof DatabaseLink) {
                statement = this.builder.dropDatabaseLink((DatabaseLink)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropDatabaseLinkStatement(statement);
                continue;
            }
            if (o instanceof Directory) {
                statement = this.builder.dropDirectory((Directory)o, quoteIdentifiers, qualifyNames);
                if (statement == null) continue;
                script.addDropDirectoryStatement(statement);
                continue;
            }
            if (!(o instanceof Synonym) || (!(o instanceof OraPublicSynonym) ? !this.generateOracleSynonym(options) || this.isFilteredOut((Synonym)o) : !this.generateOraclePublicSynonym(options) || this.isFilteredOut((OraPublicSynonym)o))) continue;
            statement = this.builder.dropSynonym((Synonym)o, quoteIdentifiers, qualifyNames);
            if (statement == null) continue;
            script.addDropSynonymStatement(statement);
        }
        return script.getStatements();
    }

    private void sortObjects(SQLObject[] elements, List<SQLObject> oracleObjs, List<SQLObject> sqlObjs) {
        SQLObject[] sQLObjectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            SQLObject sqlObj = sQLObjectArray[n2];
            if (sqlObj instanceof PackageBody || sqlObj instanceof PackageSpecification || sqlObj instanceof OraclePackage || sqlObj instanceof OraSequence || sqlObj instanceof Synonym || sqlObj instanceof DatabaseLink || sqlObj instanceof UserDefinedType || sqlObj instanceof Directory) {
                oracleObjs.add(sqlObj);
            } else {
                sqlObjs.add(sqlObj);
            }
            ++n2;
        }
    }

    private List<EngineeringOption> getOracleOptions(List<SQLObject> sqlObjs, EngineeringOptionCategory cat) {
        ArrayList<EngineeringOption> options = new ArrayList<EngineeringOption>();
        for (SQLObject sqlObj : sqlObjs) {
            if (sqlObj instanceof PackageBody) {
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createPackageBodyOptions(cat)));
                continue;
            }
            if (sqlObj instanceof PackageSpecification) {
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createPackageSpecificationOptions(cat)));
                continue;
            }
            if (sqlObj instanceof OraclePackage) {
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createPackageSpecificationOptions(cat)));
                continue;
            }
            if (sqlObj instanceof OraSequence) {
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createSequenceOptions(cat)));
                continue;
            }
            if (sqlObj instanceof Synonym) {
                if (sqlObj instanceof OraPublicSynonym) {
                    options.addAll(Arrays.asList(OracleDdlGenerationOptions.createPublicSynonymOptions(cat)));
                    continue;
                }
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createSynonymOptions(cat)));
                continue;
            }
            if (sqlObj instanceof DatabaseLink) {
                options.addAll(Arrays.asList(OracleDdlGenerationOptions.createDatabaseLinkOptions(cat)));
                continue;
            }
            if (!(sqlObj instanceof UserDefinedType)) continue;
            options.addAll(Arrays.asList(OracleDdlGenerationOptions.createUserDefinedTypeOptions(cat)));
        }
        return options;
    }

    public EngineeringOption[] getOptions(SQLObject[] elements) {
        ArrayList<SQLObject> oracleObjs = new ArrayList<SQLObject>();
        ArrayList<SQLObject> sqlObjs = new ArrayList<SQLObject>();
        this.sortObjects(elements, oracleObjs, sqlObjs);
        EngineeringOptionCategory[] categories = this.getOptionCategories();
        EngineeringOptionCategory general_options = null;
        EngineeringOptionCategory additional_element = null;
        EngineeringOptionCategory[] engineeringOptionCategoryArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            EngineeringOptionCategory element = engineeringOptionCategoryArray[n2];
            if (element.getId().equals("GENERATE_OPTIONS")) {
                general_options = element;
            } else if (element.getId().equals("GENERATE_ELEMENTS")) {
                additional_element = element;
            }
            ++n2;
        }
        if (oracleObjs.size() == 0) {
            return super.getOptions(elements);
        }
        if (sqlObjs.size() == 0) {
            Vector<EngineeringOption> optionVec = new Vector<EngineeringOption>();
            ResourceBundle resource = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.sqm.internal.core.rte.fe.GenericDdlGeneration");
            optionVec.add(new EngineeringOption("GENERATE_FULLY_QUALIFIED_NAME", resource.getString("GENERATE_FULLY_QUALIFIED_NAME"), resource.getString("GENERATE_FULLY_QUALIFIED_NAME_DES"), false, general_options));
            optionVec.add(new EngineeringOption("GENERATE_QUOTED_IDENTIFIER", resource.getString("GENERATE_QUOTED_IDENTIFIER"), resource.getString("GENERATE_QUOTED_IDENTIFIER_DES"), false, general_options));
            optionVec.add(new EngineeringOption("GENERATE_DROP_STATEMENTS", resource.getString("GENERATE_DROP_STATEMENTS"), resource.getString("GENERATE_DROP_STATEMENTS_DES"), false, general_options));
            optionVec.add(new EngineeringOption("GENERATE_CREATE_STATEMENTS", resource.getString("GENERATE_CREATE_STATEMENTS"), resource.getString("GENERATE_CREATE_STATEMENTS_DES"), true, general_options));
            optionVec.addAll(this.getOracleOptions(oracleObjs, additional_element));
            Object[] options = new EngineeringOption[optionVec.size()];
            optionVec.copyInto(options);
            this.options = options;
            return options;
        }
        EngineeringOption[] sqlOptions = super.getOptions(sqlObjs.toArray(new SQLObject[0]));
        ArrayList<EngineeringOption> allOptions = new ArrayList<EngineeringOption>();
        allOptions.addAll(Arrays.asList(sqlOptions));
        allOptions.addAll(this.getOracleOptions(oracleObjs, additional_element));
        this.options = allOptions.toArray(new EngineeringOption[0]);
        return this.options;
    }

    public boolean generatePackageBody(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_PACKAGE_BODY", options);
    }

    public boolean generatePackageSpecification(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_PACKAGE_SPECIFICATION", options);
    }

    public boolean generateOracleSequence(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SEQUENCE", options);
    }

    public boolean generateOracleSynonym(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_SYNONYM", options);
    }

    public boolean generateOraclePublicSynonym(EngineeringOption[] options) {
        return this.getOptionValueByID("GENERATE_PUBLIC_SYNONYM", options);
    }

    private boolean getOptionValueByID(String optionID, EngineeringOption[] options) {
        return EngineeringOptionID.getOptionValueByID((String)optionID, (EngineeringOption[])options);
    }

    private boolean isPrimaryKeyIndex(Index index) {
        OracleTable table = (OracleTable)index.getTable();
        PrimaryKey primaryKey = table.getPrimaryKey();
        return primaryKey != null && primaryKey.getName().equalsIgnoreCase(index.getName());
    }

    private boolean isUniqueKeyIndex(Index index) {
        OracleTable table = (OracleTable)index.getTable();
        List uniqueList = table.getUniqueConstraints();
        for (Object o : uniqueList) {
            UniqueConstraint uc = (UniqueConstraint)o;
            if (!uc.getName().equalsIgnoreCase(index.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isFilteredOut(SQLObject sqlObj) {
        String filterName;
        Synonym syn;
        OraSchema schema;
        ConnectionInfo ci;
        ConnectionFilter cf;
        boolean filtered = false;
        String objName = sqlObj.getName();
        if (sqlObj instanceof BaseTable) {
            String filterName2;
            BaseTable table = (BaseTable)sqlObj;
            Schema schema2 = table.getSchema();
            ConnectionInfo ci2 = this.getConnectionInfo(schema2);
            ConnectionFilter cf2 = ci2.getFilter(filterName2 = String.valueOf(schema2.getName()) + "::" + "DatatoolsTableFilterPredicate");
            if (cf2 == null) {
                cf2 = ci2.getFilter("DatatoolsTableFilterPredicate");
            }
            if (cf2 != null) {
                filtered = cf2.isFiltered(objName);
            }
        } else if (sqlObj instanceof MaterializedView) {
            String filterName3;
            MaterializedView mview = (MaterializedView)sqlObj;
            Schema schema3 = mview.getSchema();
            ConnectionInfo ci3 = this.getConnectionInfo(schema3);
            ConnectionFilter cf3 = ci3.getFilter(filterName3 = String.valueOf(schema3.getName()) + "::" + "OracleMatViewFilterPredicate");
            if (cf3 != null) {
                filtered = cf3.isFiltered(objName);
            }
        } else if (sqlObj instanceof ViewTable) {
            String filterName4;
            ViewTable viewTable = (ViewTable)sqlObj;
            Schema schema4 = viewTable.getSchema();
            ConnectionInfo ci4 = this.getConnectionInfo(schema4);
            ConnectionFilter cf4 = ci4.getFilter(filterName4 = String.valueOf(schema4.getName()) + "::" + "DatatoolsViewFilterPredicate");
            if (cf4 != null) {
                filtered = cf4.isFiltered(objName);
            }
        } else if (sqlObj instanceof Procedure) {
            String filterName5;
            Procedure proc = (Procedure)sqlObj;
            Schema schema5 = proc.getSchema();
            ConnectionInfo ci5 = this.getConnectionInfo(schema5);
            ConnectionFilter cf5 = ci5.getFilter(filterName5 = String.valueOf(schema5.getName()) + "::" + "DatatoolsSPFilterPredicate");
            if (cf5 == null) {
                cf5 = ci5.getFilter("DatatoolsSPFilterPredicate");
            }
            if (cf5 != null) {
                filtered = cf5.isFiltered(objName);
            }
        } else if (sqlObj instanceof UserDefinedFunction) {
            String filterName6;
            UserDefinedFunction func = (UserDefinedFunction)sqlObj;
            Schema schema6 = func.getSchema();
            ConnectionInfo ci6 = this.getConnectionInfo(schema6);
            ConnectionFilter cf6 = ci6.getFilter(filterName6 = String.valueOf(schema6.getName()) + "::" + "DatatoolsUDFFilterPredicate");
            if (cf6 != null) {
                filtered = cf6.isFiltered(objName);
            }
        } else if (sqlObj instanceof UserDefinedType) {
            String filterName7;
            UserDefinedType type = (UserDefinedType)sqlObj;
            Schema schema7 = type.getSchema();
            ConnectionInfo ci7 = this.getConnectionInfo(schema7);
            ConnectionFilter cf7 = ci7.getFilter(filterName7 = String.valueOf(schema7.getName()) + "::" + "DatatoolsUDTFilterPredicate");
            if (cf7 != null) {
                filtered = cf7.isFiltered(objName);
            }
        } else if (sqlObj instanceof Trigger) {
            Trigger t = (Trigger)sqlObj;
            filtered = this.isFilteredOut((SQLObject)t.getSubjectTable());
        } else if (sqlObj instanceof CheckConstraint) {
            CheckConstraint cc = (CheckConstraint)sqlObj;
            filtered = this.isFilteredOut((SQLObject)cc.getBaseTable());
        } else if (sqlObj instanceof UniqueConstraint) {
            UniqueConstraint uc = (UniqueConstraint)sqlObj;
            filtered = this.isFilteredOut((SQLObject)uc.getBaseTable());
        } else if (sqlObj instanceof ForeignKey) {
            ForeignKey fk = (ForeignKey)sqlObj;
            filtered = this.isFilteredOut((SQLObject)fk.getBaseTable());
        } else if (sqlObj instanceof Index) {
            Index index = (Index)sqlObj;
            filtered = this.isFilteredOut((SQLObject)index.getTable());
        } else if (sqlObj instanceof OraPackage) {
            String filterName8;
            OraPackage oraPack = (OraPackage)sqlObj;
            OraSchema schema8 = oraPack.getSchema();
            ConnectionInfo ci8 = this.getConnectionInfo(schema8);
            ConnectionFilter cf8 = ci8.getFilter(filterName8 = String.valueOf(schema8.getName()) + "::" + "OraclePackageFilterPredicate");
            if (cf8 != null) {
                filtered = cf8.isFiltered(objName);
            }
        } else if (sqlObj instanceof OraSequence) {
            String filterName9;
            OraSequence oraSeq = (OraSequence)sqlObj;
            Schema schema9 = oraSeq.getSchema();
            ConnectionInfo ci9 = this.getConnectionInfo(schema9);
            ConnectionFilter cf9 = ci9.getFilter(filterName9 = String.valueOf(schema9.getName()) + "::" + "DatatoolsSequenceFilterPredicate");
            if (cf9 != null) {
                filtered = cf9.isFiltered(objName);
            }
        } else if (sqlObj instanceof DatabaseLink) {
            String filterName10;
            DatabaseLink link = (DatabaseLink)sqlObj;
            OraSchema schema10 = link.getSchema();
            ConnectionInfo ci10 = this.getConnectionInfo(schema10);
            ConnectionFilter cf10 = ci10.getFilter(filterName10 = String.valueOf(schema10.getName()) + "::" + "OracleDatabaseLinkFilterPredicate");
            if (cf10 != null) {
                filtered = cf10.isFiltered(objName);
            }
        } else if (sqlObj instanceof Directory) {
            String filterName11;
            Directory dir = (Directory)sqlObj;
            OraSchema schema11 = dir.getSchema();
            ConnectionInfo ci11 = this.getConnectionInfo(schema11);
            ConnectionFilter cf11 = ci11.getFilter(filterName11 = String.valueOf(schema11.getName()) + "::" + "OracleDirectoryFilterPredicate");
            if (cf11 != null) {
                filtered = cf11.isFiltered(objName);
            }
        } else if (sqlObj instanceof OraPublicSynonym) {
            String filterName12;
            OraPublicSynonym syn2 = (OraPublicSynonym)sqlObj;
            OraSchema schema12 = syn2.getSchema();
            ConnectionInfo ci12 = this.getConnectionInfo(schema12);
            ConnectionFilter cf12 = ci12.getFilter(filterName12 = String.valueOf(schema12.getName()) + "::" + "OraclePublicSynonymFilterPredicate");
            if (cf12 != null) {
                filtered = cf12.isFiltered(objName);
            }
        } else if (sqlObj instanceof Synonym && (cf = (ci = this.getConnectionInfo(schema = (syn = (Synonym)sqlObj).getSchema())).getFilter(filterName = String.valueOf(schema.getName()) + "::" + "DatatoolsSynonymFilterPredicate")) != null) {
            filtered = cf.isFiltered(objName);
        }
        return filtered;
    }

    private ConnectionInfo getConnectionInfo(Schema schema) {
        Database db = schema.getDatabase();
        ConnectionInfo ci = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(db);
        return ci;
    }
}

