/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.ddl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.DBToolsMessages;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.catalog.OracleColumn;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabaseLink;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDirectory;
import oracle.eclipse.tools.database.connectivity.catalog.OracleMaterializedView;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackage;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageBody;
import oracle.eclipse.tools.database.connectivity.catalog.OraclePackageSpecification;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSequence;
import oracle.eclipse.tools.database.connectivity.catalog.OracleView;
import oracle.eclipse.tools.database.connectivity.db.DBElementStore;
import oracle.eclipse.tools.database.connectivity.db.DatabaseObject;
import oracle.eclipse.tools.database.connectivity.db.SourceUtil;
import oracle.eclipse.tools.database.connectivity.editors.IPartEditContext;
import oracle.eclipse.tools.database.connectivity.editors.SourceInput;
import oracle.eclipse.tools.database.modelbase.db.DatabaseLink;
import oracle.eclipse.tools.database.modelbase.db.Directory;
import oracle.eclipse.tools.database.modelbase.db.MaterializedView;
import oracle.eclipse.tools.database.modelbase.db.OraPackage;
import oracle.eclipse.tools.database.modelbase.db.OraPublicSynonym;
import oracle.eclipse.tools.database.modelbase.db.OraSequence;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.PackageSpecification;
import oracle.eclipse.tools.database.modelbase.db.Synonym;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlBuilder;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.GenericCatalogMessages;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.Constraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.ReferentialActionType;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public class OracleDdlBuilder
extends GenericDdlBuilder {
    protected static final String IN = "IN";
    protected static final String OUT = "OUT";
    protected static final String INOUT = "INOUT";
    protected static final String LOCATOR = "LOCATOR";
    protected static final String EXTERNAL = "EXTERNAL";
    protected static final String RETURNS = "RETURNS";
    protected static final String CAST = "CAST";
    protected static final String FROM = "FROM";
    protected static final String COMMENT = "COMMENT";
    protected static final String IS = "IS";
    protected static final String COLUMN = "COLUMN";
    protected static final String MODE_DB2SQL = "MODE DB2SQL";
    private final SourceUtil su = new SourceUtil();

    private String createDatabaseObject(Schema schema, SQLObject o, boolean quoteIdentifiers, boolean qualifyNames) {
        DatabaseObject dbObject = new DatabaseObject();
        dbObject.setName(o.getName());
        dbObject.setType(((OracleObject)o).getOracleType());
        dbObject.setId(((OracleObject)o).getId());
        dbObject.setOwner(schema.getName());
        dbObject.setOracleObject((OracleObject)o);
        SourceInput si = new SourceInput(dbObject);
        this.su.setConnection(((ICatalogObject)o).getConnection());
        return this.su.getSource(si, quoteIdentifiers, qualifyNames);
    }

    public String createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(procedure.getSchema(), (SQLObject)procedure, quoteIdentifiers, qualifyNames);
    }

    public String createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(function.getSchema(), (SQLObject)function, quoteIdentifiers, qualifyNames);
    }

    public String createUserDefinedType(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(type.getSchema(), (SQLObject)type, quoteIdentifiers, qualifyNames);
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(trigger.getSchema(), (SQLObject)trigger, quoteIdentifiers, qualifyNames);
    }

    public String createPackageBody(PackageBody packageBody, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(((OraclePackageBody)packageBody).getOraclePackage().getSchema(), packageBody, quoteIdentifiers, qualifyNames);
    }

    public String createPackageSpecification(PackageSpecification packageSpec, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(((OraclePackageSpecification)packageSpec).getOraclePackage().getSchema(), packageSpec, quoteIdentifiers, qualifyNames);
    }

    public String createSequence(OraSequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(sequence.getSchema(), (SQLObject)sequence, quoteIdentifiers, qualifyNames);
    }

    public String createSynonym(Synonym synonym, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(synonym.getSchema(), synonym, quoteIdentifiers, qualifyNames);
    }

    public String dropTableCascadeConstraints(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames) + "CASCADE" + " " + "CONSTRAINT";
    }

    public String dropPackage(OraPackage oraPack, boolean quoteIdentifiers, boolean qualifyNames) {
        OraclePackage oraclePackage = (OraclePackage)oraPack;
        String schemaName = oraclePackage.getSchema().getName();
        String name = SourceUtil.getName(schemaName, oraclePackage.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + oraclePackage.getOracleType() + " " + name;
    }

    public String dropPackageBody(PackageBody packageBody, boolean quoteIdentifiers, boolean qualifyNames) {
        OraclePackageBody oracleBody = (OraclePackageBody)packageBody;
        String schemaName = oracleBody.getOraclePackage().getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleBody.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + ((OraclePackageBody)packageBody).getOracleType() + " " + name;
    }

    public String dropPackageSpecification(PackageSpecification packageSpec, boolean quoteIdentifiers, boolean qualifyNames) {
        OraclePackageSpecification oracleSpec = (OraclePackageSpecification)packageSpec;
        String schemaName = oracleSpec.getOraclePackage().getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleSpec.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + ((OraclePackageSpecification)packageSpec).getOracleType() + " " + name;
    }

    public String dropSequence(OraSequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        OracleSequence oracleSeq = (OracleSequence)sequence;
        String schemaName = oracleSeq.getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleSeq.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + oracleSeq.getOracleType() + " " + name;
    }

    public String dropDatabaseLink(DatabaseLink dbLink, boolean quoteIdentifiers, boolean qualifyNames) {
        OracleDatabaseLink oracleLink = (OracleDatabaseLink)dbLink;
        String schemaName = oracleLink.getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleLink.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + oracleLink.getOracleType() + " " + name;
    }

    public String dropDirectory(Directory dir, boolean quoteIdentifiers, boolean qualifyNames) {
        OracleDirectory oracleDir = (OracleDirectory)dir;
        String schemaName = oracleDir.getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleDir.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + oracleDir.getOracleType() + " " + name;
    }

    public String dropMaterializedView(MaterializedView matView, boolean quoteIdentifiers, boolean qualifyNames) {
        OracleMaterializedView oracleMatView = (OracleMaterializedView)matView;
        String schemaName = oracleMatView.getSchema().getName();
        String name = SourceUtil.getName(schemaName, oracleMatView.getName(), quoteIdentifiers, qualifyNames);
        return "DROP " + oracleMatView.getOracleType() + " " + name;
    }

    public String dropSynonym(Synonym syn, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = null;
        if (syn instanceof OraPublicSynonym) {
            name = SourceUtil.getName(null, syn.getName(), quoteIdentifiers, false);
        } else {
            String schemaName = syn.getSchema().getName();
            name = SourceUtil.getName(schemaName, syn.getName(), quoteIdentifiers, qualifyNames);
        }
        StringBuffer sb = new StringBuffer("DROP ");
        if (syn instanceof OraPublicSynonym) {
            sb.append("PUBLIC ");
        }
        sb.append(((OracleObject)((Object)syn)).getOracleType());
        sb.append(" ");
        sb.append(name);
        return sb.toString();
    }

    public String dropTableColumn(OracleColumn col, boolean cascadeConstraints, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer("ALTER TABLE ");
        String schemaName = col.getTable().getSchema().getName();
        String name = SourceUtil.getName(schemaName, col.getTable().getName(), quoteIdentifiers, qualifyNames);
        sb.append(name);
        sb.append(" ");
        sb.append("DROP");
        sb.append(" ");
        sb.append(COLUMN);
        sb.append(" ");
        if (quoteIdentifiers) {
            sb.append("\"");
        }
        sb.append(col.getName());
        if (quoteIdentifiers) {
            sb.append("\"");
        }
        if (cascadeConstraints) {
            sb.append(" ");
            sb.append("CASCADE");
            sb.append(" ");
            sb.append("CONSTRAINT");
        }
        return sb.toString();
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnDefinition = super.getColumnString(column, quoteIdentifiers);
        IdentitySpecifier spec = column.getIdentitySpecifier();
        ValueExpression v = column.getGenerateExpression();
        if (spec != null) {
            columnDefinition = String.valueOf(columnDefinition) + " GENERATED ALWAYS AS IDENTITY ";
            columnDefinition = String.valueOf(columnDefinition) + " (" + this.getIdentityString(spec) + ")";
        } else if (v != null) {
            columnDefinition = String.valueOf(columnDefinition) + " GENERATED ALWAYS AS " + v.getSQL();
        }
        return columnDefinition;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        String typeName = super.getDataTypeString(typedElement, schema);
        if (typeName.startsWith("TIMESTAMP") && typeName.indexOf(40) != -1) {
            int index1 = typeName.indexOf(40);
            int index2 = typeName.indexOf(41);
            String precisionStr = typeName.substring(index1, index2 + 1);
            String typeWOPre = typeName.substring(0, index1).trim();
            String posfix = typeWOPre.substring(9);
            if (posfix != null && posfix.length() > 0) {
                posfix = posfix.trim();
            }
            typeName = "TIMESTAMP " + precisionStr;
            if (posfix != null && posfix.length() > 0) {
                typeName = String.valueOf(typeName) + " " + posfix;
            }
        }
        return typeName;
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    protected String getParameters(Routine routine) {
        String parameters = "";
        Iterator it = routine.getParameters().iterator();
        while (it.hasNext()) {
            Parameter p = (Parameter)it.next();
            ParameterMode mode = p.getMode();
            if (mode == ParameterMode.INOUT_LITERAL) {
                parameters = String.valueOf(parameters) + "INOUT ";
            } else if (mode == ParameterMode.OUT_LITERAL) {
                parameters = String.valueOf(parameters) + "OUT ";
            }
            String name = p.getName();
            if (name != null && name.length() != 0) {
                parameters = String.valueOf(parameters) + p.getName() + " ";
            }
            parameters = String.valueOf(parameters) + this.getDataTypeString((TypedElement)p, routine.getSchema());
            if (p.isLocator()) {
                parameters = String.valueOf(parameters) + " AS LOCATOR";
            }
            if (!it.hasNext()) continue;
            parameters = String.valueOf(parameters) + "," + GenericDdlBuilder.NEWLINE + "\t" + "\t";
        }
        return parameters;
    }

    protected String getExternalNameOption(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String option = String.valueOf(GenericDdlBuilder.NEWLINE) + "\t" + EXTERNAL;
        String externalName = routine.getExternalName();
        if (externalName != null && externalName.length() != 0) {
            String schemaName = routine.getSchema().getName();
            if (routine.getLanguage().equalsIgnoreCase("JAVA")) {
                externalName = this.getSingleQuotedString(externalName);
            } else {
                if (quoteIdentifiers) {
                    externalName = this.getDoubleQuotedString(externalName);
                    schemaName = this.getDoubleQuotedString(schemaName);
                }
                if (qualifyNames) {
                    externalName = String.valueOf(schemaName) + "." + externalName;
                }
            }
            option = String.valueOf(option) + " NAME " + externalName;
        }
        return option;
    }

    protected String getParameterStyleOption(Routine routine) {
        return String.valueOf(GenericDdlBuilder.NEWLINE) + "\t" + "PARAMETER STYLE " + routine.getParameterStyle();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            String text = "RETURNS " + this.getDataTypeString((TypedElement)scaler, function.getSchema());
            if (function.getReturnCast() != null) {
                Parameter cast = function.getReturnCast();
                text = String.valueOf(text) + " CAST FROM " + this.getDataTypeString((TypedElement)cast, function.getSchema());
            }
            return text;
        }
        if (function.getReturnTable() != null) {
            RoutineResultTable resultTable = function.getReturnTable();
            String text = "RETURNS TABLE (";
            Iterator it = resultTable.getColumns().iterator();
            while (it.hasNext()) {
                Column c = (Column)it.next();
                text = String.valueOf(text) + c.getName() + " " + this.getDataTypeString((TypedElement)c, function.getSchema());
                if (!it.hasNext()) continue;
                text = String.valueOf(text) + ", ";
            }
            text = String.valueOf(text) + ")";
            return text;
        }
        Parameter parameter = function.getReturnCast();
        if (parameter != null) {
            return parameter.getName();
        }
        return null;
    }

    public PreparedStatement createTableAlterStatement(DatabaseObject dbo, String[] columns) throws SQLException {
        return dbo.getConnection().prepareStatement("ALTER TABLE ?.? ? ? ?(?)");
    }

    public String createGrantQuery(DatabaseObject dbo, Object[] privileges, String toUser) throws SQLException {
        StringBuffer buf = new StringBuffer("grant ");
        int i = 0;
        while (i < privileges.length) {
            buf.append(privileges[i]);
            if (i < privileges.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(" on ");
        if (dbo.getType().equals("DIRECTORY")) {
            buf.append("directory ");
            buf.append(dbo.getName());
        } else {
            buf.append(dbo.getOwner());
            buf.append(".");
            buf.append(dbo.getName());
        }
        buf.append(" to ");
        buf.append(toUser);
        return buf.toString();
    }

    public String createRevokeQuery(DatabaseObject dbo, Object[] privileges, String fromUser) throws SQLException {
        StringBuffer buf = new StringBuffer("revoke ");
        int i = 0;
        while (i < privileges.length) {
            buf.append(privileges[i]);
            if (i < privileges.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        buf.append(" on ");
        if (dbo.getType().equals("DIRECTORY")) {
            buf.append("directory ");
            buf.append(dbo.getName());
        } else {
            buf.append(dbo.getOwner());
            buf.append(".");
            buf.append(dbo.getName());
        }
        buf.append(" from ");
        buf.append(fromUser);
        return buf.toString();
    }

    public String getAlterTableSQL(String[] columnProps, ArrayList row, IPartEditContext context, String status) {
        MessageFormat sql = new MessageFormat("ALTER TABLE {0}.{1} {2} COLUMN {3} {4}({5})");
        int index = Arrays.asList(columnProps).indexOf("COLUMN_NAME");
        String colName = (String)row.get(index);
        List options = DBElementStore.getColumnValueOptions("Columns.TYPE_NAME");
        index = Arrays.asList(columnProps).indexOf("TYPE_NAME");
        Integer typeIndex = (Integer)row.get(index);
        String typeName = (String)options.get(typeIndex);
        index = Arrays.asList(columnProps).indexOf("COLUMN_SIZE");
        String colSize = row.get(index).toString();
        String alterSQL = "ADD";
        if (status.equals("DELETED")) {
            alterSQL = "DROP";
            sql = new MessageFormat("ALTER TABLE {0}.{1} {2} COLUMN {3}");
        } else if (status.equals("MODIFIED")) {
            alterSQL = "MODIFY";
        }
        return sql.format(new String[]{context.getDatabaseObject().getOwner(), context.getDatabaseObject().getName(), alterSQL, colName, typeName, colSize});
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String condnSQL = "";
        if (constraint.getSearchCondition() != null) {
            condnSQL = constraint.getSearchCondition().getSQL();
        }
        String text = "ADD CONSTRAINT " + constraintName + " " + "CHECK" + " " + "(" + condnSQL + ")";
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + " " + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        if (foreignKey.getReferencedTable() == null) {
            return null;
        }
        String parentKey = null;
        if (foreignKey.getReferencedMembers() != null) {
            parentKey = this.getForeignKeyReferencedColumns(foreignKey, quoteIdentifiers);
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + " " + "ADD" + " " + "CONSTRAINT" + " " + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + " " + "FOREIGN KEY" + " " + "(" + this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers) + ")" + NEWLINE;
        statement = String.valueOf(statement) + "\tREFERENCES " + this.getName((Table)foreignKey.getReferencedTable(), quoteIdentifiers, qualifyNames) + " " + "(" + parentKey + ")";
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + "\t" + "ON" + " " + "DELETE" + " ";
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        return statement;
    }

    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        if (view.getQueryExpression() == null) {
            assert (view instanceof OracleView);
            OracleView oracleView = (OracleView)view;
            try {
                String userName = oracleView.getConnection().getMetaData().getUserName();
                String warningMsg = String.format(DBToolsMessages.unableToGetViewSource, oracleView.getName(), userName);
                return warningMsg;
            }
            catch (SQLException e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        String viewDefinition = "CREATE ";
        viewDefinition = String.valueOf(viewDefinition) + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + " ";
        String columns = this.getViewColumnList(view);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + "(" + columns + ")" + " ";
        }
        viewDefinition = String.valueOf(viewDefinition) + "AS" + NEWLINE;
        viewDefinition = String.valueOf(viewDefinition) + view.getQueryExpression().getSQL();
        return viewDefinition;
    }

    public String createMaterializedView(OracleMaterializedView mview, boolean quoteIdentifiers, boolean qualifyNames) {
        return this.createDatabaseObject(mview.getSchema(), (SQLObject)mview, quoteIdentifiers, qualifyNames);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getForeignKeyReferencedColumns(ForeignKey fk, boolean quoteIdentifiers) {
        Iterator it = fk.getReferencedMembers().iterator();
        if (!it.hasNext()) {
            this.getEngineeringCallBack().writeMessage(MessageFormat.format(GenericCatalogMessages.FE_REFERENCE_CONSTAINT_HAS_NO_KEY, fk.getName()));
            return null;
        }
        Column c = (Column)it.next();
        String columnName = quoteIdentifiers ? this.getQuotedIdentifierString((SQLObject)c) : c.getName();
        String columns = columnName;
        while (it.hasNext()) {
            c = (Column)it.next();
            columnName = quoteIdentifiers ? this.getQuotedIdentifierString((SQLObject)c) : c.getName();
            columns = String.valueOf(columns) + ", " + columnName;
        }
        return columns;
    }
}

