/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.db.ConnectionUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.db.generic.JDBCConnection;

public class OracleJDBCConnection
extends JDBCConnection {
    private static Map<String, Connection> connections = new HashMap<String, Connection>();
    private static Map<Connection, Integer> sConnectionReferenceCount = new HashMap<Connection, Integer>();
    private String _productName = null;
    private Version version = null;

    public OracleJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public Version getProviderVersion() {
        return this.version;
    }

    private void initialize() {
        String _productBuild = "";
        String versionString = "";
        try {
            Connection con = (Connection)super.getRawConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            String vMajor = Integer.toString(dbmd.getDatabaseMajorVersion());
            String vMinor = Integer.toString(dbmd.getDatabaseMinorVersion());
            String version = dbmd.getDatabaseProductVersion();
            if (version.indexOf("\n") != -1) {
                version = version.substring(0, version.indexOf("\n"));
            }
            this._productName = version.substring(0, version.indexOf(String.valueOf(vMajor) + "." + vMinor) - 1);
            _productBuild = version.substring(version.lastIndexOf(" ", version.length())).trim();
            int _iMajor = version.indexOf(String.valueOf(vMajor) + "." + vMinor);
            versionString = version.substring(_iMajor, version.indexOf(" ", _iMajor));
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        int[] v = new int[5];
        String[] components = versionString.split("\\.", 5);
        int i = 0;
        while (i < components.length) {
            if (components[i].trim().length() > 0) {
                v[i] = Integer.parseInt(components[i].trim());
            }
            ++i;
        }
        this.version = new Version(v[0], v[1], v[2], String.valueOf(v[3]) + "." + v[4] + " - " + _productBuild);
    }

    public String getProviderName() {
        if (this._productName == null) {
            this.initialize();
        }
        return this._productName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Connection connection = (Connection)this.getRawConnection();
        if (connection == null) {
            return;
        }
        Map<String, Connection> map = connections;
        synchronized (map) {
            int count = sConnectionReferenceCount.get(connection);
            if (count == 1) {
                try {
                    super.close();
                    String connectionKey = this.getConnectionKey();
                    connections.remove(connectionKey);
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
            } else {
                sConnectionReferenceCount.put(connection, --count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createConnection(ClassLoader cl) throws Throwable {
        Connection connection;
        Map<String, Connection> map = connections;
        synchronized (map) {
            String connectionKey = this.getConnectionKey();
            if (connections.containsKey(connectionKey)) {
                connection = connections.get(connectionKey);
                if (connection.isClosed()) {
                    connection = (Connection)this.createConn(cl);
                }
                Integer o = sConnectionReferenceCount.get(connection);
                int count = 0;
                if (o != null) {
                    count = o;
                }
                sConnectionReferenceCount.put(connection, ++count);
            } else {
                connection = (Connection)this.createConn(cl);
                connections.put(connectionKey, connection);
                sConnectionReferenceCount.put(connection, 1);
            }
        }
        return connection;
    }

    private Object createConn(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        String uid = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String pwd = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        String nameValuePairs = props.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        String propDelim = ",";
        if (ConnectionUtil.loginAsSYSDBA(props)) {
            connectionProps.setProperty("internal_logon", "sysdba");
        } else if (ConnectionUtil.loginAsSYSOPER(props)) {
            connectionProps.setProperty("internal_logon", "sysoper");
        }
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, ",");
            String addPairs = "";
            int i = 0;
            while (i < pairs.length) {
                String[] namevalue = this.parseString(pairs[i], "=");
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = String.valueOf(addPairs) + propDelim;
                }
                addPairs = String.valueOf(addPairs) + pairs[i];
                ++i;
            }
        }
        Driver jdbcDriver = (Driver)cl.loadClass(driverClass).newInstance();
        return jdbcDriver.connect(connectURL, connectionProps);
    }

    private String getBaseDBURL() {
        String connectURL = this.getConnectionProfile().getBaseProperties().getProperty("org.eclipse.datatools.connectivity.db.URL");
        int propertyStart = connectURL.indexOf(59);
        String baseURL = propertyStart < 0 ? connectURL : connectURL.substring(0, propertyStart);
        return baseURL;
    }

    private String getConnectionKey() {
        Properties props = this.getConnectionProfile().getBaseProperties();
        String uname = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String dbName = String.valueOf(uname) + "@" + this.getBaseDBURL();
        if (ConnectionUtil.loginAsSYSDBA(props)) {
            dbName = String.valueOf(dbName) + "@SYSDBA";
        } else if (ConnectionUtil.loginAsSYSOPER(props)) {
            dbName = String.valueOf(dbName) + "@SYSOPER";
        }
        dbName = String.valueOf(dbName) + "@SAVEPASSWRD=" + props.getProperty("org.eclipse.datatools.connectivity.db.savePWD");
        return dbName;
    }

    void setAutoCommit(boolean state) {
        try {
            if (this.getRawConnection() != null) {
                ((Connection)this.getRawConnection()).setAutoCommit(state);
            }
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
    }
}

