/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleColumn;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.connectivity.catalog.OracleParameter;
import oracle.eclipse.tools.database.modelbase.db.PackageBody;
import oracle.eclipse.tools.database.modelbase.db.impl.OraUserDefinedFunctionImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.ParameterMode;
import org.eclipse.datatools.modelbase.sql.routines.RoutineResultTable;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesFactory;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleFunction
extends OraUserDefinedFunctionImpl
implements ICatalogObject,
OracleObject,
IPrivilegeObject,
OracleObjectAction {
    private String id;
    private String status;
    private static final long serialVersionUID = -4727513567538832452L;
    public static final String TYPE = "FUNCTION";
    private boolean parameterLoaded = false;
    private boolean sourceLoaded = false;
    private PreparedStatement _stmt = null;
    private static String _sql = "SELECT text FROM all_source WHERE name = ? AND owner= ? AND type = 'FUNCTION'";

    @Override
    public String[] getSupportedPrivileges() {
        return PRIVILEGES3.toArray(new String[PRIVILEGES3.size()]);
    }

    @Override
    public PackageBody getPackageBody() {
        return super.getPackageBody();
    }

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    public synchronized void refresh() {
        this.sourceLoaded = false;
        this.parameterLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    public synchronized EList getParameters() {
        if (!this.parameterLoaded) {
            this.loadParameters();
        }
        return this.parameters;
    }

    public synchronized Source getSource() {
        if (!this.sourceLoaded) {
            this.loadSource();
        }
        return this.source;
    }

    private synchronized void loadSource() {
        boolean deliver;
        block17: {
            if (this.sourceLoaded) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            Source src = SQLRoutinesFactory.eINSTANCE.createSource();
            ResultSet rs = null;
            try {
                try {
                    if (this._stmt == null) {
                        this._stmt = this.getConnection().prepareStatement(_sql);
                    }
                    this._stmt.setString(1, this.getName().toUpperCase());
                    this._stmt.setString(2, this.getSchema().getName().toUpperCase());
                    String body = "";
                    rs = this._stmt.executeQuery();
                    while (rs.next()) {
                        String text = rs.getString("text");
                        body = String.valueOf(body) + text;
                    }
                    src.setBody(body);
                    this.setSource(src);
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.sourceLoaded = true;
        this.eSetDeliver(deliver);
    }

    private synchronized void loadParameters() {
        if (this.parameterLoaded) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            OracleFunction.loadParameters(this.getConnection(), super.getParameters(), this);
        }
        catch (Exception e) {
            LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
        }
        this.parameterLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadParameters(Connection connection, EList parameterList, OracleFunction function) throws SQLException {
        Database database = function.getSchema().getDatabase();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database);
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet r = metaData.getProcedureColumns("", function.getSchema().getName(), function.getName(), null);
        try {
            try {
                while (r.next()) {
                    boolean isTableReturnedAsResult = false;
                    r.getString(2);
                    r.getString(3);
                    String name = r.getString(4);
                    short columntype = r.getShort(5);
                    if (columntype == 3) {
                        isTableReturnedAsResult = true;
                    }
                    PredefinedDataType type = null;
                    String typeName = r.getString(7);
                    PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
                    if (typeDefinition != null) {
                        EStructuralFeature feature;
                        int length;
                        type = databaseDefinition.getPredefinedDataType(typeDefinition);
                        if (typeDefinition.isLengthSupported()) {
                            length = r.getInt(9);
                            feature = type.eClass().getEStructuralFeature("length");
                            type.eSet(feature, (Object)length);
                        } else if (typeDefinition.isPrecisionSupported()) {
                            int length2 = r.getInt(8);
                            feature = type.eClass().getEStructuralFeature("precision");
                            type.eSet(feature, (Object)length2);
                        }
                        if (typeDefinition.isScaleSupported()) {
                            length = r.getInt(10);
                            feature = type.eClass().getEStructuralFeature("scale");
                            type.eSet(feature, (Object)length);
                        }
                    }
                    if (isTableReturnedAsResult) {
                        RoutineResultTable resultTable = function.getReturnTable();
                        if (resultTable == null) {
                            resultTable = (RoutineResultTable)factory.create(SQLRoutinesPackage.eINSTANCE.getRoutineResultTable());
                            function.setReturnTable(resultTable);
                        }
                        OracleColumn column = new OracleColumn();
                        column.setName(name);
                        column.setDescription(r.getString(13));
                        column.setDataType((DataType)type);
                        resultTable.getColumns().add((Object)column);
                        continue;
                    }
                    OracleParameter parameter = new OracleParameter();
                    parameter.setName(name);
                    parameter.setMode(ParameterMode.get((int)columntype));
                    parameter.setDescription(r.getString(13));
                    parameter.setDataType((DataType)type);
                    if (columntype == 5) {
                        function.setReturnScalar((Parameter)parameter);
                        continue;
                    }
                    parameterList.add((Object)parameter);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }
}

