/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDefaultCatalog;
import oracle.eclipse.tools.database.connectivity.catalog.OracleSchema;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.impl.DatabaseImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OracleDatabase
extends DatabaseImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3492382304965516394L;
    private boolean schemasLoaded = false;
    private boolean allSchemasLoaded = false;
    private List<Schema> allSchemas;
    protected Connection connection = null;
    private boolean catalogsLoaded = false;
    public static final String TYPE = "DATABASE";
    private transient ConnectionFilterListener filterListener;

    public OracleDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public String getOracleType() {
        return TYPE;
    }

    public synchronized void refresh() {
        if (this.schemasLoaded) {
            this.schemasLoaded = false;
            this.schemas.clear();
        }
        if (this.allSchemasLoaded) {
            this.allSchemasLoaded = false;
            this.allSchemas.clear();
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public synchronized EList getSchemas() {
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    public synchronized List getAllSchemas() {
        if (!this.allSchemasLoaded) {
            this.loadAllSchemas();
        }
        return this.allSchemas;
    }

    public synchronized EList getCatalogs() {
        if (!this.catalogsLoaded) {
            this.catalogs = super.getCatalogs();
            OracleDefaultCatalog catalog = new OracleDefaultCatalog(this);
            catalog.setName("");
            this.catalogs.add((Object)catalog);
            this.catalogsLoaded = true;
        }
        return this.catalogs;
    }

    protected synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        EList schemaList = super.getSchemas();
        Statement stmt = null;
        ResultSet r = null;
        try {
            try {
                ConnectionInfo connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this);
                ConnectionFilter filter = connectionInfo.getFilter(this.getFilterKey());
                if (filter == null) {
                    filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
                }
                String sql = "SELECT USERNAME FROM ALL_USERS";
                if (filter != null) {
                    sql = String.valueOf(sql) + " WHERE USERNAME " + filter.getPredicate();
                }
                stmt = this.connection.createStatement();
                r = stmt.executeQuery(sql);
                while (r.next()) {
                    String schemaName = r.getString(1);
                    OracleSchema schema = new OracleSchema();
                    schema.setName(schemaName);
                    schemaList.add((Object)schema);
                }
                this.schemasLoaded = true;
                if (this.filterListener == null) {
                    this.filterListener = new FilterListener();
                    connectionInfo.addFilterListener(this.filterListener);
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    private synchronized void loadAllSchemas() {
        this.allSchemas = new ArrayList<Schema>();
        Statement stmt = null;
        ResultSet r = null;
        try {
            try {
                String sql = "SELECT USERNAME FROM ALL_USERS ORDER BY USERNAME";
                stmt = this.connection.createStatement();
                r = stmt.executeQuery(sql);
                while (r.next()) {
                    String schemaName = r.getString(1);
                    OracleSchema schema = new OracleSchema();
                    schema.setName(schemaName);
                    schema.setDatabase((Database)this);
                    this.allSchemas.add(schema);
                }
                this.allSchemasLoaded = true;
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                try {
                    if (r != null) {
                        r.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Exception e2) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private void handleFilterChanged(String filterKey) {
        ConnectionInfo conInf;
        if (!this.schemasLoaded) {
            return;
        }
        if (filterKey.equals(this.getFilterKey())) {
            this.refresh();
        } else if ("DatatoolsSchemaFilterPredicate".equals(filterKey) && (conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase((Database)this)) != null && conInf.getFilter(this.getFilterKey()) == null) {
            this.refresh();
        }
    }

    private String getFilterKey() {
        return String.valueOf(this.getName()) + "::" + "DatatoolsSchemaFilterPredicate";
    }

    private class FilterListener
    implements ConnectionFilterListener {
        private FilterListener() {
        }

        public void connectionFilterAdded(String filterKey) {
            OracleDatabase.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            OracleDatabase.this.handleFilterChanged(filterKey);
        }
    }
}

