/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.database.connectivity.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.database.OraclePlugin;
import oracle.eclipse.tools.database.connectivity.actions.IOracleDropableObject;
import oracle.eclipse.tools.database.connectivity.actions.IPrivilegeObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObject;
import oracle.eclipse.tools.database.connectivity.actions.OracleObjectAction;
import oracle.eclipse.tools.database.connectivity.catalog.OracleDatabase;
import oracle.eclipse.tools.database.modelbase.db.impl.ComposedTypeImpl;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class OracleComposedType
extends ComposedTypeImpl
implements ICatalogObject,
OracleObject,
IOracleDropableObject,
OracleObjectAction,
IPrivilegeObject {
    private static final long serialVersionUID = 8449699773477306991L;
    private String id;
    private String status;
    private PreparedStatement stmt = null;
    private boolean attributesLoaded = false;
    public static final String TYPE = "TYPE";

    @Override
    public String getOracleType() {
        return TYPE;
    }

    @Override
    public String getOwner() {
        return this.getSchema().getName();
    }

    @Override
    public String[] getSupportedPrivileges() {
        return PRIVILEGES3.toArray(new String[PRIVILEGES3.size()]);
    }

    public synchronized void refresh() {
        this.attributesLoaded = false;
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean isSystemObject() {
        return false;
    }

    @Override
    public Connection getConnection() {
        Database database = this.getCatalogDatabase();
        return ((OracleDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getDatabase();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public synchronized EList getAttributes() {
        if (!this.attributesLoaded) {
            this.loadAttributes();
        }
        return this.attributes;
    }

    private synchronized void loadAttributes() {
        boolean deliver;
        block17: {
            if (this.attributesLoaded) {
                return;
            }
            EList attrs = super.getAttributes();
            attrs.clear();
            Connection connection = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            ResultSet r = null;
            try {
                try {
                    if (this.stmt == null) {
                        this.stmt = connection.prepareStatement("SELECT attr_name, attr_type_name FROM USER_TYPE_ATTRS WHERE type_name=?");
                    }
                    this.stmt.setString(1, this.getName());
                    r = this.stmt.executeQuery();
                    while (r.next()) {
                        String attr_name = r.getString("attr_name");
                        String attr_type_name = r.getString("attr_type_name");
                        DataType datatype = (DataType)this.getDataType(attr_type_name);
                        datatype.setName(attr_name);
                        attrs.add((Object)datatype);
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                    try {
                        if (r != null) {
                            r.close();
                        }
                        break block17;
                    }
                    catch (Exception e2) {
                        LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (r != null) {
                        r.close();
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
                }
                throw throwable;
            }
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (Exception e) {
                LoggingService.logException((Plugin)OraclePlugin.getInstance(), (Throwable)e);
            }
        }
        this.attributesLoaded = true;
        this.eSetDeliver(deliver);
    }

    private EObject getDataType(String type) {
        EClass eclaz = null;
        eclaz = type.equalsIgnoreCase("VARCHAR2") ? SQLDataTypesPackage.eINSTANCE.getCharacterStringDataType() : SQLDataTypesPackage.eINSTANCE.getStructuredUserDefinedType();
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getSchema().getDatabase());
        DataModelElementFactory factory = databaseDefinition.getDataModelElementFactory();
        return factory.create(eclaz);
    }
}

