/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.util.Service;

public class VolumeTest {
    static boolean isSQL = false;
    private static Connection c = null;
    private static String query = null;
    private static ResultSet rs = null;

    public static String nextPLSQL() throws Exception {
        int line;
        StringBuffer sb = new StringBuffer();
        for (int priorLine = 0; (line = rs.getInt("line")) != 1 || priorLine == 0; ++priorLine) {
            sb.append(rs.getString("text"));
            if (!rs.next()) break;
        }
        return sb.toString();
    }

    public static String nextSQL() throws Exception {
        if (rs.next()) {
            return rs.getString(1);
        }
        return null;
    }

    public static String next() throws Exception {
        if (isSQL) {
            return VolumeTest.nextSQL();
        }
        return VolumeTest.nextPLSQL();
    }

    public static void main(String[] args) throws Exception {
        TreeSet<Integer> goal = new TreeSet<Integer>();
        if (!isSQL) {
            goal.add(PlsqlCYK.getInstance().getSymbol("compilation_unit"));
        }
        String text = null;
        int count = 0;
        int cumulativeTime = 0;
        int cumulativeMembers = 0;
        while ((text = VolumeTest.next()) != null) {
            if (++count % 10 == 0) {
                System.out.println("============== " + count + " ==============");
                System.out.println("Cumulative parse time: " + cumulativeTime);
                System.out.println("Cumulative member count: " + cumulativeMembers);
            }
            try {
                long t1 = System.currentTimeMillis();
                int[] s = VolumeTest.parse(text);
                long t2 = System.currentTimeMillis();
                cumulativeTime = (int)((long)cumulativeTime + (t2 - t1));
                boolean ok = false;
                Iterator i$ = goal.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    for (int ii : s) {
                        if (Service.Y(ii) != i) continue;
                        ok = true;
                    }
                }
                if (ok) continue;
                System.out.println(text);
                return;
            }
            catch (Exception e) {
                System.out.println(count);
                System.out.println(e.getMessage());
                if (e.getMessage() != null && e.getMessage().contains("Skipped")) continue;
                System.out.println(text);
                e.printStackTrace();
                return;
            }
        }
    }

    static int[] parse(String txt) throws Exception {
        LinkedList<LexerToken> src = LexerToken.parse(txt);
        long t1 = System.currentTimeMillis();
        Matrix ret = VolumeTest.getInstance().initArray1(src);
        int begin = 0;
        int end = ret.size();
        int size = ret.size();
        TreeMap<Integer, Integer> skipRanges = new TreeMap<Integer, Integer>();
        t1 = System.currentTimeMillis();
        VolumeTest.getInstance().closure(ret, 0, size + 1, skipRanges, -1);
        long t2 = System.currentTimeMillis();
        int[] s = (int[])ret.get(Service.pair(begin, end));
        System.out.print("txt.length=" + txt.length());
        System.out.print(", #tokens=" + end);
        System.out.println(", time = " + (t2 - t1));
        return s;
    }

    private static CYK getInstance() {
        if (isSQL) {
            return null;
        }
        return PlsqlCYK.getInstance();
    }

    static {
        try {
            Class.forName("oracle.jdbc.OracleDriver");
            if (isSQL) {
                c = DriverManager.getConnection("jdbc:oracle:thin:@stbbb08:1526:VIS", "sqlrepo", "sqlrepo");
                query = "select sql_text||';' from statements\nwhere sql_id between 0 and 20000\nand length(sql_text) between 1000 and 5000\nand sql_text not like '%:symbolic_arguments:i_symargs%'\nand sql_text not like '%for update of order_number%'\nand sql_text not like '%and service_line_id = :B2 for update of unit_effectivity_id%'\norder by sql_id";
            } else {
                c = DriverManager.getConnection("jdbc:oracle:thin:@rws60115rems.us.oracle.com:1552:seed120", "apps_read_only", "apps");
                query = "select * from dba_source\nwhere owner = 'APPS'\nand type = 'PACKAGE BODY'\nand name like 'AMS%'order by name,line";
            }
            PreparedStatement stmt = c.prepareStatement(query);
            rs = stmt.executeQuery();
            rs.next();
        }
        catch (Exception e) {
            throw new RuntimeException("failed to connect to database");
        }
    }
}

