/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.plsql.LazyNode;
import oracle.dbtools.util.Service;

public class StackParser {
    public static LazyNode parse(LinkedList<LexerToken> src) {
        LinkedList<LazyNode> stack = new LinkedList<LazyNode>();
        LazyNode pseudoRoot = new LazyNode(0, "pseudo root", src);
        pseudoRoot.to = src.size();
        stack.add(pseudoRoot);
        LexerToken prior = null;
        LexerToken prior2 = null;
        int pos = -1;
        for (LexerToken tok : src) {
            ++pos;
            if (stack.size() == 0 || tok == null) break;
            String token = tok.content;
            LazyNode candidate = new LazyNode(pos, token, src);
            LazyNode top = (LazyNode)stack.getLast();
            if (candidate.isDDL() && (prior == null || prior.type == Token.OPERATION) || candidate.isAs() && top.isCompilationUnit() || candidate.isCompilationUnit() && !top.isDDL() && (prior == null || !".".equals(prior.content)) || candidate.isDML() && !top.isDML() && !"(".equals(top.startToken) && !top.isDDL() && !top.isAs() && (prior == null || !"with".equalsIgnoreCase(token) || !"time".equalsIgnoreCase(prior.content) && !"timestamp".equalsIgnoreCase(prior.content)) || "declare".equalsIgnoreCase(token) && !top.isDDL() && !top.isAs() || "begin".equalsIgnoreCase(token) && !top.isAs() && !top.isDDL() || "if".equalsIgnoreCase(token) && !"end".equalsIgnoreCase(prior.content) && !top.isDDL() || "case".equalsIgnoreCase(token) && !"end".equalsIgnoreCase(prior.content) && !top.isDDL() || "loop".equalsIgnoreCase(token) && !"end".equalsIgnoreCase(prior.content) && !top.isDDL() || "for".equalsIgnoreCase(token) && prior2 != null && !"open".equalsIgnoreCase(prior2.content) && !top.isDDL() && !top.isAs() || "while".equalsIgnoreCase(token) && !top.isDDL() || "(".equals(token)) {
                stack.add(candidate);
            } else if ("begin".equalsIgnoreCase(token) && top.isAs() || candidate.isCompilationUnit() && top.isDDL()) {
                top.to = pos;
                stack.removeLast();
                if (stack.size() == 0) {
                    return new LazyNode(0, "error", src);
                }
                ((LazyNode)stack.getLast()).addTopLevel(top);
                stack.add(candidate);
            } else if (";".equals(token) && top.isCompilationUnit() || ";".equals(token) && top.isDML() || ";".equals(token) && top.isDDL() || ";".equals(token) && "if".equalsIgnoreCase(top.startToken) && "if".equalsIgnoreCase(prior.content) || ";".equals(token) && "for".equalsIgnoreCase(top.startToken) && "loop".equalsIgnoreCase(prior.content) || ";".equals(token) && "while".equalsIgnoreCase(top.startToken) && "loop".equalsIgnoreCase(prior.content) || ";".equals(token) && "declare".equalsIgnoreCase(top.startToken) && "end".equalsIgnoreCase(prior.content) || "end".equalsIgnoreCase(token) && "case".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "begin".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && "loop".equalsIgnoreCase(top.startToken) || "end".equalsIgnoreCase(token) && top.isAs() || ")".equals(token)) {
                top.to = pos + 1;
                stack.removeLast();
                if (stack.size() == 0) {
                    return new LazyNode(0, "error", src);
                }
                ((LazyNode)stack.getLast()).addTopLevel(top);
            }
            prior2 = prior;
            prior = tok;
        }
        if (pseudoRoot.shallowChildren().size() == 0 && pseudoRoot.from < src.size()) {
            pseudoRoot.startToken = src.get((int)pseudoRoot.from).content;
        }
        if (pseudoRoot.shallowChildren().size() == 1) {
            for (LazyNode child : pseudoRoot.shallowChildren()) {
                if (child.from != pseudoRoot.from || child.to != pseudoRoot.to) continue;
                pseudoRoot = child;
            }
        }
        return pseudoRoot;
    }

    public static void main(String[] dummy) throws Exception {
        String input = Service.readFile(StackParser.class, "test.sql");
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        long t1 = System.currentTimeMillis();
        LinkedList<LexerToken> src = LexerToken.parse(input);
        LexerToken.print(src);
        LazyNode root = StackParser.parse(src);
        System.gc();
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        long t2 = System.currentTimeMillis();
        System.out.println("time = " + (t2 - t1));
        HashSet<Long> tmp = new HashSet<Long>();
        for (ParseNode desc : root.descendants()) {
            Iterator i$ = tmp.iterator();
            while (i$.hasNext()) {
                long t = (Long)i$.next();
                int x = Service.lX(t);
                int y = Service.lY(t);
                if ((desc.from >= x || x >= desc.to || desc.to >= y) && (x >= desc.from || desc.from >= y || y >= desc.to)) continue;
                System.out.println("[x,y)=[" + x + "," + y + ")\n" + "[from,to)=" + "[" + desc.from + "," + desc.to + ")");
                t2 = System.currentTimeMillis();
                System.out.println("time = " + (t2 - t1));
                System.exit(0);
            }
            tmp.add(Service.lPair(desc.from, desc.to));
        }
        root.printTree();
    }
}

