/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.util.Service;

public class SqlRules {
    static boolean test = false;
    static boolean debugNoRecursiveDescend = false;
    private static char[] identifiers = new char[]{'(', ')', '\'', ',', ';', ':', '=', '+', '-', '*', '/', '@', '!', '^', 'e', 'f', 'd'};
    private static CYK cyk = SqlRules.bnfParser();
    private static final String fname = "serializedSqlBNF.xml";
    private static final String path = "/oracle/dbtools/parser/plsql/";
    private static Set<String> notFound = new HashSet<String>();

    public static void main(String[] args) throws Exception {
        if (test) {
            SqlRules.testParseSqlBnf();
        } else {
            SqlRules.memorizeRules();
        }
    }

    private static void testParseSqlBnf() throws Exception {
        debugNoRecursiveDescend = true;
        String input = Service.readFile("d:/eclipse/raptor_trunk/utils-nodeps/src/oracle/dbtools/parser/plsql/testsql.bnf");
        LinkedList<LexerToken> src = LexerToken.parse(input, false, false);
        SqlRules.correctDots(src);
        Visual visual = new Visual(src, cyk);
        LexerToken.print(src);
        Matrix matrix = cyk.initArray1(src);
        int size = matrix.size();
        cyk.closure(matrix, 0, size + 1, null, -1);
        ParseNode root = cyk.forest(size, matrix);
        root.printTree();
        TreeSet<RuleTuple> output = new TreeSet<RuleTuple>();
        SqlRules.descend(root, output, "data_mining_function", src);
        System.out.println("-------------Chomsky Rules---------------");
        for (RuleTuple rule : output) {
            System.out.println(rule.toString());
        }
        System.out.println("-------------------------------------");
    }

    private static void bnfIdentifiers(Set<RuleTuple> rules) {
        for (char id : identifiers) {
            rules.add(new RuleTuple("identifier", new String[]{"'" + id + "'"}));
        }
    }

    private static CYK bnfParser() {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        rules.add(new RuleTuple("pre", new String[]{"'pre'"}));
        rules.add(new RuleTuple("pre", new String[]{"'PRE'"}));
        rules.add(new RuleTuple("b", new String[]{"'b'"}));
        rules.add(new RuleTuple("b", new String[]{"'B'"}));
        SqlRules.bnfIdentifiers(rules);
        rules.add(new RuleTuple("qualifid", new String[]{"identifier", "'.'", "identifier"}));
        rules.add(new RuleTuple("block", new String[]{"identifier"}));
        rules.add(new RuleTuple("block", new String[]{"qualifid"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "rawbnf", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "'['", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "']'", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "'|'", "'|'", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("lt", new String[]{"'<'"}));
        rules.add(new RuleTuple("gt", new String[]{"'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "lt", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "gt", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("boldrawbnf", new String[]{"'<'", "b", "'>'", "lt", "gt", "'<'", "'/'", "b", "'>'"}));
        rules.add(new RuleTuple("block", new String[]{"boldrawbnf"}));
        rules.add(new RuleTuple("block", new String[]{"bnfid"}));
        rules.add(new RuleTuple("block", new String[]{"'['", "rawbnf", "']'"}));
        rules.add(new RuleTuple("block", new String[]{"'{'", "rawbnf", "'}'"}));
        rules.add(new RuleTuple("block", new String[]{"'{'", "rawbnf", "'}'", "'.'", "'.'", "'.'"}));
        rules.add(new RuleTuple("block", new String[]{"'['", "rawbnf", "']'", "'.'", "'.'", "'.'"}));
        rules.add(new RuleTuple("concat", new String[]{"block"}));
        rules.add(new RuleTuple("concat", new String[]{"block", "concat"}));
        rules.add(new RuleTuple("rawbnf", new String[]{"concat"}));
        rules.add(new RuleTuple("rawbnf", new String[]{"concat", "'|'", "rawbnf"}));
        rules.add(new RuleTuple("bnf", new String[]{"'<'", "pre", "'>'", "rawbnf", "'<'", "'/'", "pre", "'>'"}));
        rules.add(new RuleTuple("bnf", new String[]{"'<'", "pre", "identifier", "'>'", "rawbnf", "'<'", "'/'", "pre", "'>'"}));
        rules.add(new RuleTuple("bnflist", new String[]{"bnf"}));
        rules.add(new RuleTuple("bnflist", new String[]{"bnflist", "bnflist"}));
        cyk = new CYK(rules){

            @Override
            public int[] atomicSymbols() {
                return new int[]{(Integer)this.symbolIndexes.get("bnflist")};
            }
        };
        return cyk;
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> sqlRules = new TreeSet<RuleTuple>();
        sqlRules.add(new RuleTuple("#", new String[]{"'#'"}));
        sqlRules.add(new RuleTuple("access_driver_type", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("aggregate_function", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("alias", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("argument", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("attribute", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("c_alias", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("char1", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("char2", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("cluster", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("class", new String[]{"literal"}));
        sqlRules.add(new RuleTuple("class_value", new String[]{"literal"}));
        sqlRules.add(new RuleTuple("cost_value", new String[]{"literal"}));
        sqlRules.add(new RuleTuple("collection_item", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("column_expression", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("column_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("comparison_expr", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("constant", new String[]{"literal"}));
        sqlRules.add(new RuleTuple("constraint_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("constraint", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("data_item", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("dimension_column", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("else_expr", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("esc_char", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("expr1", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("expr2", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("expr3", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("filename", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("fractional_seconds_precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("fractional_second_precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("hash_partition_quantity", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("hash_subpartition_quantity", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("index", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("integer", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("java_ext_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("leading_field_precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("len", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("lib_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"number"}));
        sqlRules.add(new RuleTuple("literal", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("LOB_item", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("LOB_segname", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("main_model_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("measure_column", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("method", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("model", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("nested_item", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("nested_table", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("nested_table1", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("nested_table2", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("new_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("new_table_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("object", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("object_table_alias", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("old_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("old_password", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("package", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("parameter", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("partition", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("password", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("pattern", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("position", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("precision", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("procedure_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("query_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("reference_spreadsheet_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("return_expr", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("role", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("sample_percent", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("scale", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("schema", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("scope_table", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("seed_value", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("sequence", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("size", new String[]{"digits"}));
        sqlRules.add(new RuleTuple("storage_table", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("string", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("string", new String[]{"string_literal"}));
        sqlRules.add(new RuleTuple("subpartition", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("synonym", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("t_alias", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("table", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("tablespace", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("table_alias", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("tablespace", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("type_name", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("type", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("user", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("user_defined_types", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("value_expr", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("value_expression", new String[]{"expr"}));
        sqlRules.add(new RuleTuple("view", new String[]{"identifier"}));
        sqlRules.add(new RuleTuple("variable_expression", new String[]{"':'", "identifier"}));
        sqlRules.add(new RuleTuple("variable_expression", new String[]{"':'", "number"}));
        sqlRules.add(new RuleTuple("varray_type", new String[]{"identifier"}));
        SqlRules.recursiveCollectBNF(sqlRules, "create");
        SqlRules.recursiveCollectBNF(sqlRules, "alter");
        SqlRules.recursiveCollectBNF(sqlRules, "select");
        SqlRules.recursiveCollectBNF(sqlRules, "insert");
        SqlRules.recursiveCollectBNF(sqlRules, "delete");
        SqlRules.recursiveCollectBNF(sqlRules, "update");
        SqlRules.recursiveCollectBNF(sqlRules, "merge");
        SqlRules.recursiveCollectBNF(sqlRules, "SET_OPER");
        RuleTransforms.printSelectedRules("measure_column", sqlRules);
        sqlRules = RuleTransforms.eliminateEmptyProductions(sqlRules);
        RuleTransforms.substituteAll(sqlRules);
        RuleTransforms.substituteSymbol("<b>.</b>", "'.'", sqlRules);
        RuleTransforms.printSelectedRules("create", sqlRules);
        return sqlRules;
    }

    public static void memorizeRules() throws Exception {
        Set<RuleTuple> rules = SqlRules.extractRules();
        FileOutputStream fos = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/serializedSqlBNF.xml");
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL u = SqlRules.class.getResource("/oracle/dbtools/parser/plsql/serializedSqlBNF.xml");
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }

    private static void recursiveCollectBNF(Set<RuleTuple> output, String masterRuleName) throws Exception {
        if (SqlRules.contains(output, masterRuleName)) {
            return;
        }
        if (notFound.contains(masterRuleName)) {
            return;
        }
        if ("hint".equals(masterRuleName)) {
            return;
        }
        if (!debugNoRecursiveDescend && !SqlRules.fetchFromFixes(output, masterRuleName)) {
            SqlRules.fetchFromDocWebsite(output, masterRuleName);
        }
    }

    private static void fetchFromDocWebsite(Set<RuleTuple> output, String masterRuleName) throws Exception {
        String sqlBNFfiles = "http://st-doc.us.oracle.com/sql_grammar/sqlbnf/bnffiles";
        String input = null;
        try {
            input = SqlRules.readURL("http://st-doc.us.oracle.com/sql_grammar/sqlbnf/bnffiles/" + masterRuleName + ".htm");
        }
        catch (Exception e) {
            input = SqlRules.readURL("http://st-doc.us.oracle.com/sql_grammar/sqlbnf/bnffiles/" + masterRuleName + "s.htm");
        }
        LinkedList<LexerToken> src = LexerToken.parse(input, false, false);
        SqlRules.correctDots(src);
        System.out.println(masterRuleName + "...");
        Matrix ret = null;
        try {
            ret = cyk.initArray1(src);
        }
        catch (Exception e) {}
        int size = ret.size();
        cyk.closure(ret, 0, size + 1, null, -1);
        ParseNode root = cyk.forest(size, ret);
        if (!root.contains(SqlRules.cyk.symbolIndexes.get("bnf"))) {
            throw new Exception("failed to parse >>>" + masterRuleName + "<<< to bnf");
        }
        SqlRules.bnf(output, root, masterRuleName, src);
    }

    private static boolean contains(Set<RuleTuple> ret, String masterRuleName) {
        for (RuleTuple rule : ret) {
            if (!rule.head.equals(masterRuleName)) continue;
            return true;
        }
        return false;
    }

    private static ParseNode parseFixesFile(List<LexerToken> src, String input) throws Exception {
        SqlRules.correctDots(src);
        Matrix ret = cyk.initArray1(src);
        int size = ret.size();
        cyk.closure(ret, 0, size + 1, new TreeMap<Integer, Integer>(), -1);
        ParseNode root = cyk.forest(size, ret);
        if (!root.contains(SqlRules.cyk.symbolIndexes.get("bnflist"))) {
            int to;
            int from;
            ParseNode first = null;
            ParseNode second = null;
            for (ParseNode n : root.topLevel) {
                if (first == null) {
                    first = n;
                    continue;
                }
                if (second != null) break;
                second = n;
            }
            if ((from = src.get((int)(first.to - 1)).end) > (to = src.get((int)second.from).begin)) {
                int tmp = from;
                from = to;
                to = tmp;
            }
            System.out.println("..." + input.substring(from - 20, to + 20) + "...\n");
            throw new Exception("Parse error in SqlBnf.fixed");
        }
        return root;
    }

    private static boolean fetchFromFixes(Set<RuleTuple> output, String masterRuleName) throws Exception {
        String input = Service.readFile(SqlRules.class, "SqlBnf.fixed");
        LinkedList<LexerToken> src = LexerToken.parse(input, false, false);
        ParseNode root = SqlRules.parseFixesFile(src, input);
        return SqlRules.descend(root, output, masterRuleName, src);
    }

    private static boolean descend(ParseNode root, Set<RuleTuple> output, String masterRuleName, List<LexerToken> src) throws Exception {
        if (root.contains(SqlRules.cyk.symbolIndexes.get("bnf"))) {
            for (ParseNode child : root.children()) {
                if (!child.contains(SqlRules.cyk.symbolIndexes.get("identifier")) || !masterRuleName.equals(child.content(src))) continue;
                SqlRules.bnf(output, root, masterRuleName, src);
                return true;
            }
        }
        for (ParseNode child : root.children()) {
            if (!SqlRules.descend(child, output, masterRuleName, src)) continue;
            return true;
        }
        return false;
    }

    private static void correctDots(List<LexerToken> src) {
        int i = -1;
        for (LexerToken t : src) {
            if (!".".equals(t.content) || ++i != 0 && ".".equals(src.get((int)(i - 1)).content) || i != src.size() - 1 && ".".equals(src.get((int)(i + 1)).content)) continue;
            t.content = "<b>.</b>";
            t.type = Token.IDENTIFIER;
        }
    }

    static void bnf(Set<RuleTuple> output, ParseNode node, String head, List<LexerToken> src) throws Exception {
        for (ParseNode child : node.children()) {
            if (!child.contains(SqlRules.cyk.symbolIndexes.get("rawbnf"))) continue;
            output.add(new RuleTuple(head, new String[]{SqlRules.ruleName(head, child)}));
            SqlRules.evaluate(output, child, head, src, false);
            return;
        }
        throw new Exception("no rawbnf child");
    }

    private static void evaluate(Set<RuleTuple> output, ParseNode node, String head, List<LexerToken> src, boolean isBold) throws Exception {
        if (node.to == node.from + 1) {
            String id = src.get((int)node.from).content;
            if (id.length() == 1) {
                for (char bnfId : identifiers) {
                    if (id.charAt(0) != bnfId) continue;
                    isBold = true;
                }
            }
            if (isBold) {
                output.add(new RuleTuple(SqlRules.ruleName(head, node), new String[]{"'" + id + "'"}));
            } else {
                output.add(new RuleTuple(SqlRules.ruleName(head, node), new String[]{id}));
                if (!SqlRules.contains(output, id) && !notFound.contains(id)) {
                    try {
                        SqlRules.recursiveCollectBNF(output, id);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println(head + " -> " + id);
                        notFound.add(id);
                    }
                }
            }
        } else if (node.contains(SqlRules.cyk.symbolIndexes.get("boldrawbnf"))) {
            LinkedList<String> candidate = new LinkedList<String>();
            for (ParseNode child : node.children()) {
                if (child.contains(SqlRules.cyk.symbolIndexes.get("rawbnf"))) {
                    output.add(new RuleTuple(SqlRules.ruleName(head, node), new String[]{SqlRules.ruleName(head, child)}));
                    SqlRules.evaluate(output, child, head, src, true);
                    return;
                }
                if (!child.contains(SqlRules.cyk.symbolIndexes.get("lt")) && !child.contains(SqlRules.cyk.symbolIndexes.get("gt")) && !child.contains(SqlRules.cyk.symbolIndexes.get("'['")) && !child.contains(SqlRules.cyk.symbolIndexes.get("']'")) && !child.contains(SqlRules.cyk.symbolIndexes.get("'|'"))) continue;
                candidate.add("'" + src.get((int)child.from).content + "'");
            }
            if (candidate.size() > 0) {
                output.add(new RuleTuple(SqlRules.ruleName(head, node), candidate.toArray(new String[0])));
            }
        } else if (node.contains(SqlRules.cyk.symbolIndexes.get("qualifid"))) {
            String[] children = new String[3];
            int i = 0;
            for (ParseNode child : node.children()) {
                children[i] = src.get((int)child.from).content;
                ++i;
            }
            output.add(new RuleTuple(SqlRules.ruleName(head, node), children));
        } else {
            if (node.from == 9 && node.to == 17) {
                node.from = 9;
            }
            BnfTypes tmp = SqlRules.type(node);
            tmp.eval(output, node, head, src, isBold);
        }
    }

    static String ruleName(String head, ParseNode n) {
        return head + "[" + n.from + "," + n.to + ")";
    }

    static BnfTypes type(ParseNode n) {
        ParseNode[] children = n.children().toArray(new ParseNode[0]);
        ParseNode child = children[0];
        if (child.contains(SqlRules.cyk.symbolIndexes.get("'['"))) {
            child = children[2];
            if (!child.contains(SqlRules.cyk.symbolIndexes.get("']'"))) {
                return null;
            }
            if (children.length == 6) {
                child = children[3];
                if (!child.contains(SqlRules.cyk.symbolIndexes.get("'.'"))) {
                    return null;
                }
                return BnfTypes.ITER0;
            }
            return BnfTypes.OPT;
        }
        if (child.contains(SqlRules.cyk.symbolIndexes.get("'{'"))) {
            child = children[2];
            if (!child.contains(SqlRules.cyk.symbolIndexes.get("'}'"))) {
                return null;
            }
            if (children.length == 3) {
                return BnfTypes.GRP;
            }
            if (children.length == 6) {
                child = children[3];
                if (!child.contains(SqlRules.cyk.symbolIndexes.get("'.'"))) {
                    return null;
                }
                return BnfTypes.ITER1;
            }
        } else {
            child = children[1];
            if (children.length == 3 && child.contains(SqlRules.cyk.symbolIndexes.get("'|'"))) {
                return BnfTypes.UNION;
            }
            if (children.length == 2) {
                return BnfTypes.JOIN;
            }
        }
        return null;
    }

    static String readURL(String masterBNFurl) throws Exception {
        byte[] bytes = new byte[4096];
        int bytesRead = 0;
        URL url = new URL(masterBNFurl.toLowerCase());
        BufferedInputStream bin = new BufferedInputStream(url.openStream());
        StringBuffer out = new StringBuffer();
        bytesRead = bin.read(bytes, 0, bytes.length);
        StringBuffer sb = new StringBuffer();
        while (bytesRead != -1) {
            sb.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        String ret = sb.toString();
        int ind = ret.indexOf("<p>Note:");
        if (ind > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("Note:")) > 0) {
            ret = ret.substring(0, ind);
        }
        if ((ind = ret.indexOf("</pre>")) < 0) {
            ind = ret.indexOf("</PRE>");
        }
        if (ind < 0) {
            ret = ret + "</pre>";
        }
        return ret;
    }

    public static enum BnfTypes {
        UNION,
        JOIN,
        OPT,
        ITER0,
        ITER1,
        GRP;


        void eval(Set<RuleTuple> output, ParseNode n, String head, List<LexerToken> input, boolean isBold) throws Exception {
            ParseNode[] children = n.children().toArray(new ParseNode[0]);
            switch (this) {
                case UNION: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[0])}));
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[2])}));
                    SqlRules.evaluate(output, children[0], head, input, isBold);
                    SqlRules.evaluate(output, children[2], head, input, isBold);
                    return;
                }
                case JOIN: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[0]), SqlRules.ruleName(head, children[1])}));
                    SqlRules.evaluate(output, children[0], head, input, isBold);
                    SqlRules.evaluate(output, children[1], head, input, isBold);
                    return;
                }
                case OPT: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[1])}));
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[0]));
                    SqlRules.evaluate(output, children[1], head, input, isBold);
                    return;
                }
                case ITER0: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[1])}));
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, n), SqlRules.ruleName(head, n)}));
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[0]));
                    SqlRules.evaluate(output, children[1], head, input, isBold);
                    return;
                }
                case ITER1: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[1])}));
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, n), SqlRules.ruleName(head, n)}));
                    SqlRules.evaluate(output, children[1], head, input, isBold);
                    return;
                }
                case GRP: {
                    output.add(new RuleTuple(SqlRules.ruleName(head, n), new String[]{SqlRules.ruleName(head, children[1])}));
                    SqlRules.evaluate(output, children[1], head, input, isBold);
                    return;
                }
            }
            throw new RuntimeException("Unknown op: " + (Object)((Object)this));
        }
    }
}

