/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.parser.Token;
import oracle.dbtools.parser.Visual;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.parser.plsql.SqlRules;
import oracle.dbtools.util.Service;

public class SqlCYK
extends CYK {
    public static SqlCYK instance = null;
    private static Set<Integer> keywords = new TreeSet<Integer>();

    public static SqlCYK getInstance() {
        if (instance != null) {
            return instance;
        }
        SqlCYK.init();
        return instance;
    }

    public static void main(String[] args) throws Exception {
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        SqlCYK.getInstance().printSelectedChomskiRules("query_name");
        System.out.println(SqlCYK.getInstance().allSymbols[1010]);
        String input = Service.readFile(SqlCYK.class, "test.sql");
        LinkedList<LexerToken> src = LexerToken.parse(input);
        Visual visual = new Visual(src, SqlCYK.getInstance());
        long t1 = System.currentTimeMillis();
        Matrix matrix = SqlCYK.getInstance().initArray(src);
        long t2 = System.currentTimeMillis();
        System.out.println("Init array time = " + (t2 - t1));
        int size = matrix.size();
        TreeMap<Integer, Integer> skipRanges = new TreeMap<Integer, Integer>();
        t1 = System.currentTimeMillis();
        SqlCYK.getInstance().closure(matrix, 0, size + 1, skipRanges, -1);
        t2 = System.currentTimeMillis();
        System.out.println("Parse time = " + (t2 - t1));
        System.out.println(skipRanges);
        instance.print(matrix, 0, size);
        t1 = System.currentTimeMillis();
        ParseNode out = instance.forest(size, matrix);
        t2 = System.currentTimeMillis();
        System.out.println("Reduction time = " + (t2 - t1));
        visual.draw(matrix);
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
    }

    static void init() {
        try {
            Set<RuleTuple> originalRules = SqlRules.getRules();
            instance = new SqlCYK(originalRules);
            keywords.add(SqlCYK.getSymbol("'SELECT'"));
            keywords.add(SqlCYK.getSymbol("'FROM'"));
            keywords.add(SqlCYK.getSymbol("'WHERE'"));
            keywords.add(SqlCYK.getSymbol("'AND'"));
            keywords.add(SqlCYK.getSymbol("'OR'"));
            keywords.add(SqlCYK.getSymbol("'NOT'"));
            keywords.add(SqlCYK.getSymbol("'CREATE'"));
            keywords.add(SqlCYK.getSymbol("'ALTER'"));
            keywords.add(SqlCYK.getSymbol("'TABLE'"));
            keywords.add(SqlCYK.getSymbol("'TABLESPACE'"));
            keywords.add(SqlCYK.getSymbol("'VALUES'"));
            keywords.add(SqlCYK.getSymbol("'NUMBER'"));
            keywords.add(SqlCYK.getSymbol("'VARCHAR2'"));
            keywords.add(SqlCYK.getSymbol("'DATE'"));
            keywords.add(SqlCYK.getSymbol("'INTEGER'"));
        }
        catch (Exception e) {
            instance = null;
            Logger.getLogger(PlsqlCYK.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public SqlCYK(Set<RuleTuple> originalRules) {
        super(originalRules);
        System.out.println(originalRules.size());
    }

    @Override
    public int[] atomicSymbols() {
        return new int[]{(Integer)this.symbolIndexes.get("scalar_subquery_expression"), (Integer)this.symbolIndexes.get("parenthesized_condition")};
    }

    @Override
    public Map<Integer, Integer> delimitedSymbols() {
        HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        ret.put((Integer)this.symbolIndexes.get("select_list"), (Integer)this.symbolIndexes.get("','"));
        ret.put((Integer)this.symbolIndexes.get("compound_condition"), (Integer)this.symbolIndexes.get("AND_OR"));
        ret.put((Integer)this.symbolIndexes.get("subquery"), (Integer)this.symbolIndexes.get("SET_OPER"));
        return ret;
    }

    @Override
    public void initArrayElement(Matrix ret, int pos, LexerToken token, boolean identifiersOnly) {
        int symbol;
        Integer suspect = (Integer)this.symbolIndexes.get("'" + token.content.toUpperCase() + "'");
        TreeSet dependents = new TreeSet();
        if (suspect != null) {
            dependents.addAll(this.singleRhsRules[suspect]);
        }
        if (token.type == Token.IDENTIFIER) {
            if (suspect == null || !keywords.contains(suspect)) {
                symbol = (Integer)this.symbolIndexes.get("identifier");
                dependents.addAll(this.singleRhsRules[symbol]);
            }
        } else if (token.type == Token.DQUOTED_STRING) {
            symbol = (Integer)this.symbolIndexes.get("identifier");
            dependents.addAll(this.singleRhsRules[symbol]);
        } else if (token.type == Token.QUOTED_STRING) {
            symbol = (Integer)this.symbolIndexes.get("string_literal");
            dependents.addAll(this.singleRhsRules[symbol]);
        } else if (token.type == Token.DIGITS) {
            symbol = (Integer)this.symbolIndexes.get("digits");
            dependents.addAll(this.singleRhsRules[symbol]);
        }
        int[] tmp = new int[dependents.size()];
        int i = 0;
        Iterator i$ = dependents.iterator();
        while (i$.hasNext()) {
            int e = (Integer)i$.next();
            tmp[i++] = Service.pair(pos, e);
        }
        ret.put(Service.pair(pos, pos + 1), tmp);
    }

    public void printChomskiRulesHierachy(String name) {
        System.out.println("-------------Chomsky Rules Hierachy------------");
        int prefixEnd = name.indexOf(91);
        LinkedList<CYK.ChomskiTuple> subset = new LinkedList<CYK.ChomskiTuple>();
        for (CYK.ChomskiTuple rule : this.rules) {
            if (!this.allSymbols[rule.head].contains(prefixEnd > 0 ? name.substring(0, prefixEnd) : name) && !this.allSymbols[rule.rhs0].contains(name) && (rule.rhs1 <= 0 || !this.allSymbols[rule.rhs1].contains(name))) continue;
            subset.add(rule);
        }
        this.printRule(name, subset, 0);
        System.out.println("-------------------------------------");
    }

    private void printRule(String name, List<CYK.ChomskiTuple> subset, int offset) {
        for (CYK.ChomskiTuple rule : subset) {
            if (!this.allSymbols[rule.head].equals(name)) continue;
            Service.identln(offset, rule.toString());
            this.printRule(this.allSymbols[rule.rhs0], subset, offset + 1);
            if (rule.rhs1 < 0) continue;
            this.printRule(this.allSymbols[rule.rhs1], subset, offset + 1);
        }
    }

    public static int getSymbol(String string) {
        return (Integer)SqlCYK.instance.symbolIndexes.get(string);
    }
}

