/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.dbtools.parser.RuleTransforms;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Service;

public class PlsqlRules {
    private static final String fname = "serializedPlsqlBNF.xml";
    private static final String path = "/oracle/dbtools/parser/plsql/";

    public static void main(String[] args) throws Exception {
        PlsqlRules.memorizeRules();
    }

    public static void memorizeRules() throws Exception {
        Set<RuleTuple> rules = PlsqlRules.extractRules();
        FileOutputStream fos = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/serializedPlsqlBNF.xml");
        ObjectOutputStream out = new ObjectOutputStream(fos);
        out.writeObject(rules);
        out.close();
        RuleTuple.printRules(rules);
    }

    public static Set<RuleTuple> getRules() throws Exception {
        URL u = PlsqlRules.class.getResource("/oracle/dbtools/parser/plsql/serializedPlsqlBNF.xml");
        InputStream is = u.openStream();
        ObjectInputStream in = new ObjectInputStream(is);
        Set rules = (Set)in.readObject();
        in.close();
        return rules;
    }

    public static Set<RuleTuple> parseBNFtext(String input) throws Exception {
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        input = input.replace("':'", "MYCOL");
        input = input.replace("';'", "MYSEMICOL");
        input = input.replace("'|'", "MYVERTBAR");
        input = input.replace(":", " : ");
        input = input.replace(";", " ; ");
        input = input.replace("|", " | ");
        StringTokenizer st = new StringTokenizer(input, "\n\r ", false);
        String head = null;
        ArrayList<String> rhs = new ArrayList<String>();
        String lastToken = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (":".equals(token)) {
                head = lastToken;
                rhs = new ArrayList();
            } else if (";".equals(token)) {
                rules.add(new RuleTuple(head, rhs));
                head = null;
            } else if ("|".equals(token)) {
                rules.add(new RuleTuple(head, rhs));
                rhs = new ArrayList();
            } else if (head != null) {
                if ("MYCOL".equals(token)) {
                    rhs.add("':'");
                } else if ("MYSEMICOL".equals(token)) {
                    rhs.add("';'");
                } else if ("MYVERTBAR".equals(token)) {
                    rhs.add("'|'");
                } else if (token.charAt(0) != '.' && token.charAt(0) != '_' && token.charAt(token.length() - 1) == '_' && token.toUpperCase().equals(token)) {
                    rhs.add("'" + token.substring(0, token.length() - 1).toUpperCase() + "'");
                } else {
                    rhs.add(token);
                }
            }
            lastToken = token;
        }
        return rules;
    }

    private static Set<RuleTuple> extractRules() throws Exception {
        Set<RuleTuple> ret = PlsqlRules.parseBNFtext(PlsqlRules.readBNFfile());
        PlsqlRules.numberRules(ret);
        RuleTransforms.removeRule("dml_start", ret);
        RuleTransforms.removeRule("ddl_start", ret);
        RuleTransforms.removeRule("merge_", ret);
        RuleTransforms.removeRule("seq_of_stmts", ret);
        ret.add(new RuleTuple("seq_of_stmts", new String[]{"..stmt.."}));
        ret.remove(new RuleTuple("bulk_executable_stmt", new String[]{"static_dml_stmt"}));
        ret.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_dml_stmt", "';'"}));
        ret.remove(new RuleTuple("static_dml_stmt", new String[]{"dml_start", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("static_dml_stmt", new String[]{"'MERGE'", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("static_dml_stmt", new String[]{"merge_", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("unlabeled_nonblock_stmt", new String[]{"static_ddl_stmt", "';'"}));
        ret.remove(new RuleTuple("static_ddl_stmt", new String[]{"ddl_start", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("loop_prm_spec", new String[]{"'SQL_STMT'"}));
        ret.remove(new RuleTuple("curs_body", new String[]{"'SQL_STMT'"}));
        ret.remove(new RuleTuple("cursor_open_statement", new String[]{"'SELECT'", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("cursor_open_statement", new String[]{"'WITH'", "'SQL_STMT'"}));
        ret.remove(new RuleTuple("id_or_reserved", new String[]{"reserved_id"}));
        ret.remove(new RuleTuple("selector", new String[]{"reserved_id"}));
        RuleTransforms.removeRule("reserved_id", ret);
        RuleTransforms.removeRule("identifier", ret);
        ret.remove(new RuleTuple("binary_add_op", new String[]{"'&'"}));
        ret.remove(new RuleTuple("binary_add_op", new String[]{"'CAT'"}));
        ret.remove(new RuleTuple("mult_op", new String[]{"'MOD'"}));
        ret.remove(new RuleTuple("mult_op", new String[]{"'REM'"}));
        ret.remove(new RuleTuple("mult_op", new String[]{"'REMAINDER'"}));
        ret.remove(new RuleTuple(".TYPE.", new String[]{"'TYPE'"}));
        ret.add(new RuleTuple("bind_var", new String[]{"':'", "identifier"}));
        ret.add(new RuleTuple("bind_var", new String[]{"':'", "digits"}));
        ret.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "compilation_unit"}));
        ret.add(new RuleTuple("edit_compilation", new String[]{"'CREATE'", "'OR'", "'REPLACE'", "compilation_unit"}));
        ret.add(new RuleTuple("exec", new String[]{"'EXEC'", "stmt"}));
        ret.add(new RuleTuple("exec", new String[]{"'EXECUTE'", "stmt"}));
        ret.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"'('", "from_table_reference_or_subquery", "')'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'OUTER'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'FULL'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'CROSS'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'NATURAL'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'LEFT'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'RIGHT'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'INNER'"}));
        ret.add(new RuleTuple("join_type", new String[]{"'JOIN'"}));
        ret.add(new RuleTuple("join_type3", new String[]{"join_type"}));
        ret.add(new RuleTuple("join_type3", new String[]{"join_type", "join_type"}));
        ret.add(new RuleTuple("join_type3", new String[]{"join_type", "join_type", "join_type"}));
        ret.add(new RuleTuple("on_condition", new String[]{"'ON'", "expr"}));
        ret.add(new RuleTuple("on_condition", new String[]{"'USING'", "insupd_column_list"}));
        ret.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "join_type3", "from_table_reference_or_subquery", "on_condition"}));
        ret.add(new RuleTuple("from_table_reference_or_subquery", new String[]{"from_table_reference_or_subquery", "join_type3", "from_table_reference_or_subquery"}));
        ret.add(new RuleTuple("factor", new String[]{"table_subquery"}));
        ret.add(new RuleTuple("cmpon_asc", new String[]{"query_expression"}));
        ret.add(new RuleTuple("sel_expr", new String[]{"'CONNECT_BY_ROOT'", "expr"}));
        ret.add(new RuleTuple("comparison_predicate", new String[]{"table_subquery", "relal_op", "sim_expr"}));
        ret.add(new RuleTuple("set_function_specification", new String[]{"'COUNT'", "'('", "ALLorDISTINCT", "'*'", "')'"}));
        ret.add(new RuleTuple("factors", new String[]{"procedure_call", "'AS'", "table_subquery"}));
        ret.add(new RuleTuple("factors", new String[]{"factors", "','", "factors"}));
        ret.add(new RuleTuple("sql_stmt", new String[]{"'WITH'", "factors", "select_statement"}));
        ret.add(new RuleTuple("select_statement", new String[]{"ordered_subquery", "no_joke_order_by_clause"}));
        ret.add(new RuleTuple("select_statement", new String[]{"query_expression"}));
        ret.add(new RuleTuple("no_joke_order_by_clause", new String[]{"'ORDER'", "'SIBLINGS'", "'BY'", "...sort_specification.."}));
        RuleTransforms.removeRule("connect_by_clause", ret);
        ret.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "expr"}));
        ret.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "'NOCYCLE'", "expr"}));
        ret.add(new RuleTuple("connect_by_subclause", new String[]{"'CONNECT'", "'BY'", "expr", "'NOCYCLE'"}));
        ret.add(new RuleTuple("start_with_subclause", new String[]{"'START'", "'WITH'", "expr"}));
        ret.add(new RuleTuple("connect_by_clause", new String[]{"connect_by_subclause", "start_with_subclause"}));
        ret.add(new RuleTuple("connect_by_clause", new String[]{"start_with_subclause", "connect_by_subclause"}));
        ret.add(new RuleTuple("connect_by_clause", new String[]{"connect_by_subclause"}));
        RuleTransforms.removeRule("insert_statement", ret);
        ret.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery", "insupd_column_list"}));
        ret.add(new RuleTuple("insert_into_clause", new String[]{"'INTO'", "table_reference_or_subquery"}));
        ret.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause"}));
        ret.add(new RuleTuple("insert_into_values_clause", new String[]{"insert_into_clause", "insert_stmt_values_seq"}));
        ret.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause"}));
        ret.add(new RuleTuple("insert_into_values*", new String[]{"insert_into_values_clause", "insert_into_values*"}));
        ret.add(new RuleTuple(".all_first.", new String[]{"'ALL'"}));
        ret.add(new RuleTuple(".all_first.", new String[]{"'FIRST'"}));
        ret.add(new RuleTuple(".all_first.", new String[0]));
        ret.add(new RuleTuple("when_condition_clause", new String[]{"'WHEN'", "cond", "'THEN'", "insert_into_values*"}));
        ret.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause"}));
        ret.add(new RuleTuple("when_condition*", new String[]{"when_condition_clause", "when_condition*"}));
        ret.add(new RuleTuple(".else_insert_clause.", new String[0]));
        ret.add(new RuleTuple(".else_insert_clause.", new String[]{"'ELSE'", "insert_into_values*"}));
        ret.add(new RuleTuple("conditional_insert_clause", new String[]{".all_first.", "when_condition*", ".else_insert_clause."}));
        ret.add(new RuleTuple("multi_table_insert", new String[]{"conditional_insert_clause", "query_expression"}));
        ret.add(new RuleTuple("multi_table_insert", new String[]{"'ALL'", "insert_into_values*", ".else_insert_clause.", "query_expression"}));
        ret.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "insert_stmt_values_seq", ".returning_into_clause."}));
        ret.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "insert_into_clause", "query_expression"}));
        ret.add(new RuleTuple("insert_statement", new String[]{"'INSERT'", "multi_table_insert"}));
        ret.add(new RuleTuple("over_clause", new String[]{"'OVER'", "'('", "analytic_clause", "')'"}));
        ret.add(new RuleTuple("pri", new String[]{"procedure_call", "over_clause"}));
        ret.add(new RuleTuple("pri", new String[]{"procedure_call", "'KEEP'", "'('", "keep_clause", "')'", "over_clause"}));
        ret.add(new RuleTuple("pri", new String[]{"set_function_specification", "over_clause"}));
        ret.add(new RuleTuple("analytic_clause", new String[]{"analytic_clause[0,3)", "analytic_clause[3,9)"}));
        ret.add(new RuleTuple("analytic_clause[0,3)", new String[0]));
        ret.add(new RuleTuple("analytic_clause[0,3)", new String[]{"query_partition_clause"}));
        ret.add(new RuleTuple("analytic_clause[3,9)", new String[0]));
        ret.add(new RuleTuple("analytic_clause[3,9)", new String[]{"analytic_clause[4,8)"}));
        ret.add(new RuleTuple("analytic_clause[4,8)", new String[]{".order_by_clause.", "analytic_clause[5,8)"}));
        ret.add(new RuleTuple("analytic_clause[5,8)", new String[0]));
        ret.add(new RuleTuple("analytic_clause[5,8)", new String[]{"windowing_clause"}));
        ret.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "sim_expr", "...sim_expr.."}));
        ret.add(new RuleTuple("query_partition_clause", new String[]{"'PARTITION'", "'BY'", "'('", "sim_expr", "...sim_expr..", "')'"}));
        ret.add(new RuleTuple("windowing_clause", new String[]{"windowing_clause[1,4)", "windowing_clause[6,47)"}));
        ret.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'RANGE'"}));
        ret.add(new RuleTuple("windowing_clause[1,4)", new String[]{"'ROWS'"}));
        ret.add(new RuleTuple("windowing_clause[11,13)", new String[]{"'CURRENT'", "'ROW'"}));
        ret.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[11,13)"}));
        ret.add(new RuleTuple("windowing_clause[11,20)", new String[]{"windowing_clause[14,20)"}));
        ret.add(new RuleTuple("windowing_clause[14,20)", new String[]{"expr", "windowing_clause[16,19)"}));
        ret.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'FOLLOWING'"}));
        ret.add(new RuleTuple("windowing_clause[16,19)", new String[]{"'PRECEDING'"}));
        ret.add(new RuleTuple("windowing_clause[21,36)", new String[]{"'AND'", "windowing_clause[23,35)"}));
        ret.add(new RuleTuple("windowing_clause[23,35)", new String[]{"'UNBOUNDED'", "'FOLLOWING'"}));
        ret.add(new RuleTuple("windowing_clause[23,35)", new String[]{"windowing_clause[26,35)"}));
        ret.add(new RuleTuple("windowing_clause[26,28)", new String[]{"'CURRENT'", "'ROW'"}));
        ret.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[26,28)"}));
        ret.add(new RuleTuple("windowing_clause[26,35)", new String[]{"windowing_clause[29,35)"}));
        ret.add(new RuleTuple("windowing_clause[29,35)", new String[]{"expr", "windowing_clause[31,34)"}));
        ret.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'FOLLOWING'"}));
        ret.add(new RuleTuple("windowing_clause[31,34)", new String[]{"'PRECEDING'"}));
        ret.add(new RuleTuple("windowing_clause[38,46)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        ret.add(new RuleTuple("windowing_clause[38,46)", new String[]{"windowing_clause[41,46)"}));
        ret.add(new RuleTuple("windowing_clause[41,46)", new String[]{"'CURRENT'", "'ROW'"}));
        ret.add(new RuleTuple("windowing_clause[41,46)", new String[]{"windowing_clause[44,46)"}));
        ret.add(new RuleTuple("windowing_clause[44,46)", new String[]{"expr", "'PRECEDING'"}));
        ret.add(new RuleTuple("windowing_clause[6,36)", new String[]{"'BETWEEN'", "windowing_clause[7,36)"}));
        ret.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[38,46)"}));
        ret.add(new RuleTuple("windowing_clause[6,47)", new String[]{"windowing_clause[6,36)"}));
        ret.add(new RuleTuple("windowing_clause[7,36)", new String[]{"windowing_clause[8,20)", "windowing_clause[21,36)"}));
        ret.add(new RuleTuple("windowing_clause[8,20)", new String[]{"windowing_clause[11,20)"}));
        ret.add(new RuleTuple("windowing_clause[8,20)", new String[]{"'UNBOUNDED'", "'PRECEDING'"}));
        ret.add(new RuleTuple("keep_clause", new String[]{"keep_col"}));
        ret.add(new RuleTuple("keep_clause", new String[]{"keep_clause", "keep_col"}));
        ret.add(new RuleTuple("keep_col", new String[]{"'DENSE_RANK'", "first_last", "analytic_clause"}));
        ret.add(new RuleTuple("first_last", new String[]{"'FIRST'"}));
        ret.add(new RuleTuple("first_last", new String[]{"'LAST'"}));
        ret.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[72,108)"}));
        ret.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[4,71)"}));
        ret.add(new RuleTuple("flashback_query_clause", new String[]{"flashback_query_clause[4,71)", "flashback_query_clause[72,108)"}));
        ret.add(new RuleTuple("flashback_query_clause[12,71)", new String[]{"'BETWEEN'", "flashback_query_clause[20,71)"}));
        ret.add(new RuleTuple("flashback_query_clause[20,71)", new String[]{"scn_or_timestamp", "expr_or_minval_and_expr_or_maxval"}));
        ret.add(new RuleTuple("scn_or_timestamp", new String[]{"'SCN'"}));
        ret.add(new RuleTuple("scn_or_timestamp", new String[]{"'TIMESTAMP'"}));
        ret.add(new RuleTuple("expr_or_minval_and_expr_or_maxval", new String[]{"expr_or_minval", "and_expr_or_maxval"}));
        ret.add(new RuleTuple("flashback_query_clause[4,71)", new String[]{"'VERSIONS'", "flashback_query_clause[12,71)"}));
        ret.add(new RuleTuple("expr_or_minval", new String[]{"sim_expr"}));
        ret.add(new RuleTuple("expr_or_minval", new String[]{"'MINVALUE'"}));
        ret.add(new RuleTuple("and_expr_or_maxval", new String[]{"'AND'", "sim_expr"}));
        ret.add(new RuleTuple("and_expr_or_maxval", new String[]{"'AND'", "'MAXVALUE'"}));
        ret.add(new RuleTuple("flashback_query_clause[72,108)", new String[]{"'AS'", "flashback_query_clause[80,108)"}));
        ret.add(new RuleTuple("flashback_query_clause[80,108)", new String[]{"'OF'", "flashback_query_clause[88,108)"}));
        ret.add(new RuleTuple("flashback_query_clause[88,108)", new String[]{"scn_or_timestamp", "sim_expr"}));
        ret.add(new RuleTuple("table_reference_or_subquery", new String[]{"link_expanded_n_optional_partition", "flashback_query_clause", "identifier"}));
        ret.add(new RuleTuple("table_reference_or_subquery", new String[]{"link_expanded_n_optional_partition", "flashback_query_clause"}));
        RuleTransforms.removeRule("sort_specification", ret);
        ret.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'FIRST'"}));
        ret.add(new RuleTuple(".nulls_first_last.", new String[]{"'NULLS'", "'LAST'"}));
        ret.add(new RuleTuple(".nulls_first_last.", new String[0]));
        ret.add(new RuleTuple(".asc_desc.", new String[]{"'ASC'"}));
        ret.add(new RuleTuple(".asc_desc.", new String[]{"'DESC'"}));
        ret.add(new RuleTuple(".asc_desc.", new String[0]));
        ret.add(new RuleTuple("sort_specification", new String[]{"sim_expr", ".asc_desc.", ".nulls_first_last."}));
        ret.add(new RuleTuple("pivot_in_clause", new String[]{"in_predicate"}));
        ret.add(new RuleTuple("pivot_in_clause", new String[]{"sim_expr", "'IN'", "'('", "select_list", "')'"}));
        ret.add(new RuleTuple("unpivot_list", new String[]{"valued_col"}));
        ret.add(new RuleTuple("unpivot_list", new String[]{"unpivot_list", "','", "valued_col"}));
        ret.add(new RuleTuple("valued_col", new String[]{"identifier"}));
        ret.add(new RuleTuple("valued_col", new String[]{"identifier", "'AS'", "sim_expr"}));
        ret.add(new RuleTuple("unpivot_in_clause", new String[]{"sim_expr", "'IN'", "'('", "unpivot_list", "')'"}));
        ret.add(new RuleTuple("pivot_clause", new String[]{"'PIVOT'", "'('", "idxed_cmpon", "'FOR'", "pivot_in_clause", "')'"}));
        ret.add(new RuleTuple("unpivot_clause", new String[]{"'UNPIVOT'", "'('", "sim_expr", "'FOR'", "unpivot_in_clause", "')'"}));
        ret.add(new RuleTuple("table_expression_clause", new String[]{"pivot_clause"}));
        ret.add(new RuleTuple("table_expression_clause", new String[]{"unpivot_clause"}));
        RuleTransforms.printSelectedRules("merge", ret);
        ret = RuleTransforms.eliminateEmptyProductions(ret);
        RuleTransforms.substituteAll(ret);
        return ret;
    }

    public static void numberRules(Set<RuleTuple> ret) {
        ret.add(new RuleTuple(".fd.", new String[0]));
        ret.add(new RuleTuple(".fd.", new String[]{"'f'"}));
        ret.add(new RuleTuple(".fd.", new String[]{"'d'"}));
        ret.add(new RuleTuple(".+-.", new String[0]));
        ret.add(new RuleTuple(".+-.", new String[]{"'+'"}));
        ret.add(new RuleTuple(".+-.", new String[]{"'-'"}));
        ret.add(new RuleTuple(".exp.", new String[0]));
        ret.add(new RuleTuple(".exp.", new String[]{"'E'", ".+-.", "digits"}));
        ret.add(new RuleTuple("numeric_literal", new String[]{"digits", ".exp.", ".fd."}));
        ret.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", ".exp.", ".fd."}));
        ret.add(new RuleTuple("numeric_literal", new String[]{"'.'", "digits", ".exp.", ".fd."}));
        ret.add(new RuleTuple("numeric_literal", new String[]{"digits", "'.'", "digits", ".exp.", ".fd."}));
    }

    public static Set<String> getKeywords(Set<RuleTuple> rules) {
        TreeSet<String> ret = new TreeSet<String>();
        for (RuleTuple rule : rules) {
            for (String token : rule.rhs) {
                if (!token.startsWith("'")) continue;
                ret.add(token);
            }
        }
        return ret;
    }

    private static String readBNFfile() throws Exception {
        String rulesTxt = Service.readFile(PlsqlRules.class, "plsql.y");
        String startPattern = "/*---------------------------- Start of Rules -------------------------------*/";
        rulesTxt = rulesTxt.substring(rulesTxt.indexOf("/*---------------------------- Start of Rules -------------------------------*/") + "/*---------------------------- Start of Rules -------------------------------*/".length());
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "/*", "*/");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = PlsqlRules.removeNestedBlock(rulesTxt, "{", "}");
        rulesTxt = rulesTxt.replace("ASSIGN_", "':' '='");
        rulesTxt = rulesTxt.replace("LTEQ_", "'<' '='");
        rulesTxt = rulesTxt.replace("GTEQL_", "'>' '='");
        rulesTxt = rulesTxt.replace("NOTEQL_", "'!' '='");
        rulesTxt = rulesTxt.replace("BOX_", "'<' '>'");
        rulesTxt = rulesTxt.replace("CAT_", "'|' '|'");
        rulesTxt = rulesTxt.replace(" DBLDOT_ ", " '.' '.' ");
        rulesTxt = rulesTxt.replace("ARROW_", "'=' '>'");
        rulesTxt = rulesTxt.replace("EXP_ pri", "'*' '*' pri");
        rulesTxt = rulesTxt.replace("L_LBL_", "'<' '<'");
        rulesTxt = rulesTxt.replace("R_LBL_", "'>' '>'");
        rulesTxt = rulesTxt.replace(" INDICATOR_ ", " ':' ");
        rulesTxt = rulesTxt.replace("ph1psh_", " ");
        rulesTxt = rulesTxt.replace("')'", " ')' ");
        rulesTxt = rulesTxt.replace("'('", " '(' ");
        return rulesTxt;
    }

    static String removeNestedBlock(String src, String br1, String br2) {
        int len1 = br1.length();
        int len2 = br2.length();
        int beg = 0;
        int end = 0;
        StringBuffer out = new StringBuffer();
        while (beg < src.length()) {
            beg = src.indexOf(br1, end);
            int beg1 = src.indexOf(br1, beg + len1);
            int end1 = src.indexOf(br2, beg + len1) + len2;
            if (beg > 0 && beg < beg1 && beg1 < end1) {
                out.append(src.substring(end, beg + len1));
                end = beg + len1;
                continue;
            }
            if (beg < 0) {
                beg = src.length();
            }
            out.append(src.substring(end, beg));
            end = src.indexOf(br2, beg + len1) + len2;
            if (end >= len2) continue;
            out.append(src.substring(beg));
            break;
        }
        return out.toString();
    }
}

