/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.javatools.util.Pair;

public class LazyNode
extends ParseNode {
    public String startToken;
    LinkedList<LexerToken> src;
    private ParseNode branch = null;
    private Map<ParseNode, Pair<Integer, Integer>> identifiers = null;

    public LazyNode(int begin, String start, LinkedList<LexerToken> src) {
        super(begin, -1, -1, -1, PlsqlCYK.getInstance());
        this.startToken = start;
        this.src = src;
    }

    public ParseNode getBranch() {
        return this.branch;
    }

    @Override
    public Set<ParseNode> children() {
        if (this.branch == null) {
            return super.children();
        }
        TreeSet<ParseNode> ret = new TreeSet<ParseNode>();
        ret.addAll(super.children());
        ret.add(this.branch);
        return ret;
    }

    public List<LazyNode> shallowChildren() {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        for (ParseNode child : super.children()) {
            if (!(child instanceof LazyNode)) continue;
            ret.add((LazyNode)child);
        }
        return ret;
    }

    public List<LazyNode> shallowDescendants() {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        ret.add(this);
        for (LazyNode n : this.shallowChildren()) {
            ret.addAll(n.shallowDescendants());
        }
        return ret;
    }

    public List<LazyNode> shallowIntermediates(int head, int tail) {
        ArrayList<LazyNode> ret = new ArrayList<LazyNode>();
        if (this.from <= head && tail <= this.to) {
            ret.add(this);
        }
        for (LazyNode n : this.shallowChildren()) {
            if (n.from > head || tail > n.to) continue;
            ret.addAll(n.shallowIntermediates(head, tail));
        }
        return ret;
    }

    public LazyNode shallowParent(int head, int tail) {
        for (LazyNode descendant : this.shallowIntermediates(head, tail)) {
            for (LazyNode child : descendant.shallowChildren()) {
                if (child.from != head || child.to != tail) continue;
                return descendant;
            }
        }
        return null;
    }

    public LazyNode shallowLeaf(int head, int tail) {
        for (LazyNode descendant : this.shallowIntermediates(head, tail)) {
            if (descendant.shallowChildren().size() != 0 || descendant.from > head || tail > descendant.to) continue;
            return descendant;
        }
        return null;
    }

    public LazyNode ancestor(int head, int tail) {
        List<LazyNode> candidates = this.shallowChildren();
        if (candidates.size() == 0) {
            return this;
        }
        for (LazyNode child : candidates) {
            if (child.from > head || tail > child.to) continue;
            return child.ancestor(head, tail);
        }
        return this;
    }

    @Override
    public boolean isAuxiliary() {
        return false;
    }

    @Override
    protected String toString(int depth) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            sb.append("  ");
        }
        sb.append("[" + this.from + "," + this.to + ") ");
        sb.append("  " + this.startToken);
        return sb.toString();
    }

    public boolean isAs() {
        return "is".equalsIgnoreCase(this.startToken) || "as".equalsIgnoreCase(this.startToken) || "before".equalsIgnoreCase(this.startToken) || "after".equalsIgnoreCase(this.startToken);
    }

    public boolean isCompilationUnit() {
        return "package".equalsIgnoreCase(this.startToken) || "trigger".equalsIgnoreCase(this.startToken) || this.isProcedure();
    }

    public boolean isProcedure() {
        return "function".equalsIgnoreCase(this.startToken) || "procedure".equalsIgnoreCase(this.startToken);
    }

    public boolean isDML() {
        return "insert".equalsIgnoreCase(this.startToken) || "update".equalsIgnoreCase(this.startToken) || "delete".equalsIgnoreCase(this.startToken) || "select".equalsIgnoreCase(this.startToken) || "with".equalsIgnoreCase(this.startToken) || "cursor".equalsIgnoreCase(this.startToken) || "merge".equalsIgnoreCase(this.startToken) || "fetch".equalsIgnoreCase(this.startToken);
    }

    public boolean isDDL() {
        return "alter".equalsIgnoreCase(this.startToken) || "create".equalsIgnoreCase(this.startToken) || "grant".equalsIgnoreCase(this.startToken) || "drop".equalsIgnoreCase(this.startToken) || "comment".equalsIgnoreCase(this.startToken);
    }

    boolean isControlStmt(LazyNode root) {
        return "if".equalsIgnoreCase(this.startToken) || "case".equalsIgnoreCase(this.startToken) || "for".equalsIgnoreCase(this.startToken) || "while".equalsIgnoreCase(this.startToken) || "loop".equalsIgnoreCase(this.startToken) && !"for".equalsIgnoreCase(((LazyNode)root.parent((int)this.from, (int)this.to)).startToken) && !"while".equalsIgnoreCase(((LazyNode)root.parent((int)this.from, (int)this.to)).startToken);
    }

    public boolean isStmt(LazyNode root) {
        if ("declare".equalsIgnoreCase(this.startToken)) {
            return true;
        }
        if ("begin".equalsIgnoreCase(this.startToken)) {
            ParseNode prt = root.parent(this.from, this.to);
            LazyNode parent = (LazyNode)prt;
            if (!"declare".equalsIgnoreCase(parent.startToken) && !parent.isProcedure()) {
                return true;
            }
        }
        return this.isControlStmt(root) || this.isDML() || this.isDDL();
    }

    public Map<ParseNode, Pair<Integer, Integer>> collectIdentifiers(Pair<Integer, Integer> interval) {
        if (this.identifiers == null) {
            this.identifiers = new TreeMap<ParseNode, Pair<Integer, Integer>>();
        }
        for (LazyNode node : this.shallowDescendants()) {
            ParseNode id;
            if (node.isAs() || "declare".equalsIgnoreCase(node.startToken) || "(".equals(node.startToken) || node.isDML()) {
                LazyNode parent = null;
                if (node.isAs() || "(".equals(node.startToken)) {
                    parent = this.shallowParent(node.from, node.to);
                }
                if (parent != null && "package".equalsIgnoreCase(parent.startToken) || parent != null && (parent.to <= (Integer)interval.first || (Integer)interval.second <= parent.from) || parent == null && (node.to <= (Integer)interval.first || (Integer)interval.second <= node.from)) continue;
                node.expand(node.children().size() == 0);
                for (ParseNode id2 : node.branch.descendants()) {
                    if (id2.contains(PlsqlCYK.getInstance().idents)) {
                        this.identifiers.put(id2, (Pair<Integer, Integer>)new Pair((Object)id2.from, (Object)(parent != null ? parent.to - 2 : node.to)));
                        continue;
                    }
                    if (!id2.contains(PlsqlCYK.getInstance().table_reference_or_subquery) && !id2.contains(PlsqlCYK.getInstance().from_table_reference_or_subquery)) continue;
                    this.identifiers.put(id2, (Pair<Integer, Integer>)new Pair((Object)(parent != null ? parent.from + 1 : node.from + 1), (Object)(parent != null ? parent.to : node.to)));
                }
                continue;
            }
            if (!"for".equalsIgnoreCase(node.startToken) || node.to <= (Integer)interval.first || (Integer)interval.second <= node.from) continue;
            node.branch = id = new ParseNode(node.from + 1, node.from + 2, PlsqlCYK.getInstance().identifier, PlsqlCYK.getInstance().identifier, PlsqlCYK.getInstance());
            this.identifiers.put(id, (Pair<Integer, Integer>)new Pair((Object)(node.from + 1), (Object)node.to));
        }
        return this.identifiers;
    }

    public void expand(boolean isLeaf) {
        LinkedList<LexerToken> fragment = new LinkedList<LexerToken>();
        int k = -1;
        for (LexerToken tok : this.src) {
            if (this.from > ++k || k >= this.to) continue;
            if (!isLeaf && this.from != k && "begin".equalsIgnoreCase(tok.content)) break;
            fragment.add(tok);
        }
        if (1000 < fragment.size()) {
            throw new RuntimeException("fragment too large");
        }
        Matrix matrix = PlsqlCYK.getInstance().initArray1(fragment);
        int size = matrix.size();
        TreeMap<Integer, Integer> skipRanges = new TreeMap<Integer, Integer>();
        PlsqlCYK.getInstance().closure(matrix, 0, size + 1, skipRanges, -1);
        this.branch = PlsqlCYK.getInstance().forest(size, matrix);
        this.branch.moveInterval(this.from);
    }

    public LinkedList<LexerToken> getSrcFragment() {
        LinkedList<LexerToken> fragment = new LinkedList<LexerToken>();
        int k = -1;
        for (LexerToken tok : this.src) {
            if (this.to <= ++k) break;
            if (this.from > k) continue;
            fragment.add(tok);
        }
        return fragment;
    }
}

