/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser.plsql;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.Matrix;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.plsql.ArrayInt;
import oracle.dbtools.parser.plsql.PlsqlCYK;
import oracle.dbtools.util.Service;

public class CodeCompleter {
    public List<LexerToken> fragment;
    public Matrix matrix;
    public ParseNode root;
    public TreeMap<Integer, Integer> skipRanges = new TreeMap();
    private static PlsqlCYK cyk = null;
    private Set<Integer>[] startingSymbolsMap = null;
    private Set<Integer>[] endingSymbolsMap = null;
    private Set<Integer> allSymbols = null;
    private Set<Integer> allKeywords = null;
    private Set<Integer> allKeywordsPlusId = null;
    private Set<Integer>[] rulesStartedWithMap = null;
    private Set<Integer>[] rulesEndingWithMap = null;
    private List<Integer> escape = new LinkedList<Integer>();
    private Set<Integer>[] singleRhsProductions;
    private Set<Integer> obscureProductions = new HashSet<Integer>();
    static int cnt = 0;
    public static int seq_of_stmts = -1;
    public static int boolean_primary = -1;
    public static int query_expression = -1;
    private Map<Integer, Set<ArrayInt>> templates = new HashMap<Integer, Set<ArrayInt>>();
    private static final String fname = "serializedTemplates.xml";
    private static final String path = "/oracle/dbtools/parser/plsql/";

    public CodeCompleter() {
        if (cyk == null) {
            cyk = PlsqlCYK.getInstance();
        }
    }

    public void shiftUpperTriangle(int pos, int delta) {
        ArrayList<LexerToken> fragment1 = new ArrayList<LexerToken>();
        fragment1.addAll(this.fragment);
        for (int i = 0; i < delta; ++i) {
            fragment1.remove(pos);
        }
        this.fragment = fragment1;
        Matrix matrix1 = new Matrix(cyk);
        for (Integer key : this.matrix.keySet()) {
            int x = Service.X(key);
            int y = Service.Y(key);
            if (y <= pos) {
                matrix1.put(key, this.matrix.get(key));
            }
            if (pos + delta > x) continue;
            int newKey = Service.pair(x - delta, y - delta);
            int[] payload = (int[])this.matrix.get(key);
            for (int i = 0; i < payload.length; ++i) {
                int tmp = payload[i];
                payload[i] = Service.pair(Service.X(tmp) - delta, Service.Y(tmp));
            }
            matrix1.put(newKey, payload);
        }
        this.matrix = matrix1;
    }

    public void shiftUpperTriangle(int pos) {
        this.shiftUpperTriangle(pos, -1);
    }

    public void evaluate(int pos) {
        long t1 = System.currentTimeMillis();
        cyk.closure(this.matrix, 0, this.fragment.size() + 1, this.skipRanges, pos);
        this.root = cyk.forest(this.fragment.size(), this.matrix);
        long t2 = System.currentTimeMillis();
        System.out.println(this.fragment.get((int)1).content + "..." + this.fragment.get((int)(this.fragment.size() - 2)).content + ", parse time = " + (t2 - t1));
    }

    public void reduce(int pos, int delta) {
        this.shiftUpperTriangle(pos, delta);
        cyk.recalculateRectangle(this.matrix, this.skipRanges, this.fragment.size() + 1, pos, pos + 1);
        this.root = cyk.forest(this.fragment.size(), this.matrix);
    }

    public static int maxCover(ParseNode root, int pos) {
        if (root.isAuxiliary()) {
            int ret = Service.pair(pos, pos);
            for (ParseNode p : root.children()) {
                if (p.from > pos || pos >= p.to) continue;
                ret = Service.pair(p.from, p.to);
                break;
            }
            return ret;
        }
        return Service.pair(root.from, root.to);
    }

    public static int weightedLength(int x, int pos, int y) {
        return y - pos + (pos - x) * (pos - x);
    }

    public int weightedLength(int pos) {
        int seg = CodeCompleter.maxCover(this.root, pos);
        return CodeCompleter.weightedLength(Service.X(seg), pos, Service.Y(seg));
    }

    public boolean containsAuxiliary(Set<Integer> content) {
        boolean hasAux = false;
        for (Integer symbol : content) {
            if (!this.isAuxiliary(symbol)) continue;
            hasAux = true;
            break;
        }
        return hasAux;
    }

    public Set<Integer> validatedSymbolsAtPos(int pos, Matrix P) {
        Set<SymbolAtCell> cover = this.cover(pos, P);
        TreeSet<SymbolAtCell> newCover = new TreeSet<SymbolAtCell>();
        TreeSet<Integer> ret = new TreeSet<Integer>();
        while (true) {
            for (SymbolAtCell rc : cover) {
                int y;
                int x = Service.X(rc.interval);
                if (x + 1 == (y = Service.Y(rc.interval))) {
                    for (int i = 0; i < CodeCompleter.cyk.singleRhsRules.length; ++i) {
                        if (!CodeCompleter.cyk.singleRhsRules[i].contains(rc.symbol)) continue;
                        ret.add(i);
                    }
                    continue;
                }
                for (int srs : (int[])P.get(rc.interval)) {
                    int symbol = Service.Y(srs);
                    if (symbol != rc.symbol) continue;
                    int mid = Service.X(srs);
                    for (int pre : (int[])P.get(Service.pair(x, mid))) {
                        for (int post : (int[])P.get(Service.pair(mid, y))) {
                            int s2;
                            int s1 = Service.Y(pre);
                            Set A = (Set)CodeCompleter.cyk.doubleRhsRules.get(Service.pair(s1, s2 = Service.Y(post)));
                            if (A == null || !A.contains(symbol)) continue;
                            if (mid <= pos) {
                                newCover.add(new SymbolAtCell(Service.pair(mid, y), s2));
                                continue;
                            }
                            newCover.add(new SymbolAtCell(Service.pair(x, mid), s1));
                        }
                    }
                }
            }
            if (newCover.size() == 0) {
                return ret;
            }
            cover = newCover;
            newCover = new TreeSet();
        }
    }

    public static Set<Integer> validatedSymbolsAtPos(int pos, ParseNode root) {
        for (ParseNode child : root.children()) {
            if (child.from == pos) {
                return child.content();
            }
            if (child.from > pos || pos >= child.to) continue;
            return CodeCompleter.validatedSymbolsAtPos(pos, child);
        }
        throw new RuntimeException("VT: Impossible Case");
    }

    private Set<SymbolAtCell> cover(int pos, Matrix P) {
        TreeSet<Integer> cover = new TreeSet<Integer>();
        Iterator i$ = P.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            if (pos < Service.X(key) || Service.Y(key) <= pos) continue;
            ArrayList<Integer> nodes = new ArrayList<Integer>();
            boolean alreadyCovered = false;
            Iterator i$2 = cover.iterator();
            while (i$2.hasNext()) {
                int n = (Integer)i$2.next();
                if (Service.X(key) <= Service.X(n) && Service.Y(key) > Service.Y(n) || Service.X(key) < Service.X(n) && Service.Y(key) >= Service.Y(n)) {
                    nodes.add(n);
                }
                if ((Service.X(key) < Service.X(n) || Service.Y(key) >= Service.Y(n)) && (Service.X(key) <= Service.X(n) || Service.Y(key) > Service.Y(n))) continue;
                alreadyCovered = true;
                break;
            }
            cover.removeAll(nodes);
            if (alreadyCovered) continue;
            cover.add(key);
        }
        TreeSet<SymbolAtCell> ret = new TreeSet<SymbolAtCell>();
        int maxLen = 0;
        for (Integer n : cover) {
            if (Service.Y(n) - Service.X(n) <= maxLen) continue;
            maxLen = Service.Y(n) - Service.X(n);
        }
        for (Integer n : cover) {
            int[] topSymbols;
            if (Service.Y(n) - Service.X(n) < maxLen) continue;
            boolean filter = false;
            for (int ss : topSymbols = (int[])P.get(n)) {
                if (this.isAuxiliary(Service.Y(ss))) continue;
                filter = true;
            }
            for (int ss : topSymbols) {
                if (filter && this.isAuxiliary(Service.Y(ss))) continue;
                ret.add(new SymbolAtCell(n, Service.Y(ss)));
            }
        }
        return ret;
    }

    private boolean isAuxiliary(int symbol) {
        return CodeCompleter.cyk.allSymbols[symbol].indexOf(43) >= 0;
    }

    public Set<Integer> startingSymbols(int s) {
        if (this.startingSymbolsMap == null) {
            this.startingSymbolsMap = this.startingSymbols();
        }
        return this.startingSymbolsMap[s];
    }

    public Set<String> startingKeywords(int s) {
        Set<Integer> symbols = this.startingSymbols(s);
        TreeSet<String> ret = new TreeSet<String>();
        for (int candidate : symbols) {
            String symbol = CodeCompleter.cyk.allSymbols[candidate];
            if (symbol.charAt(0) != '\'' || symbol.lastIndexOf(43) > 1) continue;
            ret.add(symbol.substring(1, symbol.length() - 1));
        }
        return ret;
    }

    private Set<Integer>[] startingSymbols() {
        TreeMap tmp = new TreeMap();
        for (int i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            TreeSet<Integer> symbols = new TreeSet<Integer>();
            symbols.add(i);
            tmp.put(i, symbols);
        }
        for (CYK.ChomskiTuple rule : CodeCompleter.cyk.rules) {
            TreeSet<Integer> symbols = (TreeSet<Integer>)tmp.get(rule.head);
            if (symbols == null) {
                symbols = new TreeSet<Integer>();
            }
            symbols.add(rule.rhs0);
            tmp.put(rule.head, symbols);
        }
        boolean grown = true;
        while (grown) {
            grown = false;
            for (CYK.ChomskiTuple rule : CodeCompleter.cyk.rules) {
                Set heads;
                TreeSet set = new TreeSet();
                Set rhs0s = (Set)tmp.get(rule.rhs0);
                if (rhs0s != null) {
                    set.addAll(rhs0s);
                }
                if ((heads = (Set)tmp.get(rule.head)) != null) {
                    set.addAll(heads);
                }
                if (rhs0s != null && heads != null && set.size() > heads.size()) {
                    grown = true;
                }
                tmp.put(rule.head, set);
            }
        }
        Set[] ret = new Set[CodeCompleter.cyk.allSymbols.length];
        Iterator i$ = tmp.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            ret[i] = (Set)tmp.get(i);
        }
        return ret;
    }

    public Set<Integer> endingSymbols(int s) {
        if (this.endingSymbolsMap == null) {
            this.endingSymbolsMap = this.endingSymbols();
        }
        return this.endingSymbolsMap[s];
    }

    private Set<Integer>[] endingSymbols() {
        TreeMap tmp = new TreeMap();
        for (int i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            TreeSet<Integer> symbols = new TreeSet<Integer>();
            symbols.add(i);
            tmp.put(i, symbols);
        }
        for (CYK.ChomskiTuple rule : CodeCompleter.cyk.rules) {
            if (rule.rhs1 < 0) continue;
            TreeSet<Integer> symbols = (TreeSet<Integer>)tmp.get(rule.head);
            if (symbols == null) {
                symbols = new TreeSet<Integer>();
            }
            symbols.add(rule.rhs1);
            tmp.put(rule.head, symbols);
        }
        boolean grown = true;
        while (grown) {
            grown = false;
            for (CYK.ChomskiTuple rule : CodeCompleter.cyk.rules) {
                Set heads;
                TreeSet set = new TreeSet();
                Set rhs1s = (Set)tmp.get(rule.rhs1);
                if (rhs1s != null) {
                    set.addAll(rhs1s);
                }
                if ((heads = (Set)tmp.get(rule.head)) != null) {
                    set.addAll(heads);
                }
                if (rhs1s != null && heads != null && set.size() > heads.size()) {
                    grown = true;
                }
                tmp.put(rule.head, set);
            }
        }
        Set[] ret = new Set[CodeCompleter.cyk.allSymbols.length];
        Iterator i$ = tmp.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            ret[i] = (Set)tmp.get(i);
        }
        return ret;
    }

    public Set<Integer> allSymbols() {
        if (this.allSymbols != null) {
            return this.allSymbols;
        }
        this.allSymbols = new TreeSet<Integer>();
        for (int i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            this.allSymbols.add(i);
        }
        return this.allSymbols;
    }

    public Set<Integer> allKeywords() {
        if (this.allKeywords != null) {
            return this.allKeywords;
        }
        this.allKeywords = new TreeSet<Integer>();
        for (int i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            String symbol = CodeCompleter.cyk.allSymbols[i];
            if (symbol.charAt(0) != '\'' || symbol.lastIndexOf(43) > 1) continue;
            this.allKeywords.addAll(CodeCompleter.cyk.singleRhsRules[i]);
        }
        return this.allKeywords;
    }

    public Set<Integer> allKeywordsPlusId() {
        if (this.allKeywordsPlusId != null) {
            return this.allKeywordsPlusId;
        }
        this.allKeywordsPlusId = new TreeSet<Integer>();
        for (int i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            String symbol = CodeCompleter.cyk.allSymbols[i];
            if ((symbol.charAt(0) != '\'' || symbol.lastIndexOf(43) > 1 || symbol.length() <= 3) && i != CodeCompleter.cyk.identifier) continue;
            this.allKeywordsPlusId.addAll(CodeCompleter.cyk.singleRhsRules[i]);
        }
        return this.allKeywordsPlusId;
    }

    public Set<Integer> allKeywordsPlusId(String prefix) {
        if ("".equals(prefix)) {
            return this.allKeywordsPlusId();
        }
        TreeSet<Integer> ret = new TreeSet<Integer>();
        for (int s : this.allKeywordsPlusId()) {
            if (!CodeCompleter.cyk.allSymbols[s].startsWith("'" + prefix)) continue;
            ret.add(s);
        }
        return ret;
    }

    public Set<Integer> rules(int start, int end) {
        Set<Integer> candidate;
        Set<Integer> ss;
        int i;
        if (this.rulesStartedWithMap == null) {
            this.rulesStartedWithMap = new Set[CodeCompleter.cyk.allSymbols.length];
            for (i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
                ss = this.startingSymbols(i);
                if (ss == null) continue;
                for (int s : ss) {
                    candidate = this.rulesStartedWithMap[s];
                    if (candidate == null) {
                        this.rulesStartedWithMap[s] = candidate = new HashSet<Integer>();
                    }
                    candidate.add(i);
                }
            }
        }
        if (this.rulesEndingWithMap == null) {
            this.rulesEndingWithMap = new Set[CodeCompleter.cyk.allSymbols.length];
            for (i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
                ss = this.endingSymbols(i);
                if (ss == null) continue;
                for (int s : ss) {
                    candidate = this.rulesEndingWithMap[s];
                    if (candidate == null) {
                        candidate = new HashSet<Integer>();
                        this.rulesEndingWithMap[s] = candidate;
                    }
                    candidate.add(i);
                }
            }
        }
        HashSet<Integer> ret = new HashSet<Integer>();
        for (int candidate2 : this.rulesStartedWithMap[start]) {
            if (!this.rulesEndingWithMap[end].contains(candidate2)) continue;
            ret.add(candidate2);
        }
        return ret;
    }

    List<String> snippets(String keyword) {
        LinkedList<String> ret = new LinkedList<String>();
        int ik = (Integer)CodeCompleter.cyk.symbolIndexes.get("'" + keyword + "'");
        int in = (Integer)CodeCompleter.cyk.symbolIndexes.get("';'");
        for (int ss : this.rules(ik, in)) {
            System.out.println(CodeCompleter.cyk.allSymbols[ss]);
        }
        return ret;
    }

    List<ArrayInt> unroll(ArrayInt sentence) {
        LinkedList<ArrayInt> ret = new LinkedList<ArrayInt>();
        int pos = -1;
        for (int i : sentence.data) {
            String symbol;
            ++pos;
            if (CodeCompleter.isTemplateSymbol(i) || (symbol = CodeCompleter.cyk.allSymbols[i]).startsWith("'") && symbol.indexOf("+") < 0) continue;
            Set<Integer> singleRhs = this.singleRhsProductions[i];
            if (0 < singleRhs.size()) {
                for (int r : singleRhs) {
                    int[] clone = new int[sentence.data.length];
                    for (int j = 0; j < clone.length; ++j) {
                        clone[j] = j == pos ? r : sentence.data[j];
                    }
                    ret.add(new ArrayInt(clone));
                }
            }
            for (CYK.ChomskiTuple t : CodeCompleter.cyk.rules) {
                if (i != t.head || 0 > t.rhs1 || this.escape(t.rhs0) || this.escape(t.rhs1)) continue;
                int[] clone = new int[sentence.data.length + 1];
                for (int j = 0; j < clone.length; ++j) {
                    clone[j] = j < pos ? sentence.data[j] : (pos + 1 < j ? sentence.data[j - 1] : (j == pos ? t.rhs0 : t.rhs1));
                }
                ret.add(new ArrayInt(clone));
            }
        }
        return ret;
    }

    private void initAuxStructures() {
        int i;
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("..label.."));
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("mark_sql_stmt"));
        for (i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            if (!CodeCompleter.cyk.allSymbols[i].contains("..prag..") && !CodeCompleter.cyk.allSymbols[i].contains(".BULKandCOLLECT.")) continue;
            this.escape.add(i);
        }
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("datetime_link_expanded_n"));
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("interval_literal"));
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("stmt"));
        this.escape.add((Integer)CodeCompleter.cyk.symbolIndexes.get("':'"));
        this.obscureProductions.add((Integer)CodeCompleter.cyk.symbolIndexes.get("'CURRENT'"));
        this.obscureProductions.add((Integer)CodeCompleter.cyk.symbolIndexes.get("'EXECUTE'"));
        this.obscureProductions.add((Integer)CodeCompleter.cyk.symbolIndexes.get("'FORALL'"));
        this.obscureProductions.add((Integer)CodeCompleter.cyk.symbolIndexes.get("'PIPE'"));
        this.obscureProductions.add(Service.pair((Integer)CodeCompleter.cyk.symbolIndexes.get("set_function_specification"), (Integer)CodeCompleter.cyk.symbolIndexes.get("'COUNT'")));
        this.obscureProductions.add(Service.pair((Integer)CodeCompleter.cyk.symbolIndexes.get("pri"), (Integer)CodeCompleter.cyk.symbolIndexes.get("'NULL'")));
        this.singleRhsProductions = new Set[CodeCompleter.cyk.allSymbols.length];
        for (i = 0; i < CodeCompleter.cyk.allSymbols.length; ++i) {
            HashSet<Integer> tmp = new HashSet<Integer>();
            for (int j = 0; j < CodeCompleter.cyk.allSymbols.length; ++j) {
                if (!CodeCompleter.cyk.singleRhsRules[j].contains(i) || i == j || this.obscureProductions.contains(j) || this.escapeIntermediatory(i, j)) continue;
                tmp.add(j);
            }
            this.singleRhsProductions[i] = tmp;
        }
    }

    private boolean escapeIntermediatory(int i, int j) {
        if (this.obscureProductions.contains(Service.pair(i, j))) {
            return true;
        }
        Iterator i$ = CodeCompleter.cyk.singleRhsRules[j].iterator();
        while (i$.hasNext()) {
            int k = (Integer)i$.next();
            if (i == k || j == k || !this.escape(k) && !CodeCompleter.isTemplateSymbol(k) && !this.obscureProductions.contains(Service.pair(k, j))) continue;
            Iterator i$2 = CodeCompleter.cyk.singleRhsRules[k].iterator();
            while (i$2.hasNext()) {
                int l = (Integer)i$2.next();
                if (l != i) continue;
                return true;
            }
        }
        return false;
    }

    private boolean escape(int symbol) {
        for (int e : this.escape) {
            if (e != symbol) continue;
            return true;
        }
        return false;
    }

    void print(ArrayInt stmt) {
        for (int t : stmt.data) {
            System.out.print(CodeCompleter.cyk.allSymbols[t] + " ");
        }
        System.out.println();
        ++cnt;
    }

    public static boolean isTemplateSymbol(int s) {
        if (s == CodeCompleter.cyk.identifier) {
            return true;
        }
        if (seq_of_stmts == -1) {
            seq_of_stmts = cyk.getSymbol("..stmt..");
        }
        if (s == seq_of_stmts) {
            return true;
        }
        if (boolean_primary == -1) {
            boolean_primary = cyk.getSymbol("boolean_primary");
        }
        if (s == boolean_primary) {
            return true;
        }
        if (query_expression == -1) {
            query_expression = cyk.getSymbol("query_expression");
        }
        return s == query_expression;
    }

    private static boolean isEndForm(ArrayInt sentence) {
        for (int i : sentence.data) {
            String symbol;
            if (CodeCompleter.isTemplateSymbol(i) || (symbol = CodeCompleter.cyk.allSymbols[i]).startsWith("'") && symbol.indexOf("+") < 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        CodeCompleter cc = new CodeCompleter();
        cc.initAuxStructures();
        HashSet<ArrayInt> current = new HashSet<ArrayInt>();
        int[] nArray = new int[1];
        nArray[0] = CodeCompleter.cyk.stmt;
        current.addAll(cc.unroll(new ArrayInt(nArray)));
        try {
            for (int i = 0; i < 10; ++i) {
                HashSet<ArrayInt> next = new HashSet<ArrayInt>();
                for (ArrayInt s : current) {
                    String sym = CodeCompleter.cyk.allSymbols[s.data[0]];
                    List<ArrayInt> gen = cc.unroll(s);
                    for (ArrayInt g : gen) {
                        if (!CodeCompleter.isEndForm(g)) continue;
                        Set<ArrayInt> ts = cc.templates.get(g.data[0]);
                        if (ts == null) {
                            ts = new HashSet<ArrayInt>();
                            cc.templates.put(g.data[0], ts);
                        }
                        if (ts.size() >= 3 || !ts.add(g)) continue;
                        cc.print(g);
                    }
                    next.addAll(gen);
                }
                next.removeAll(current);
                current = next;
                System.out.println("-----------------");
            }
        }
        finally {
            System.out.println(cnt);
            FileOutputStream fos = new FileOutputStream("utils-nodeps/src/oracle/dbtools/parser/plsql/serializedTemplates.xml");
            ObjectOutputStream out = new ObjectOutputStream(fos);
            out.writeObject(cc.templates);
            out.close();
        }
    }

    private class SymbolAtCell
    implements Comparable<SymbolAtCell> {
        int interval;
        int symbol;

        SymbolAtCell(int p, int r) {
            this.interval = p;
            this.symbol = r;
        }

        @Override
        public int compareTo(SymbolAtCell arg) {
            if (arg.interval != this.interval) {
                return this.interval - arg.interval;
            }
            return this.symbol - arg.symbol;
        }

        public String toString() {
            return cyk.allSymbols[this.symbol] + "[" + Service.X(this.interval) + "," + Service.Y(this.interval) + ")";
        }
    }
}

