/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.parser.RuleTuple;
import oracle.dbtools.util.Service;

public class RuleTransforms {
    private static List<String> exceptions = new LinkedList<String>();

    public static void removeRule(String head, Set<RuleTuple> src) {
        TreeSet<RuleTuple> tmp = new TreeSet<RuleTuple>();
        for (RuleTuple candidate : src) {
            if (!head.equals(candidate.head)) continue;
            tmp.add(candidate);
        }
        src.removeAll(tmp);
    }

    public static void substituteSymbol(String symbol, String alias, Set<RuleTuple> src) {
        if (!symbol.endsWith(")") && alias.endsWith(")")) {
            exceptions.add(symbol);
            return;
        }
        System.out.println(symbol + "-->" + alias);
        for (RuleTuple candidate : src) {
            for (int i = 0; i < candidate.rhs.length; ++i) {
                if (!candidate.rhs[i].equals(symbol)) continue;
                candidate.rhs[i] = alias;
            }
        }
        RuleTransforms.removeRule(symbol, src);
    }

    public static void substituteAll(Set<RuleTuple> src) {
        while (true) {
            String what = null;
            String by = null;
            for (RuleTuple c1 : src) {
                boolean ok = true;
                for (RuleTuple c2 : src) {
                    if (!c1.head.equals(c2.head) || c1.equals(c2)) continue;
                    ok = false;
                    break;
                }
                if (!ok || c1.rhs.length != 1) continue;
                what = c1.head;
                by = c1.rhs[0];
                if (!exceptions.contains(what)) break;
                what = null;
            }
            if (what == null || by == null) break;
            RuleTransforms.substituteSymbol(what, by, src);
        }
    }

    public static Set<RuleTuple> eliminateEmptyProductions(Set<RuleTuple> input) {
        Set<RuleTuple> nonEmptyRules = null;
        Set<RuleTuple> tmp = input;
        while ((tmp = RuleTransforms.eliminateEmptyProduction(nonEmptyRules = tmp)) != null) {
        }
        return nonEmptyRules;
    }

    static Set<RuleTuple> eliminateEmptyProduction(Set<RuleTuple> rules) {
        TreeSet<RuleTuple> ret = new TreeSet<RuleTuple>();
        String emptyHeader = null;
        for (RuleTuple rule : rules) {
            if (rule.rhs.length != 0) continue;
            emptyHeader = rule.head;
            break;
        }
        if (emptyHeader == null) {
            return null;
        }
        for (RuleTuple rule : rules) {
            int i;
            if (rule.head.equals(emptyHeader) && rule.rhs.length == 0) continue;
            int countEmptySymbols = 0;
            for (i = 0; i < rule.rhs.length; ++i) {
                if (!emptyHeader.equals(rule.rhs[i])) continue;
                ++countEmptySymbols;
            }
            ret.add(rule);
            if (countEmptySymbols == 1) {
                for (i = 0; i < rule.rhs.length; ++i) {
                    if (!emptyHeader.equals(rule.rhs[i])) continue;
                    String[] rhs = new String[rule.rhs.length - 1];
                    for (int j = 0; j < rule.rhs.length - 1; ++j) {
                        if (j < i) {
                            rhs[j] = rule.rhs[j];
                            continue;
                        }
                        if (j < i) continue;
                        rhs[j] = rule.rhs[j + 1];
                    }
                    ret.add(new RuleTuple(rule.head, rhs));
                }
                continue;
            }
            if (countEmptySymbols == 2) {
                if (rule.rhs.length == 2) continue;
                String[] rhs01 = new String[rule.rhs.length - 1];
                String[] rhs10 = new String[rule.rhs.length - 1];
                String[] rhs11 = new String[rule.rhs.length - 2];
                int bit = 0;
                for (int i2 = 0; i2 < rule.rhs.length; ++i2) {
                    if (emptyHeader.equals(rule.rhs[i2])) {
                        if (bit == 0) {
                            rhs10[i2] = rule.rhs[i2];
                        } else if (bit == 1) {
                            rhs01[i2 - 1] = rule.rhs[i2];
                        }
                        ++bit;
                        continue;
                    }
                    rhs01[i2 - (bit > 0 ? 1 : 0)] = rule.rhs[i2];
                    rhs10[i2 - (bit > 1 ? 1 : 0)] = rule.rhs[i2];
                    rhs11[i2 - bit] = rule.rhs[i2];
                }
                ret.add(new RuleTuple(rule.head, rhs01));
                ret.add(new RuleTuple(rule.head, rhs10));
                ret.add(new RuleTuple(rule.head, rhs11));
                continue;
            }
            if (countEmptySymbols <= 2) continue;
            throw new RuntimeException("countEmptySymbols > 2 " + rule.toString());
        }
        return ret;
    }

    public static void printRulesHierachy(String name, Set<RuleTuple> rules) {
        System.out.println("-------------Rules Hierachy------------");
        int prefixEnd = name.indexOf(91);
        LinkedList<RuleTuple> subset = new LinkedList<RuleTuple>();
        for (RuleTuple rule : rules) {
            if (!rule.head.startsWith(prefixEnd > 0 ? name.substring(0, prefixEnd) : name)) continue;
            subset.add(rule);
        }
        RuleTransforms.printRule(name, subset, 0);
        System.out.println("-------------------------------------");
    }

    private static void printRule(String name, List<RuleTuple> subset, int offset) {
        for (RuleTuple rule : subset) {
            if (!rule.head.equals(name)) continue;
            Service.identln(offset, rule.toString());
            for (int i = 0; i < rule.rhs.length; ++i) {
                RuleTransforms.printRule(rule.rhs[i], subset, offset + 1);
            }
        }
    }

    public static void print(Set<RuleTuple> rules) {
        for (RuleTuple r : rules) {
            System.out.println(r.toString() + ";");
        }
    }

    public static void printSelectedRules(String name, Set<RuleTuple> rules) {
        System.out.println("-------------Rules---------------");
        for (RuleTuple rule : rules) {
            if (!rule.toString().contains(name)) continue;
            System.out.println(rule.toString());
        }
        System.out.println("-------------------------------------");
    }
}

