/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.parser;

import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.dbtools.parser.Token;
import oracle.dbtools.util.Service;

public class LexerToken {
    public String content;
    public int begin;
    public int end;
    public Token type;

    public LexerToken(CharSequence text, int from, int to, Token t) {
        this.content = ((Object)text).toString().intern();
        this.begin = from;
        this.end = to;
        this.type = t;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        return "[" + this.begin + "," + this.end + ") " + this.content + "   <" + (Object)((Object)this.type) + ">";
    }

    public static void print(List<LexerToken> src) {
        int j = 0;
        for (LexerToken t : src) {
            System.out.print(j + "    ");
            t.print();
            ++j;
        }
    }

    public static void print(List<LexerToken> src, int from, int to) {
        for (int i = from; i < to; ++i) {
            System.out.print(" " + src.get((int)i).content);
        }
        System.out.println();
    }

    public static LinkedList<LexerToken> tokenize(String sourceExpr, boolean quotedStrings) {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        String operation = "(){}[]^-|!*+./><='\",;:%@?";
        String ws = " \n\r\t";
        StringTokenizer st = new StringTokenizer(sourceExpr, "(){}[]^-|!*+./><='\",;:%@? \n\r\t", true);
        int pos = 0;
        String altQuote = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().intern();
            pos += token.length();
            LexerToken last = null;
            if (ret.size() > 0) {
                last = ret.getLast();
            }
            if (last != null && last.type == Token.COMMENT && (!last.content.endsWith("*/") || last.content.equals("/*/"))) {
                last.content = "*".equals(token) || "/".equals(token) ? last.content + token : "/* ... ";
                last.end = pos;
                if (last == null || last.type != Token.COMMENT || !last.content.endsWith("*/") || last.content.equals("/*/")) continue;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if (last != null && last.type == Token.LINE_COMMENT && !"\n".equals(token)) {
                last.content = last.content + token;
                continue;
            }
            if (last != null && last.type == Token.LINE_COMMENT && "\n".equals(token)) {
                last.end = pos - token.length();
                last.end = last.begin + last.content.length();
            }
            if (!(last == null || last.type != Token.QUOTED_STRING || "'".equals(token) || last.content.endsWith("'") && last.content.length() > 1)) {
                if (!"q".equals(altQuote)) continue;
                altQuote = token;
                continue;
            }
            if (!(last == null || last.type != Token.QUOTED_STRING || !"'".equals(token) || altQuote != null && !last.content.endsWith(LexerToken.quoteDelimiter(altQuote)) || last.content.endsWith("'") && last.content.length() > 1)) {
                altQuote = null;
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end).intern();
                continue;
            }
            if (last != null && last.type == Token.DQUOTED_STRING && !"\"".equals(token) && (!last.content.endsWith("\"") || last.content.length() <= 1)) continue;
            if (last != null && last.type == Token.DQUOTED_STRING && "\"".equals(token)) {
                last.end = pos;
                last.content = sourceExpr.substring(last.begin, last.end);
                continue;
            }
            if ("*".equals(token) && last != null && "/".equals(last.content)) {
                last.content = last.content + token;
                last.end = last.begin + last.content.length();
                last.type = Token.COMMENT;
                continue;
            }
            if ("-".equals(token) && last != null && "-".equals(last.content)) {
                last.content = last.content + token;
                last.type = Token.LINE_COMMENT;
                continue;
            }
            if (("rem".equalsIgnoreCase(token) || "rema".equalsIgnoreCase(token) || "remar".equalsIgnoreCase(token) || "remark".equalsIgnoreCase(token)) && last != null && ("\n".equals(last.content) || "\r".equals(last.content))) {
                ret.add(new LexerToken(token, pos - 1, -9, Token.LINE_COMMENT));
                continue;
            }
            if (quotedStrings && "'".equals(token)) {
                if (last != null && "q".equals(last.content)) {
                    altQuote = "q";
                    last.content = token;
                    last.type = Token.QUOTED_STRING;
                    continue;
                }
                ret.add(new LexerToken(token, pos - 1, -10, Token.QUOTED_STRING));
                continue;
            }
            if (quotedStrings && "\"".equals(token)) {
                ret.add(new LexerToken(token, pos - 1, -11, Token.DQUOTED_STRING));
                continue;
            }
            if ("(){}[]^-|!*+./><='\",;:%@?".contains(token)) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.OPERATION));
                continue;
            }
            if (" \n\r\t".contains(token)) {
                ret.add(new LexerToken(token, pos - 1, pos, Token.WS));
                continue;
            }
            if ('0' <= token.charAt(0) && token.charAt(0) <= '9') {
                ret.add(new LexerToken(token, pos - token.length(), pos, Token.DIGITS));
                continue;
            }
            ret.add(new LexerToken(token, pos - token.length(), pos, Token.IDENTIFIER));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String input = Service.readFile("D:\\Documents and Settings\\Dim\\.sqldeveloper\\BigTabs\\BIGEMP216959.sql");
        System.gc();
        long t1 = System.currentTimeMillis();
        long h = Runtime.getRuntime().totalMemory();
        long hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem=" + (h - hf));
        LinkedList<LexerToken> out = LexerToken.parse(input, true, true);
        long t2 = System.currentTimeMillis();
        System.out.println("Lexer time = " + (t2 - t1));
        System.gc();
        h = Runtime.getRuntime().totalMemory();
        hf = Runtime.getRuntime().freeMemory();
        System.out.println("mem1=" + (h - hf));
        System.out.println("#Tokens=" + out.size());
    }

    public static LinkedList<LexerToken> parse(String input) {
        return LexerToken.parse(input, false, true);
    }

    public static LinkedList<LexerToken> parse(String input, boolean keepWSandCOMMENTS) {
        return LexerToken.parse(input, keepWSandCOMMENTS, true);
    }

    public static LinkedList<LexerToken> parse(String input, boolean keepWSandCOMMENTS, boolean quotedStrings) {
        LinkedList<LexerToken> ret = new LinkedList<LexerToken>();
        LexerToken last = null;
        for (LexerToken token : LexerToken.tokenize(input, quotedStrings)) {
            if (token.type == Token.QUOTED_STRING && last != null && last.type == Token.QUOTED_STRING) {
                last.content = last.content + token.content;
                last.end = token.end;
                continue;
            }
            if (keepWSandCOMMENTS || token.type != Token.WS && token.type != Token.COMMENT && token.type != Token.LINE_COMMENT) {
                ret.add(token);
            }
            last = token;
        }
        return ret;
    }

    public static int scanner2parserOffset(List<LexerToken> src, int start) {
        int offset = -1;
        for (LexerToken t : src) {
            ++offset;
            if (t.end <= start) continue;
            break;
        }
        return offset;
    }

    private static String quoteDelimiter(String ch) {
        if ("<".equals(ch)) {
            return ">";
        }
        if ("[".equals(ch)) {
            return "]";
        }
        if ("{".equals(ch)) {
            return "}";
        }
        if ("(".equals(ch)) {
            return ")";
        }
        return ch;
    }
}

