/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud.wlst;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.OutputStream;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;

public class WLSTLogFetcher
extends Thread {
    protected Client jerseyClient = null;
    protected String baseUrl = null;
    protected OutputStream out = null;
    protected String sessionId = null;
    long wait = 0L;
    private volatile boolean done = true;
    private boolean newSession = false;

    public boolean isDone() {
        return this.done;
    }

    public void start() {
        this.done = false;
        super.start();
    }

    WLSTLogFetcher(Client jerseyClient, String baseUrl, OutputStream out, String sessionId) {
        this.jerseyClient = jerseyClient;
        this.baseUrl = baseUrl;
        this.out = out;
        this.sessionId = sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            String logid = null;
            while (!this.done) {
                ClientResponse r;
                WebResource w = this.jerseyClient.resource(this.baseUrl);
                w = w.path("output").queryParam("sessionid", this.sessionId);
                if (logid != null) {
                    w = w.queryParam("logid", logid);
                }
                if ((r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class)).getStatus() == 200) {
                    logid = (String)r.getHeaders().getFirst((Object)"X-SHELL-NEXT-LOG-ID");
                    byte[] data = (byte[])r.getEntity(byte[].class);
                    this.out.write(data);
                    this.out.flush();
                    if (data.length == 0) {
                        this.wait = this.wait <= 0L ? 500L : 2L * this.wait;
                        try {
                            Thread.currentThread();
                            Thread.sleep(this.wait);
                        }
                        catch (InterruptedException ie) {
                            this.wait = 0L;
                        }
                        continue;
                    }
                    this.wait = 0L;
                    continue;
                }
                if (r.getStatus() == 404) {
                    this.out.flush();
                    this.done = true;
                    continue;
                }
                throw RestUtils.handleResponseCode(r, "output", "config-shell");
            }
        }
        catch (Exception e) {
            if (!this.done) {
                e.printStackTrace();
            }
        }
        finally {
            this.done = true;
        }
    }
}

