/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud.filter;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.spi.SecurityTokenProvider;

public class SAMLTokenAuthFilter
extends ClientFilter {
    private static final String AUTH_HEADER = "Authorization";
    private String authHeaderValue;
    private SecurityTokenProvider trustTokProvider;

    public SAMLTokenAuthFilter(String user, SecurityTokenProvider provider) throws ServiceException {
        this.trustTokProvider = provider;
        String b64Tok = this.trustTokProvider.generateToken(user);
        this.authHeaderValue = "OIT " + b64Tok;
    }

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        if (!request.getHeaders().containsKey((Object)AUTH_HEADER)) {
            request.getHeaders().add((Object)AUTH_HEADER, (Object)this.authHeaderValue);
        }
        return this.getNext().handle(request);
    }
}

