/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.ServiceManagerJavaCloudImpl;
import oracle.cloudlogic.javaservice.common.api.ServiceManager;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.common.spi.Property;
import oracle.cloudlogic.javaservice.common.spi.ServiceManagerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerJavaCloudProviderImpl
implements ServiceManagerProvider {
    public ServiceManager createServiceManager(String url, String user, byte[] pwd, Map<String, Object> properties) throws ServiceException {
        try {
            properties = ServiceManagerJavaCloudProviderImpl.populateIdAndServiceInstance(url, properties);
            String id = (String)properties.get("identitydomain");
            String si = (String)properties.get("serviceinstance");
            URL u = new URL(url);
            URL newUrl = new URL(u.getProtocol(), u.getHost(), u.getPort(), "");
            Logger.getDEFAULT().printlnDebug("IdentityDomain:" + id + ", ServiceInstance=" + si);
            return new ServiceManagerJavaCloudImpl(newUrl.toExternalForm(), id, si, user, pwd, properties);
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), null, (Throwable)e);
        }
    }

    public String getServiceType() {
        return "javacloud-rest";
    }

    public List<Property> getAdditionalPropertyDescriptions(String url) throws ServiceException {
        try {
            Property p;
            ArrayList<Property> list = new ArrayList<Property>();
            Map<String, Object> properties = ServiceManagerJavaCloudProviderImpl.populateIdAndServiceInstance(url, null);
            String id = (String)properties.get("identitydomain");
            String si = (String)properties.get("serviceinstance");
            if (id == null) {
                p = new Property("identitydomain");
                list.add(p);
            }
            if (si == null) {
                p = new Property("serviceinstance");
                list.add(p);
            }
            return list;
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), null, (Throwable)e);
        }
    }

    private static Map<String, Object> populateIdAndServiceInstance(String url, Map<String, Object> map) throws Exception {
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        String id = null;
        String si = null;
        URL u = new URL(url);
        String path = u.getPath();
        if (path != null) {
            while (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            if (!path.trim().equals("")) {
                String[] idsi = path.split("/");
                if (idsi.length > 0) {
                    id = idsi[0];
                }
                if (idsi.length > 1) {
                    si = idsi[1];
                }
            }
        }
        if (id != null) {
            map.put("identitydomain", id);
        }
        if (si != null) {
            map.put("serviceinstance", si);
        }
        return map;
    }
}

