/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import oracle.cloud.paas.javaservice.types.CredentialType;
import oracle.cloud.paas.model.Job;
import oracle.cloud.paas.model.Library;
import oracle.cloud.paas.model.LibraryDeployType;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.CertificateServiceImpl;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.KeyServiceImpl;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.RestUtils;
import oracle.cloudlogic.javaservice.admin.impl.javacloud.ServiceManagerJavaCloudBaseImpl;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.service.MetaDataService;
import oracle.cloudlogic.javaservice.common.api.service.ReadonlySharedLibraryService;
import oracle.cloudlogic.javaservice.common.api.service.ResourceService;
import oracle.cloudlogic.javaservice.common.api.service.Service;
import oracle.cloudlogic.javaservice.common.api.service.async.library.AsyncOnDemandSharedLibraryService;
import oracle.cloudlogic.javaservice.common.api.service.async.library.AsyncUserSharedLibraryService;
import oracle.cloudlogic.javaservice.common.api.service.resource.CertificateService;
import oracle.cloudlogic.javaservice.common.api.service.resource.KeyService;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.CommandType;
import oracle.cloudlogic.javaservice.types.CredentialMapType;
import oracle.cloudlogic.javaservice.types.JndiNamesType;
import oracle.cloudlogic.javaservice.types.JobType;
import oracle.cloudlogic.javaservice.types.LibStatus;
import oracle.cloudlogic.javaservice.types.LibType;
import oracle.cloudlogic.javaservice.types.LibraryType;
import oracle.cloudlogic.javaservice.types.StringListType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceManagerJavaCloudImpl
extends ServiceManagerJavaCloudBaseImpl
implements ReadonlySharedLibraryService,
AsyncUserSharedLibraryService,
AsyncOnDemandSharedLibraryService,
MetaDataService {
    ServiceManagerJavaCloudImpl(String url, String identityDomain, String serviceInstance, String user, byte[] pwd, Map<String, Object> properties) throws ServiceException {
        super(url, identityDomain, serviceInstance, user, pwd, properties);
    }

    public String getMethodDescription(Class<? extends Service> clazz, String methodName) {
        return "IdentityDomain=" + this.identityDomain + ", ServiceInstance=" + this.serviceInstance;
    }

    public boolean isUnImplemented(Class<? extends Service> clazz, String methodName) {
        return false;
    }

    public JobType installOnDemandSharedLibraryAsync(String name, String specversion, String implversion) throws ServiceException {
        Library lib = new Library();
        lib.setDeployType(LibraryDeployType.ONDEMAND);
        lib.setImplVersion(implversion);
        lib.setSpecVersion(specversion);
        lib.setName(name);
        try {
            Job job = this.libManager.deployLibrary(lib, null);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "on-demand-library");
            return null;
        }
    }

    public JobType deleteOnDemandSharedLibraryAsync(String name, String specversion, String implversion) throws ServiceException {
        Library lib = new Library();
        lib.setDeployType(LibraryDeployType.ONDEMAND);
        lib.setImplVersion(implversion);
        lib.setSpecVersion(specversion);
        lib.setDomainName(this.identityDomain);
        lib.setInstanceName(this.serviceInstance);
        lib.setName(name);
        try {
            Job job = this.libManager.undeployLibrary(lib);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "on-demand-library");
            return null;
        }
    }

    public List<LibraryType> listOnDemandSharedLibraries(String name, String specversion, String implversion) throws ServiceException {
        try {
            List list = this.libManager.listLibraries(this.identityDomain, this.serviceInstance);
            return this.fromLibList(list, LibraryDeployType.ONDEMAND);
        }
        catch (Exception e) {
            this.handleException(e, name, "on-demand-library");
            return null;
        }
    }

    public List<LibraryType> fromLibList(List<Library> apps, LibraryDeployType type) {
        ArrayList<LibraryType> list = new ArrayList<LibraryType>();
        for (Library app : apps) {
            if (app.getDeployType() != type) continue;
            list.add(this.from(app));
        }
        return list;
    }

    public LibraryType from(Library app) {
        LibraryType t = new LibraryType();
        t.setImplversion(app.getImplVersion());
        t.setSpecversion(app.getSpecVersion());
        t.setName(app.getName());
        t.setType(LibType.valueOf((String)app.getType().toString().toUpperCase()));
        try {
            t.setStatus(LibStatus.fromValue((String)app.getState().toString().toUpperCase()));
        }
        catch (Exception e) {
            Logger.getDEFAULT().printlnDebug("Un-recognized lib-type:" + app.getState());
            t.setStatus(LibStatus.STATE_FAILED);
        }
        return t;
    }

    public JobType installUserSharedLibraryAsync(InputStream in, LibType type, String name, String specversion, String implversion) throws ServiceException {
        Library lib = new Library();
        lib.setDeployType(LibraryDeployType.CUSTOM);
        lib.setImplVersion(implversion);
        lib.setSpecVersion(specversion);
        lib.setName(name);
        try {
            Job job = this.libManager.deployLibrary(lib, in);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "user-library");
            return null;
        }
    }

    public JobType updateUserSharedLibraryAsync(InputStream in, String name, String specversion, String implversion) throws ServiceException {
        Library lib = new Library();
        lib.setDeployType(LibraryDeployType.CUSTOM);
        lib.setImplVersion(implversion);
        lib.setSpecVersion(specversion);
        lib.setName(name);
        try {
            Job job = this.libManager.redeployLibrary(lib, in);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "user-library");
            return null;
        }
    }

    public JobType deleteUserSharedLibraryAsync(String name, String specversion, String implversion) throws ServiceException {
        Library lib = new Library();
        lib.setDeployType(LibraryDeployType.CUSTOM);
        lib.setImplVersion(implversion);
        lib.setSpecVersion(specversion);
        lib.setName(name);
        try {
            Job job = this.libManager.undeployLibrary(lib);
            return this.from(job);
        }
        catch (Exception e) {
            this.handleException(e, name, "user-library");
            return null;
        }
    }

    public List<LibraryType> listUserSharedLibraries(String name, String specversion, String implversion) throws ServiceException {
        try {
            List list = this.libManager.listLibraries(this.identityDomain, this.serviceInstance);
            return this.fromLibList(list, LibraryDeployType.CUSTOM);
        }
        catch (Exception e) {
            this.handleException(e, name, "user-library");
            return null;
        }
    }

    public List<LibraryType> listReadOnlySharedLibraries(String name, String specversion, String implversion) throws ServiceException {
        try {
            List list = this.libManager.listLibraries(this.identityDomain, this.serviceInstance);
            return this.fromLibList(list, LibraryDeployType.READONLY);
        }
        catch (Exception e) {
            this.handleException(e, name, "read-only-library");
            return null;
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public KeyService getKeyService(String stripeName, String keystoreName) throws ServiceException {
        return new KeyServiceImpl(this.jerseyClient, this.URL_OPSS_KEYSTORE + stripeName + "/keystores/" + keystoreName + "/privatekeys/", (ResourceService)this);
    }

    public CertificateService getTrustService(String stripeName, String keystoreName) throws ServiceException {
        return new CertificateServiceImpl(this.jerseyClient, this.URL_OPSS_KEYSTORE + stripeName + "/keystores/" + keystoreName, (ResourceService)this);
    }

    public CertificateService getDomainLevelTrustService() throws ServiceException {
        return new CertificateServiceImpl(this.jerseyClient, this.URL_OPSS_KEYSTORE + "owsm/keystores/keystore/", (ResourceService)this);
    }

    public List<String> getKeyStores(String stripeName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_OPSS_KEYSTORE + "stripes/" + stripeName);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() != 200) {
            throw RestUtils.handleResponseCode(r, "", "list-keystores");
        }
        StringListType list = RestUtils.readObject(r, StringListType.class);
        return list.getItem();
    }

    public List<String> listStripes() throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_OPSS_KEYSTORE);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() != 200) {
            throw RestUtils.handleResponseCode(r, "", "list-stripes");
        }
        StringListType list = RestUtils.readObject(r, StringListType.class);
        return list.getItem();
    }

    public void deleteKeyStore(String stripeName, String keystoreName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_OPSS_KEYSTORE + "stripes/" + stripeName + "/stores/" + keystoreName);
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        if (r.getStatus() != 202) {
            throw RestUtils.handleResponseCode(r, "", "list-stripes");
        }
    }

    public void createKyeStore(String stripeName, String keystoreName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_OPSS_KEYSTORE + "stripes/" + stripeName + "/stores/" + keystoreName);
        Logger.getDEFAULT().printlnDebug("Posting at:" + w.toString());
        ClientResponse r = (ClientResponse)((WebResource.Builder)w.accept(new String[]{"application/xml"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class);
        if (r.getStatus() != 201) {
            throw RestUtils.handleResponseCode(r, "", "create-keystore");
        }
    }

    public void setKeyAsSSLIdentity(String alias) throws ServiceException {
        throw new ServiceException("UnImplemented ...");
    }

    public CertificateService getSSLTrustService() throws ServiceException {
        return new CertificateServiceImpl(this.jerseyClient, this.URL_SSL, (ResourceService)this);
    }

    public KeyService getSSLKeyService() throws ServiceException {
        throw new ServiceException("UnImplemented ...");
    }

    public List<CredentialMapType> listCredentialMaps() throws ServiceException {
        throw new ServiceException("UnImplemented ...");
    }

    public List<oracle.cloudlogic.javaservice.types.CredentialType> listCredentials(String mapName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_CREDENTIAL_STORE_SERVICE_ADMIN + "maps/").path(mapName);
        Logger.getDEFAULT().printlnDebug("Getting at:" + w.toString());
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() == 200) {
            CredentialMapType cred = RestUtils.readObject(r, CredentialMapType.class);
            return cred.getCredentials();
        }
        throw RestUtils.handleResponseCode(r, "", "credential");
    }

    public boolean setCredential(String mapName, oracle.cloudlogic.javaservice.types.CredentialType credential) throws ServiceException {
        ClientResponse r;
        block3: {
            WebResource w = null;
            this.jerseyClient.resource(this.URL_CREDENTIAL_STORE + mapName + "/credentials/" + credential.getKey());
            MultivaluedMapImpl formData = new MultivaluedMapImpl();
            r = null;
            formData.add((Object)"user", (Object)credential.getUser());
            formData.add((Object)"password", (Object)new String(credential.getPassword().getValue()));
            formData.add((Object)"desc", (Object)credential.getDescription());
            try {
                this.getCredential(mapName, credential.getKey());
                w = this.jerseyClient.resource(this.URL_CREDENTIAL_STORE + mapName + "/credentials/" + credential.getKey());
                Logger.getDEFAULT().printlnDebug("Putting at:" + w.toString());
                r = (ClientResponse)((WebResource.Builder)w.accept(new String[]{"application/xml"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).put(ClientResponse.class, (Object)formData);
                if (r.getStatus() == 204) {
                    return true;
                }
            }
            catch (UnknownResourceException un) {
                formData.add((Object)"key", (Object)credential.getKey());
                w = this.jerseyClient.resource(this.URL_CREDENTIAL_STORE + mapName);
                Logger.getDEFAULT().printlnDebug("Posting at:" + w.toString());
                r = (ClientResponse)((WebResource.Builder)w.accept(new String[]{"application/xml"}).type(MediaType.APPLICATION_FORM_URLENCODED_TYPE)).post(ClientResponse.class, (Object)formData);
                if (r.getStatus() != 201) break block3;
                return false;
            }
        }
        throw RestUtils.handleResponseCode(r, "", "credential");
    }

    public oracle.cloudlogic.javaservice.types.CredentialType getCredential(String mapName, String keyName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_CREDENTIAL_STORE + mapName + "/credentials/" + keyName);
        Logger.getDEFAULT().printlnDebug("Getting at:" + w.toString());
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).get(ClientResponse.class);
        if (r.getStatus() == 200) {
            CredentialType cred = RestUtils.readObject(r, CredentialType.class);
            return ServiceManagerJavaCloudImpl.from(cred, keyName);
        }
        throw RestUtils.handleResponseCode(r, "", "credential");
    }

    public void deleteCredential(String mapName, String keyName) throws ServiceException {
        WebResource w = this.jerseyClient.resource(this.URL_CREDENTIAL_STORE + mapName + "/credentials/" + keyName);
        Logger.getDEFAULT().printlnDebug("Deleting at:" + w.toString());
        ClientResponse r = (ClientResponse)w.accept(new String[]{"application/xml"}).delete(ClientResponse.class);
        if (r.getStatus() == 204) {
            return;
        }
        throw RestUtils.handleResponseCode(r, "", "credential");
    }

    public void deleteCredentialMap(String mapName) throws ServiceException {
        throw new ServiceException("UnImplemented ...");
    }

    private static oracle.cloudlogic.javaservice.types.CredentialType from(CredentialType cred, String key) {
        oracle.cloudlogic.javaservice.types.CredentialType ret = new oracle.cloudlogic.javaservice.types.CredentialType();
        ret.setDescription(cred.getDescription());
        ret.setUser(cred.getUser());
        ret.setKey(key);
        return ret;
    }

    public JndiNamesType listJndiNames(String dsName) throws ServiceException {
        return this.dataSourceJndi.listJndiNames(dsName);
    }

    public void addJndiName(String dsName, String alias) throws ServiceException {
        this.dataSourceJndi.addJndiName(dsName, alias);
    }

    public void deleteJndiName(String dsName, String alias) throws ServiceException {
        this.dataSourceJndi.deleteJndiName(dsName, alias);
    }

    public boolean initWLSTSession(OutputStream outputStream) throws ServiceException {
        return this.wlstaccess.initWLSTSession(outputStream);
    }

    public void goOnlineWLST() throws ServiceException {
        this.wlstaccess.goOnlineWLST();
    }

    public void goOffLineWLST() throws ServiceException {
        this.wlstaccess.goOffLineWLST();
    }

    public boolean isRunning() throws ServiceException {
        return this.wlstaccess.isRunning();
    }

    public void endWLSTSession() throws ServiceException {
        this.wlstaccess.endWLSTSession();
    }

    public void executeWLSTCommand(CommandType cmd) throws ServiceException {
        this.wlstaccess.executeWLSTCommand(cmd);
    }
}

