/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudlogic.javaservice.admin.impl.javacloud;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.MediaType;
import oracle.cloud.paas.javaservice.types.ExceptionType;
import oracle.cloudlogic.javaservice.common.api.exception.AuthenticationException;
import oracle.cloudlogic.javaservice.common.api.exception.DuplicateResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.NotAServiceUrlException;
import oracle.cloudlogic.javaservice.common.api.exception.ResourcePermissionException;
import oracle.cloudlogic.javaservice.common.api.exception.ServiceException;
import oracle.cloudlogic.javaservice.common.api.exception.UnknownResourceException;
import oracle.cloudlogic.javaservice.common.api.exception.ValidationException;
import oracle.cloudlogic.javaservice.common.clibase.util.logger.Logger;
import oracle.cloudlogic.javaservice.types.FailedActionResponseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    public static <T> T readObject(ClientResponse r, Class<T> t) throws ServiceException {
        MediaType content_type = r.getType();
        if (content_type == null) {
            throw new NotAServiceUrlException("Protocol violation: Please make sure you are connecting to the right administrative url. No content-type for the status " + r.getStatus());
        }
        if (!content_type.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            throw new NotAServiceUrlException("Protocol violation: Please make sure you are connecting to the right administrative url. Unknown Content-type " + content_type.toString() + " for the status " + r.getStatus());
        }
        return (T)r.getEntity(new GenericType(t));
    }

    public static ServiceException handleAdminServerResponseCode(ClientResponse r, String name, String type) {
        if (r.getHeaders().get((Object)"X-Oracle-Java-Service-Admin") == null) {
            return new NotAServiceUrlException();
        }
        String resourceName = (String)r.getHeaders().getFirst((Object)"X-Oracle-Java-Service-resource-name");
        String resourceType = (String)r.getHeaders().getFirst((Object)"X-Oracle-Java-Service-resource-type");
        if (resourceName != null && !resourceName.trim().equals("")) {
            name = resourceName;
            if (resourceType != null) {
                type = resourceType;
            }
        }
        if (r.getStatus() == 401) {
            return new AuthenticationException();
        }
        switch (r.getStatus()) {
            case 404: {
                return new UnknownResourceException(name, type);
            }
            case 403: 
            case 500: {
                return new ResourcePermissionException(name, type);
            }
            case 409: {
                return new DuplicateResourceException(name, type);
            }
        }
        return new ServiceException("System error with status:" + r.getStatus(), null, (byte[])r.getEntity(byte[].class));
    }

    public static boolean isForwardedResponse(ClientResponse r) {
        return r.getHeaders().get((Object)"X-Oracle-Java-Service-Admin") != null;
    }

    private static ServiceException handleForwardedResponseCode(ClientResponse r, String name, String type) {
        String resourceName = (String)r.getHeaders().getFirst((Object)"X-Oracle-Java-Service-resource-name");
        String resourceType = (String)r.getHeaders().getFirst((Object)"X-Oracle-Java-Service-resource-type");
        if (resourceName != null && !resourceName.trim().equals("")) {
            name = resourceName;
            if (resourceType != null) {
                type = resourceType;
            }
        }
        if (r.getStatus() == 401) {
            return new AuthenticationException();
        }
        if (r.getHeaders().get((Object)"X-Oracle-Java-Service-Admin") == null) {
            return new NotAServiceUrlException();
        }
        switch (r.getStatus()) {
            case 404: {
                return new UnknownResourceException(name, type);
            }
            case 500: {
                FailedActionResponseType fail = (FailedActionResponseType)r.getEntity(new GenericType(FailedActionResponseType.class));
                return new ServiceException(fail);
            }
            case 403: {
                return new ResourcePermissionException(name, type);
            }
            case 405: {
                return new ResourcePermissionException(name, type);
            }
            case 409: {
                return new DuplicateResourceException(name, type);
            }
        }
        return new ServiceException("System error with status:" + r.getStatus(), null, (byte[])r.getEntity(byte[].class));
    }

    public static ServiceException handleResponseCode(ClientResponse r, String name, String type) throws ServiceException {
        if (RestUtils.isForwardedResponse(r)) {
            return RestUtils.handleForwardedResponseCode(r, name, type);
        }
        if (r.getStatus() == 405) {
            return new ResourcePermissionException(name, type, "This operation not allowed on the resource '" + name + "' of type " + type);
        }
        if (r.getStatus() == 401) {
            return new AuthenticationException();
        }
        if (r.getStatus() == 403) {
            return new ResourcePermissionException(name, type);
        }
        if (r.getStatus() == 409 || r.getStatus() == 404 || r.getStatus() == 500 || r.getStatus() == 400) {
            MediaType content_type = r.getType();
            if (content_type == null) {
                return new NotAServiceUrlException("Protocol violation: Please make sure you are connecting to the right administrative url. No content-type for the status " + r.getStatus());
            }
            if (!content_type.isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                return new NotAServiceUrlException("Protocol violation: Please make sure you are connecting to the right administrative url. Unknown Content-type " + content_type.toString() + " for the status " + r.getStatus());
            }
            ExceptionType ex = RestUtils.readObject(r, ExceptionType.class);
            Logger.getDEFAULT().printlnDebug("Message:" + ex.getMessage());
            Logger.getDEFAULT().printlnDebug("Trace:" + ex.getStackTrace());
            Logger.getDEFAULT().printlnDebug("Type:" + ex.getType());
            Logger.getDEFAULT().printlnDebug("Args:" + ex.getArgs());
            Logger.getDEFAULT().printlnDebug("Status:" + r.getStatus());
            Logger.getDEFAULT().printlnDebug("Content-Type:" + content_type.toString());
            if (r.getStatus() == 400) {
                return new ValidationException(name, type, ex.getMessage());
            }
            if (r.getStatus() == 409) {
                return new DuplicateResourceException(name, type, ex.getMessage());
            }
            if (r.getStatus() == 404) {
                return new UnknownResourceException(name, type, ex.getMessage());
            }
            try {
                return new ServiceException(ex.getMessage(), null, ex.getStackTrace() == null ? null : ex.getStackTrace().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                ue.printStackTrace();
                return new ServiceException(ex.getMessage());
            }
        }
        return new ServiceException("System error with status:" + r.getStatus(), null, (byte[])r.getEntity(byte[].class));
    }
}

