/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeItem;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.ui.dialogs.MapOfStringsInputDialog;
import org.python.pydev.ui.editors.TreeWithAddRemove;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabVariables {
    private TreeWithAddRemove treeVariables;
    private TabFolder tabFolder;

    public TabVariables(TabFolder tabFolder, Map<String, String> initialVariables) {
        this.tabFolder = tabFolder;
        this.createTabVariables(initialVariables);
    }

    private void createTabVariables(Map<String, String> initialVariables) {
        if (initialVariables == null) {
            initialVariables = new HashMap<String, String>();
        }
        TabItem tabItem = new TabItem(this.tabFolder, 0);
        tabItem.setText("String Substitution Variables");
        tabItem.setImage(PydevPlugin.getImageCache().get("icons/build_var_obj.gif"));
        Composite topComp = new Composite((Composite)this.tabFolder, 0);
        topComp.setLayout((Layout)new GridLayout(1, false));
        Label l2 = new Label(topComp, 0);
        l2.setText("String substitution variables are used to resolve:\n  - source folders\n  - external libraries\n  - main module in launch configuration");
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = false;
        l2.setLayoutData((Object)gd);
        final Map<String, String> vars = initialVariables;
        this.treeVariables = new TreeWithAddRemove(topComp, 0, vars, true){

            protected String getImageConstant() {
                return "icons/build_var_obj.gif";
            }

            protected void handleAddButtonSelected(int nButton) {
                if (nButton != 0) {
                    throw new AssertionError((Object)"Unexpected (only 0 should be available)");
                }
                this.addItemWithDialog(new MapOfStringsInputDialog(this.getShell(), "Variable", "Enter the variable name/value.", vars){

                    protected boolean isExistingKeyEdit() {
                        return false;
                    }
                });
            }

            protected void handleEdit() {
                Tuple<String, String> keyAndValueEntered;
                TreeItem[] selection = this.tree.getSelection();
                if (selection.length != 1) {
                    return;
                }
                TreeItem treeItem = selection[0];
                if (treeItem == null) {
                    return;
                }
                final String fixedKeyText = treeItem.getText(0);
                MapOfStringsInputDialog dialog = new MapOfStringsInputDialog(this.getShell(), "Variable", "Enter the variable name/value.", vars){

                    protected Control createDialogArea(Composite parent) {
                        Control control = super.createDialogArea(parent);
                        this.keyField.setText(fixedKeyText);
                        this.keyField.setEditable(false);
                        this.valueField.setFocus();
                        String value = (String)vars.get(fixedKeyText);
                        if (value == null) {
                            value = "";
                        }
                        this.valueField.setText(value);
                        return control;
                    }

                    protected boolean isExistingKeyEdit() {
                        return true;
                    }

                    protected String getInitialMessage() {
                        return null;
                    }
                };
                if (dialog.open() == 0 && (keyAndValueEntered = dialog.getKeyAndValueEntered()) != null) {
                    vars.put((String)keyAndValueEntered.o1, (String)keyAndValueEntered.o2);
                    treeItem.setText(1, (String)keyAndValueEntered.o2);
                }
            }

            protected String getButtonLabel(int i) {
                if (i != 0) {
                    throw new RuntimeException("Expected only i==0. Received: " + i);
                }
                return "Add variable";
            }

            protected int getNumberOfAddButtons() {
                return 1;
            }
        };
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.treeVariables.setLayoutData(data);
        tabItem.setControl((Control)topComp);
    }

    public void setTreeItemsFromMap(Map<String, String> treeVariables) {
        this.treeVariables.setTreeItems(treeVariables);
    }

    public Map<String, String> getTreeItemsAsMap() {
        return this.treeVariables.getTreeItemsAsMap();
    }
}

