/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.editor.StyledTextForShowingCodeFactory;
import org.python.pydev.editor.actions.PyFormatStd;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.utils.ComboFieldEditor;

public class PyCodeFormatterPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String FORMAT_BEFORE_SAVING = "FORMAT_BEFORE_SAVING";
    public static final boolean DEFAULT_FORMAT_BEFORE_SAVING = false;
    public static final String AUTO_FORMAT_ONLY_WORKSPACE_FILES = "AUTO_FORMAT_ONLY_WORKSPACE_FILES";
    public static final boolean DEFAULT_AUTO_FORMAT_ONLY_WORKSPACE_FILES = true;
    public static final String FORMAT_ONLY_CHANGED_LINES = "FORMAT_ONLY_CHANGED_LINES";
    public static final boolean DEFAULT_FORMAT_ONLY_CHANGED_LINES = false;
    public static final String TRIM_LINES = "TRIM_EMPTY_LINES";
    public static final boolean DEFAULT_TRIM_LINES = false;
    public static final String TRIM_MULTILINE_LITERALS = "TRIM_MULTILINE_LITERALS";
    public static final boolean DEFAULT_TRIM_MULTILINE_LITERALS = false;
    public static final String ADD_NEW_LINE_AT_END_OF_FILE = "ADD_NEW_LINE_AT_END_OF_FILE";
    public static final boolean DEFAULT_ADD_NEW_LINE_AT_END_OF_FILE = true;
    public static final String USE_SPACE_AFTER_COMMA = "USE_SPACE_AFTER_COMMA";
    public static final boolean DEFAULT_USE_SPACE_AFTER_COMMA = true;
    public static final String USE_SPACE_FOR_PARENTESIS = "USE_SPACE_FOR_PARENTESIS";
    public static final boolean DEFAULT_USE_SPACE_FOR_PARENTESIS = false;
    public static final String USE_ASSIGN_WITH_PACES_INSIDER_PARENTESIS = "USE_ASSIGN_WITH_PACES_INSIDER_PARENTESIS";
    public static final boolean DEFAULT_USE_ASSIGN_WITH_PACES_INSIDE_PARENTESIS = false;
    public static final String USE_OPERATORS_WITH_SPACE = "USE_OPERATORS_WITH_SPACE";
    public static final boolean DEFAULT_USE_OPERATORS_WITH_SPACE = true;
    public static final String SPACES_BEFORE_COMMENT = "SPACES_BEFORE_COMMENT";
    public static final int DEFAULT_SPACES_BEFORE_COMMENT = 2;
    public static final String SPACES_IN_START_COMMENT = "SPACES_IN_START_COMMENT";
    public static final int DEFAULT_SPACES_IN_START_COMMENT = 1;
    private StyledText labelExample;
    private BooleanFieldEditor spaceAfterComma;
    private BooleanFieldEditor onlyChangedLines;
    private BooleanFieldEditor spaceForParentesis;
    private BooleanFieldEditor assignWithSpaceInsideParentesis;
    private BooleanFieldEditor operatorsWithSpace;
    private BooleanFieldEditor rightTrimLines;
    private BooleanFieldEditor rightTrimMultilineLiterals;
    private BooleanFieldEditor addNewLineAtEndOfFile;
    private StyledTextForShowingCodeFactory formatAndStyleRangeHelper;
    private ComboFieldEditor spacesBeforeComment;
    private ComboFieldEditor spacesInStartComment;
    private static final String[][] ENTRIES_AND_VALUES_FOR_SPACES = new String[][]{{"Don't change manual formatting", Integer.toString(-1)}, {"No spaces", "0"}, {"1 space", "1"}, {"2 spaces", "2"}, {"3 spaces", "3"}, {"4 spaces", "4"}};
    private static final String[][] ENTRIES_AND_VALUES_FOR_SPACES2 = new String[][]{{"Don't change manual formatting", Integer.toString(-1)}, {"At least 1 space", "1"}, {"At least 2 spaces", "2"}, {"At least 3 spaces", "3"}, {"At least 4 spaces", "4"}};

    public PyCodeFormatterPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)this.createBooleanFieldEditor(FORMAT_BEFORE_SAVING, "Auto-format editor contents before saving?", p));
        this.addField((FieldEditor)this.createBooleanFieldEditor(AUTO_FORMAT_ONLY_WORKSPACE_FILES, "Auto-format only files in the workspace?", p));
        this.onlyChangedLines = this.createBooleanFieldEditor(FORMAT_ONLY_CHANGED_LINES, "On save, only apply formatting in changed lines?", p);
        this.addField((FieldEditor)this.onlyChangedLines);
        this.spaceAfterComma = this.createBooleanFieldEditor(USE_SPACE_AFTER_COMMA, "Use space after commas?", p);
        this.addField((FieldEditor)this.spaceAfterComma);
        this.spaceForParentesis = this.createBooleanFieldEditor(USE_SPACE_FOR_PARENTESIS, "Use space before and after parenthesis?", p);
        this.addField((FieldEditor)this.spaceForParentesis);
        this.assignWithSpaceInsideParentesis = this.createBooleanFieldEditor(USE_ASSIGN_WITH_PACES_INSIDER_PARENTESIS, "Use space before and after assign for keyword arguments?", p);
        this.addField((FieldEditor)this.assignWithSpaceInsideParentesis);
        this.operatorsWithSpace = this.createBooleanFieldEditor(USE_OPERATORS_WITH_SPACE, "Use space before and after operators? (+, -, /, *, //, **, etc.)", p);
        this.addField((FieldEditor)this.operatorsWithSpace);
        this.rightTrimLines = this.createBooleanFieldEditor(TRIM_LINES, "Right trim lines?", p);
        this.addField((FieldEditor)this.rightTrimLines);
        this.rightTrimMultilineLiterals = this.createBooleanFieldEditor(TRIM_MULTILINE_LITERALS, "Right trim multi-line string literals?", p);
        this.addField((FieldEditor)this.rightTrimMultilineLiterals);
        this.addNewLineAtEndOfFile = this.createBooleanFieldEditor(ADD_NEW_LINE_AT_END_OF_FILE, "Add new line at end of file?", p);
        this.addField((FieldEditor)this.addNewLineAtEndOfFile);
        this.spacesBeforeComment = new ComboFieldEditor(SPACES_BEFORE_COMMENT, "Spaces before a comment?", ENTRIES_AND_VALUES_FOR_SPACES, p);
        this.addField(this.spacesBeforeComment);
        this.spacesInStartComment = new ComboFieldEditor(SPACES_IN_START_COMMENT, "Spaces in comment start?", ENTRIES_AND_VALUES_FOR_SPACES2, p);
        this.addField(this.spacesInStartComment);
        this.formatAndStyleRangeHelper = new StyledTextForShowingCodeFactory();
        this.labelExample = this.formatAndStyleRangeHelper.createStyledTextForCodePresentation(p);
        GridData layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.labelExample.setLayoutData((Object)layoutData);
        this.updateLabelExample(PyFormatStd.getFormat());
    }

    private BooleanFieldEditor createBooleanFieldEditor(String name, String label, Composite parent) {
        return new BooleanFieldEditor(name, label, 1, parent);
    }

    private void updateLabelExample(PyFormatStd.FormatStd formatStd) {
        String str = "class Example(object):             \n                                   \n    def Call(self, param1=None):   \n        '''docstring'''            \n        return param1 + 10 * 10    \n                                   \n    def Call2(self): #Comment      \n        #Comment                   \n        return self.Call(param1=10)";
        Tuple<String, StyleRange[]> result = this.formatAndStyleRangeHelper.formatAndGetStyleRanges(formatStd, str, PydevPrefs.getChainedPrefStore(), true);
        this.labelExample.setText((String)result.o1);
        this.labelExample.setStyleRanges((StyleRange[])result.o2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        PyFormatStd.FormatStd formatStd = new PyFormatStd.FormatStd();
        formatStd.assignWithSpaceInsideParens = this.assignWithSpaceInsideParentesis.getBooleanValue();
        formatStd.operatorsWithSpace = this.operatorsWithSpace.getBooleanValue();
        formatStd.parametersWithSpace = this.spaceForParentesis.getBooleanValue();
        formatStd.spaceAfterComma = this.spaceAfterComma.getBooleanValue();
        formatStd.addNewLineAtEndOfFile = this.addNewLineAtEndOfFile.getBooleanValue();
        formatStd.trimLines = this.rightTrimLines.getBooleanValue();
        formatStd.trimMultilineLiterals = this.rightTrimMultilineLiterals.getBooleanValue();
        formatStd.spacesBeforeComment = Integer.parseInt(this.spacesBeforeComment.getComboValue());
        formatStd.spacesInStartComment = Integer.parseInt(this.spacesInStartComment.getComboValue());
        this.updateLabelExample(formatStd);
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean getFormatBeforeSaving() {
        return PydevPrefs.getPreferences().getBoolean(FORMAT_BEFORE_SAVING);
    }

    public static boolean getAutoformatOnlyWorkspaceFiles() {
        return PydevPrefs.getPreferences().getBoolean(AUTO_FORMAT_ONLY_WORKSPACE_FILES);
    }

    public static boolean getFormatOnlyChangedLines() {
        return PydevPrefs.getPreferences().getBoolean(FORMAT_ONLY_CHANGED_LINES);
    }

    public static boolean getAddNewLineAtEndOfFile() {
        return PydevPrefs.getPreferences().getBoolean(ADD_NEW_LINE_AT_END_OF_FILE);
    }

    public static boolean getTrimLines() {
        return PydevPrefs.getPreferences().getBoolean(TRIM_LINES);
    }

    public static boolean getTrimMultilineLiterals() {
        return PydevPrefs.getPreferences().getBoolean(TRIM_MULTILINE_LITERALS);
    }

    public static boolean useSpaceAfterComma() {
        return PydevPrefs.getPreferences().getBoolean(USE_SPACE_AFTER_COMMA);
    }

    public static boolean useSpaceForParentesis() {
        return PydevPrefs.getPreferences().getBoolean(USE_SPACE_FOR_PARENTESIS);
    }

    public static boolean useAssignWithSpacesInsideParenthesis() {
        return PydevPrefs.getPreferences().getBoolean(USE_ASSIGN_WITH_PACES_INSIDER_PARENTESIS);
    }

    public static boolean useOperatorsWithSpace() {
        return PydevPrefs.getPreferences().getBoolean(USE_OPERATORS_WITH_SPACE);
    }

    public static int getSpacesBeforeComment() {
        int spaces = PydevPrefs.getPreferences().getInt(SPACES_BEFORE_COMMENT);
        if (spaces < -1) {
            spaces = -1;
        }
        return spaces;
    }

    public static int getSpacesInStartComment() {
        int spaces = PydevPrefs.getPreferences().getInt(SPACES_IN_START_COMMENT);
        if (spaces < -1) {
            spaces = -1;
        }
        return spaces;
    }

    public void dispose() {
        super.dispose();
        this.formatAndStyleRangeHelper.dispose();
    }
}

