/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ColorCache;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.bundle.BundleInfo;
import org.python.pydev.shared_ui.bundle.IBundleInfo;
import org.python.pydev.ui.interpreters.IronpythonInterpreterManager;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.interpreters.PythonInterpreterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevPlugin
extends AbstractUIPlugin {
    public static final String version = "2.7.5.2013052819";
    public static IBundleInfo info;
    private static IInterpreterManager pythonInterpreterManager;
    private static IInterpreterManager jythonInterpreterManager;
    private static IInterpreterManager ironpythonInterpreterManager;
    private static PydevPlugin plugin;
    private ColorCache colorCache;
    private ResourceBundle resourceBundle;
    public static final String DEFAULT_PYDEV_SCOPE = "org.python.pydev";
    private boolean isAlive;
    private Set<String> erasePrefixes = new HashSet<String>();
    private static ImageCache imageCache;
    static File location;

    static {
        imageCache = null;
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(PydevPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public static void setPythonInterpreterManager(IInterpreterManager interpreterManager) {
        pythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getPythonInterpreterManager() {
        return PydevPlugin.getPythonInterpreterManager(false);
    }

    public static IInterpreterManager getPythonInterpreterManager(boolean haltOnStub) {
        return pythonInterpreterManager;
    }

    public static void setJythonInterpreterManager(IInterpreterManager interpreterManager) {
        jythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getJythonInterpreterManager() {
        return PydevPlugin.getJythonInterpreterManager(false);
    }

    public static IInterpreterManager getJythonInterpreterManager(boolean haltOnStub) {
        return jythonInterpreterManager;
    }

    public static void setIronpythonInterpreterManager(IInterpreterManager interpreterManager) {
        ironpythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getIronpythonInterpreterManager() {
        return PydevPlugin.getIronpythonInterpreterManager(false);
    }

    public static IInterpreterManager getIronpythonInterpreterManager(boolean haltOnStub) {
        return ironpythonInterpreterManager;
    }

    public static IInterpreterManager[] getAllInterpreterManagers() {
        return new IInterpreterManager[]{PydevPlugin.getPythonInterpreterManager(), PydevPlugin.getJythonInterpreterManager(), PydevPlugin.getIronpythonInterpreterManager()};
    }

    public static IInterpreterManager getInterpreterManager(IPythonNature nature) {
        try {
            return PydevPlugin.getInterpreterManagerFromType(nature.getInterpreterType());
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static IInterpreterManager getInterpreterManagerFromType(int interpreterType) {
        try {
            switch (interpreterType) {
                case 1: {
                    return jythonInterpreterManager;
                }
                case 0: {
                    return pythonInterpreterManager;
                }
                case 2: {
                    return ironpythonInterpreterManager;
                }
            }
            throw new RuntimeException("Unable to get the interpreter manager for unknown interpreter type: " + interpreterType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PydevPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        this.isAlive = true;
        super.start(context);
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.PyDevPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        IPreferenceStore preferences = plugin.getPreferenceStore();
        PydevPlugin.setPythonInterpreterManager(new PythonInterpreterManager(preferences));
        PydevPlugin.setJythonInterpreterManager(new JythonInterpreterManager(preferences));
        PydevPlugin.setIronpythonInterpreterManager(new IronpythonInterpreterManager(preferences));
    }

    public File getTempFile(String prefix) {
        this.erasePrefixes.add(prefix);
        IPath stateLocation = this.getStateLocation();
        File file = stateLocation.toFile();
        File tempFileAt = FileUtils.getTempFileAt((File)file, (String)prefix);
        return tempFileAt;
    }

    public void stop(BundleContext context) throws Exception {
        IPath stateLocation = this.getStateLocation();
        File file = stateLocation.toFile();
        for (String prefix : this.erasePrefixes) {
            FileUtils.clearTempFilesAt((File)file, (String)prefix);
        }
        this.isAlive = false;
        try {
            AbstractShell.shutdownAllShells();
            for (PythonNature nature : PythonNature.getInitializedPythonNatures()) {
                try {
                    nature.saveAstManager();
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
        }
        finally {
            super.stop(context);
        }
    }

    public static boolean isAlive() {
        PydevPlugin p = plugin;
        if (p == null) {
            return false;
        }
        return p.isAlive;
    }

    public static PydevPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        if (PydevPlugin.getDefault() == null) {
            return "PyDevPluginID(null plugin)";
        }
        return PydevPlugin.getBundleInfo().getPluginID();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, PydevPlugin.getPluginID(), errorLevel, message, e);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = plugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("pysrc").addTrailingSeparator().append(targetExec);
        return PydevPlugin.getBundleInfo().getRelativePath(relative);
    }

    public static File getPySrcPath() throws CoreException {
        Path relative = new Path("pysrc");
        return PydevPlugin.getBundleInfo().getRelativePath((IPath)relative);
    }

    public static ImageCache getImageCache() {
        if (imageCache == null) {
            imageCache = PydevPlugin.getBundleInfo().getImageCache();
        }
        return imageCache;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public static Tuple<IPythonNature, String> getInfoForFile(File file) {
        IInterpreterManager pythonInterpreterManager2 = PydevPlugin.getPythonInterpreterManager(false);
        Tuple<IPythonNature, String> infoForManager = PydevPlugin.getInfoForManager(file, pythonInterpreterManager2);
        if (infoForManager != null) {
            return infoForManager;
        }
        IInterpreterManager jythonInterpreterManager2 = PydevPlugin.getJythonInterpreterManager(false);
        infoForManager = PydevPlugin.getInfoForManager(file, jythonInterpreterManager2);
        if (infoForManager != null) {
            return infoForManager;
        }
        IInterpreterManager ironpythonInterpreterManager2 = PydevPlugin.getIronpythonInterpreterManager(false);
        infoForManager = PydevPlugin.getInfoForManager(file, ironpythonInterpreterManager2);
        if (infoForManager != null) {
            return infoForManager;
        }
        List<IPythonNature> allPythonNatures = PythonNature.getAllPythonNatures();
        int size = allPythonNatures.size();
        int i = 0;
        while (i < size) {
            IPythonNature nature = allPythonNatures.get(i);
            try {
                String modName = nature.resolveModuleOnlyInProjectSources(FileUtils.getFileAbsolutePath((File)file), true);
                if (modName != null) {
                    return new Tuple((Object)nature, (Object)modName);
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
            ++i;
        }
        if (pythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(pythonInterpreterManager2), (Object)PydevPlugin.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        if (jythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(jythonInterpreterManager2), (Object)PydevPlugin.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        if (ironpythonInterpreterManager2.isConfigured()) {
            try {
                return new Tuple((Object)new SystemPythonNature(ironpythonInterpreterManager2), (Object)PydevPlugin.getModNameFromFile(file));
            }
            catch (MisconfigurationException misconfigurationException) {}
        }
        try {
            pythonInterpreterManager2.getDefaultInterpreterInfo(true);
        }
        catch (MisconfigurationException misconfigurationException) {}
        return null;
    }

    private static Tuple<IPythonNature, String> getInfoForManager(File file, IInterpreterManager pythonInterpreterManager) {
        if (pythonInterpreterManager != null && pythonInterpreterManager.isConfigured()) {
            IInterpreterInfo[] interpreterInfos;
            IInterpreterInfo[] iInterpreterInfoArray = interpreterInfos = pythonInterpreterManager.getInterpreterInfos();
            int n = interpreterInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IInterpreterInfo iInterpreterInfo = iInterpreterInfoArray[n2];
                try {
                    SystemPythonNature systemPythonNature = new SystemPythonNature(pythonInterpreterManager, iInterpreterInfo);
                    String modName = systemPythonNature.resolveModule(file);
                    if (modName != null) {
                        return new Tuple((Object)systemPythonNature, (Object)modName);
                    }
                }
                catch (Exception exception) {}
                ++n2;
            }
        }
        return null;
    }

    private static String getModNameFromFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.indexOf(46);
        if (i != -1) {
            return name.substring(0, i);
        }
        return name;
    }

    public static String getIResourceOSString(IResource f) {
        IPath rawLocation = f.getRawLocation();
        if (rawLocation == null) {
            return null;
        }
        String fullPath = rawLocation.toOSString();
        File file = new File(fullPath);
        if (file.exists()) {
            return FileUtils.getFileAbsolutePath((File)file);
        }
        IProject project = f.getProject();
        IPath location = project.getLocation();
        File projectFile = location.toFile();
        if (projectFile.exists()) {
            String projectFilePath = FileUtils.getFileAbsolutePath((File)projectFile);
            if (fullPath.startsWith(projectFilePath)) {
                return fullPath;
            }
            if (fullPath.toLowerCase().startsWith(projectFilePath.toLowerCase())) {
                String relativePart = fullPath.substring(projectFilePath.length());
                return String.valueOf(projectFilePath) + relativePart;
            }
        }
        return fullPath;
    }

    public static File getWorkspaceMetadataFile(String fileName) {
        if (location == null) {
            try {
                Bundle bundle = Platform.getBundle((String)DEFAULT_PYDEV_SCOPE);
                IPath path = Platform.getStateLocation((Bundle)bundle);
                location = path.toFile();
            }
            catch (Exception e) {
                throw new RuntimeException("If running in tests, call: setTestPlatformStateLocation", e);
            }
        }
        return new File(location, fileName);
    }

    public static ColorCache getColorCache() {
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin.colorCache == null) {
            plugin.colorCache = new ColorCache(PydevPrefs.getChainedPrefStore()){};
        }
        return plugin.colorCache;
    }
}

