/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.decorator;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.uiutils.UIUtils;
import org.python.pydev.navigator.decorator.IProblemChangedListener;

public class ProblemMarkerManager
implements IResourceChangeListener {
    private ListenerList fListeners = new ListenerList();
    private Set<IResource> fResourcesWithMarkerChanges = new HashSet<IResource>();
    private Set<IResource> fResourcesWithAnnotationChanges = new HashSet<IResource>();
    private UIJob fNotifierJob;
    private static ProblemMarkerManager fProblemMarkerManagerSingleton;

    protected ProblemMarkerManager() {
    }

    public static synchronized ProblemMarkerManager getSingleton() {
        if (fProblemMarkerManagerSingleton == null) {
            fProblemMarkerManagerSingleton = new ProblemMarkerManager();
        }
        return fProblemMarkerManagerSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceChanged(IResourceChangeEvent event) {
        HashSet<IResource> changedElements = new HashSet<IResource>();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        if (!changedElements.isEmpty()) {
            boolean hasChanges = false;
            ProblemMarkerManager problemMarkerManager = this;
            synchronized (problemMarkerManager) {
                if (this.fResourcesWithMarkerChanges.isEmpty()) {
                    this.fResourcesWithMarkerChanges = changedElements;
                    hasChanges = true;
                } else {
                    hasChanges = this.fResourcesWithMarkerChanges.addAll(changedElements);
                }
            }
            if (hasChanges) {
                this.fireChanges();
            }
        }
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    private void fireChanges() {
        Display display = UIUtils.getStandardDisplay();
        if (display != null && !display.isDisposed()) {
            this.postAsyncUpdate(display);
        }
    }

    private void postAsyncUpdate(Display display) {
        if (this.fNotifierJob == null) {
            this.fNotifierJob = new UIJob(display, "Update problem marker decorations"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IResource[] markerResources = null;
                    IResource[] annotationResources = null;
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        if (!ProblemMarkerManager.this.fResourcesWithMarkerChanges.isEmpty()) {
                            markerResources = ProblemMarkerManager.this.fResourcesWithMarkerChanges.toArray(new IResource[ProblemMarkerManager.this.fResourcesWithMarkerChanges.size()]);
                            ProblemMarkerManager.this.fResourcesWithMarkerChanges.clear();
                        }
                        if (!ProblemMarkerManager.this.fResourcesWithAnnotationChanges.isEmpty()) {
                            annotationResources = ProblemMarkerManager.this.fResourcesWithAnnotationChanges.toArray(new IResource[ProblemMarkerManager.this.fResourcesWithAnnotationChanges.size()]);
                            ProblemMarkerManager.this.fResourcesWithAnnotationChanges.clear();
                        }
                    }
                    Object[] listeners = ProblemMarkerManager.this.fListeners.getListeners();
                    int i = 0;
                    while (i < listeners.length) {
                        IProblemChangedListener curr = (IProblemChangedListener)listeners[i];
                        if (markerResources != null) {
                            curr.problemsChanged(markerResources, true);
                        }
                        if (annotationResources != null) {
                            curr.problemsChanged(annotationResources, false);
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fNotifierJob.setSystem(true);
            this.fNotifierJob.setPriority(50);
        }
        this.fNotifierJob.schedule(10L);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet<IResource> fChangedElements;

        public ProjectErrorVisitor(HashSet<IResource> changedElements) {
            this.fChangedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.checkInvalidate(delta, res);
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IResource resource) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (resource.getType() != 8 && this.fChangedElements.add(resource)) {
                    resource = resource.getParent();
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas = delta.getMarkerDeltas();
                int i = 0;
                while (i < markerDeltas.length) {
                    IMarkerDelta iMarkerDelta = markerDeltas[i];
                    if (iMarkerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int kind = iMarkerDelta.getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = iMarkerDelta.getAttribute("severity", -1);
                        int newSeverity = iMarkerDelta.getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
    }
}

