/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.editor.correctionassist.heuristics.PercentToBraceConverter;
import org.python.pydev.shared_ui.ImageCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssistPercentToFormat
extends AbstractTemplateCodeCompletion
implements IAssistProps {
    private static final boolean DEBUG = false;

    @Override
    public List<ICompletionProposal> getProps(PySelection ps, ImageCache imageCache, File f, IPythonNature nature, PyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposal> l = new ArrayList<ICompletionProposal>();
        String curSelection = ps.getSelectedText();
        if (curSelection == null) {
            return l;
        }
        curSelection = new String(curSelection);
        boolean endsWithLineDelim = false;
        int unchangedLength = curSelection.length();
        if (curSelection.substring(unchangedLength - 1, unchangedLength).matches("\\r|\\n") || curSelection.substring(unchangedLength - 2, unchangedLength).matches("\\r\\n")) {
            endsWithLineDelim = true;
        }
        PercentToBraceConverter ptbc = new PercentToBraceConverter(curSelection);
        String replacementString = ptbc.convert();
        if (endsWithLineDelim) {
            replacementString = String.valueOf(replacementString) + ps.getEndLineDelim();
        }
        int lenConverted = ptbc.getLength();
        int replacementOffset = offset;
        int replacementLength = unchangedLength;
        int cursorPos = replacementOffset + lenConverted;
        IRegion region = ps.getRegion();
        TemplateContext context = this.createContext((ITextViewer)edit.getPySourceViewer(), region, ps.getDoc());
        Template t = new Template("Convert", "% to .format()", "", replacementString, false);
        l.add((ICompletionProposal)new TemplateProposal(t, context, region, imageCache.get("icons/template.gif"), 5));
        return l;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, PyEdit edit, int offset) {
        return PercentToBraceConverter.isValidPercentFormatString(ps.getSelectedText(), true);
    }

    @Override
    public List<Object> getCodeCompletionProposals(ITextViewer viewer, CompletionRequest request) throws CoreException, BadLocationException {
        throw new RuntimeException("Not implemented: completions should be gotten from the IAssistProps interface.");
    }
}

