/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IToken;
import org.python.pydev.core.docutils.ImportsSelection;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCalltipsContextInformationFromIToken;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.PyCompletionProposal;
import org.python.pydev.editor.codecompletion.PyLinkedModeCompletionProposal;
import org.python.pydev.editor.codecompletion.revisited.AbstractToken;
import org.python.pydev.shared_core.string.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPyCodeCompletion
implements IPyCodeCompletion {
    private static int STATE_INITIAL = 0;
    private static int STATE_FOUND_CHAR = 1;
    private static int STATE_FOUND_WHITESPACE = 2;
    private static int STATE_FOUND_WHITESPACE_AFTER_CHAR = 3;

    @Override
    public ICodeCompletionASTManager.ImportInfo getImportsTipperStr(CompletionRequest request) {
        IDocument doc = request.doc;
        int documentOffset = request.documentOffset;
        return ImportsSelection.getImportsTipperStr((IDocument)doc, (int)documentOffset);
    }

    protected void changeItokenToCompletionPropostal(ITextViewer viewer, CompletionRequest request, List<ICompletionProposal> convertedProposals, List<Object> iTokenList, boolean importsTip, ICompletionState state) {
        FastStringBuffer result = new FastStringBuffer();
        FastStringBuffer temp = new FastStringBuffer();
        int replacementOffset = request.documentOffset - request.qlen;
        int forcedContextInformationOffset = -1;
        int notInCalltip = 1;
        int onApplyAction = 1;
        if (request.isInCalltip) {
            notInCalltip = 0;
            if (request.alreadyHasParams) {
                onApplyAction = 2;
                forcedContextInformationOffset = request.calltipOffset;
            } else {
                onApplyAction = 3;
            }
        }
        for (Object obj : iTokenList) {
            String name;
            Object[] element;
            if (obj instanceof IToken) {
                element = (Object[])obj;
                name = element.getRepresentation();
                int l = name.length();
                String args = "";
                if (!importsTip) {
                    boolean getIt = true;
                    if (AbstractToken.isClassDef((IToken)element) && !request.isInCalltip) {
                        getIt = false;
                    }
                    if (getIt && (args = AbstractPyCodeCompletion.getArgs((IToken)element, state)).length() > 0) {
                        ++l;
                    }
                }
                if (name.equals(request.fullQualifier) && args.trim().length() == 0) continue;
                int type = element.getType();
                int priority = 10;
                if (type == 5 || type == 9 || type == 10) {
                    priority = -1;
                }
                PyCalltipsContextInformationFromIToken pyContextInformation = null;
                if (args.length() > 2) {
                    int contextInformationOffset = forcedContextInformationOffset < 0 ? replacementOffset + name.length() + notInCalltip : forcedContextInformationOffset;
                    pyContextInformation = new PyCalltipsContextInformationFromIToken((IToken)element, args, contextInformationOffset);
                }
                String replacementString = String.valueOf(name) + AbstractPyCodeCompletion.makeArgsForDocumentReplacement(args, result, temp);
                String displayString = String.valueOf(name) + args;
                PyLinkedModeCompletionProposal proposal = new PyLinkedModeCompletionProposal(replacementString, replacementOffset, request.qlen, l, (IToken)element, displayString, pyContextInformation, priority, onApplyAction, args);
                convertedProposals.add(proposal);
                continue;
            }
            if (obj instanceof Object[]) {
                element = (Object[])obj;
                name = (String)element[0];
                String docStr = (String)element[1];
                int type = -1;
                if (element.length > 2) {
                    type = (Integer)element[2];
                }
                int priority = 10;
                if (type == 5) {
                    priority = -1;
                }
                PyCompletionProposal proposal = new PyCompletionProposal(name, request.documentOffset - request.qlen, request.qlen, name.length(), PyCodeCompletionImages.getImageForType(type), null, null, docStr, priority);
                convertedProposals.add(proposal);
                continue;
            }
            if (!(obj instanceof ICompletionProposal)) continue;
            convertedProposals.add((ICompletionProposal)obj);
        }
    }

    public static String makeArgsForDocumentReplacement(String args, FastStringBuffer result, FastStringBuffer temp) {
        result = result.clear();
        temp = temp.clear();
        int state = STATE_INITIAL;
        int starsToAdd = 0;
        char[] cArray = args.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '*') {
                ++starsToAdd;
            } else if (c == ',' || c == '(' || c == ')') {
                AbstractPyCodeCompletion.appendTempToResult(result, temp, starsToAdd);
                result.append(c);
                temp.clear();
                starsToAdd = 0;
                state = STATE_INITIAL;
            } else if (Character.isWhitespace(c)) {
                if (state == STATE_FOUND_CHAR) {
                    state = STATE_FOUND_WHITESPACE_AFTER_CHAR;
                } else if (state != STATE_FOUND_WHITESPACE_AFTER_CHAR) {
                    state = STATE_FOUND_WHITESPACE;
                }
            } else {
                if (state == STATE_FOUND_WHITESPACE_AFTER_CHAR) {
                    temp.clear();
                }
                state = STATE_FOUND_CHAR;
                temp.append(c);
            }
            ++n2;
        }
        AbstractPyCodeCompletion.appendTempToResult(result, temp, starsToAdd);
        return result.toString();
    }

    private static void appendTempToResult(FastStringBuffer result, FastStringBuffer temp, int starsToAdd) {
        if (result.toString().trim().endsWith(",")) {
            result.append(' ');
        }
        result.appendN('*', starsToAdd);
        result.append(temp);
    }

    protected static String getArgs(IToken element, ICompletionState state) {
        int lookingFor = state.getLookingFor();
        return AbstractPyCodeCompletion.getArgs(element, lookingFor);
    }

    private static String getArgs(IToken element, int lookingFor) {
        return AbstractPyCodeCompletion.getArgs(element.getArgs(), element.getType(), lookingFor);
    }

    public static String getArgs(String argsReceived, int type, int lookingFor) {
        String args = "";
        boolean lookingForInstance = lookingFor == 0 || lookingFor == 1 || lookingFor == 4;
        String trimmed = argsReceived.trim();
        if (trimmed.length() > 0) {
            FastStringBuffer buffer = new FastStringBuffer("(", 128);
            char c = trimmed.charAt(0);
            if (c == '(') {
                trimmed = trimmed.substring(1);
            }
            if (trimmed.length() > 0 && (c = trimmed.charAt(trimmed.length() - 1)) == ')') {
                trimmed = trimmed.substring(0, trimmed.length() - 1);
            }
            trimmed = trimmed.trim();
            String temp = lookingForInstance && trimmed.startsWith("self") ? trimmed.substring(4) : (trimmed.startsWith("cls") ? trimmed.substring(3) : trimmed);
            if ((temp = temp.trim()).length() > 0) {
                if (!Character.isJavaIdentifierPart(temp.charAt(0))) {
                    trimmed = temp;
                }
            } else {
                trimmed = temp;
            }
            if ((trimmed = trimmed.trim()).startsWith(",")) {
                trimmed = trimmed.substring(1);
            }
            trimmed = trimmed.trim();
            buffer.append(trimmed);
            buffer.append(")");
            args = buffer.toString();
        } else if (type == 2) {
            args = "()";
        }
        return args;
    }
}

