/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.python.pydev.core.IIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.editor.actions.PyAddBlockComment;
import org.python.pydev.editor.actions.PyAddSingleBlockComment;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyRemoveBlockComment
extends PyAddBlockComment {
    @Override
    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            PySelection ps = new PySelection(this.getTextEditor());
            Tuple<Integer, Integer> repRegion = this.perform(ps);
            if (repRegion == null) {
                return;
            }
            pyEdit.selectAndReveal((Integer)repRegion.o1, (Integer)repRegion.o2);
        }
        catch (Exception e) {
            PyRemoveBlockComment.beep(e);
        }
    }

    @Override
    public Tuple<Integer, Integer> perform(PySelection ps) {
        int startLineIndex = this.getStartIndex(ps);
        int endLineIndex = this.getEndIndex(ps);
        if (startLineIndex == -1 || endLineIndex == -1) {
            if (startLineIndex == -1 && endLineIndex == -1) {
                return null;
            }
            if (startLineIndex == -1) {
                startLineIndex = endLineIndex;
            } else {
                endLineIndex = startLineIndex;
            }
        }
        return this.performUncommentBlock((TextSelectionUtils)ps, startLineIndex, endLineIndex);
    }

    public Tuple<Integer, Integer> performUncommentBlock(TextSelectionUtils ps, int startLineIndex, int endLineIndex) {
        FastStringBuffer strbuf = new FastStringBuffer();
        try {
            String sub;
            int i = startLineIndex;
            while (i <= endLineIndex) {
                boolean addDelim = true;
                String spacesBefore = "";
                String line = ps.getLine(i);
                int lineLen = line.length();
                int j = 0;
                while (j < lineLen) {
                    char c = line.charAt(j);
                    if (c == '#') {
                        if (j > 0) {
                            spacesBefore = line.substring(0, j);
                        }
                        line = line.substring(j);
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                    ++j;
                }
                if (line.startsWith("#")) {
                    line = line.substring(1);
                }
                AbstractBlockCommentAction[] acts = new AbstractBlockCommentAction[]{new PyAddSingleBlockComment(), new PyAddBlockComment()};
                HashSet<Character> chars = new HashSet<Character>();
                int j2 = 0;
                while (j2 < acts.length) {
                    AbstractBlockCommentAction action = acts[j2];
                    chars.add((Character)action.getColsAndChar().o2);
                    ++j2;
                }
                if (line.length() > 0) {
                    boolean removedChar = false;
                    char lastChar = '\u0000';
                    int j3 = 0;
                    while (j3 < line.length()) {
                        lastChar = line.charAt(j3);
                        if (!chars.contains(Character.valueOf(lastChar))) break;
                        removedChar = true;
                        line = line.substring(1);
                        --j3;
                        ++j3;
                    }
                    if (line.length() == 0 && removedChar) {
                        addDelim = false;
                    }
                    if (removedChar && lastChar == ' ') {
                        line = line.substring(1);
                    }
                }
                if (addDelim) {
                    strbuf.append(spacesBefore);
                    strbuf.append(line);
                    String lineDelimiter = ps.getDoc().getLineDelimiter(i);
                    if (lineDelimiter != null) {
                        strbuf.append(lineDelimiter);
                    }
                }
                ++i;
            }
            String string = strbuf.toString();
            List lines = StringUtils.splitInLines((String)string);
            Tuple posAndLine = new Tuple((Object)-1, (Object)"");
            for (String line : lines) {
                int firstCharPosition;
                if (line.trim().length() <= 0 || (firstCharPosition = PySelection.getFirstCharPosition((String)line)) >= (Integer)posAndLine.o1 && (Integer)posAndLine.o1 >= 0) continue;
                posAndLine.o1 = firstCharPosition;
                posAndLine.o2 = line;
            }
            if ((Integer)posAndLine.o1 > 0 && (sub = ((String)posAndLine.o2).substring(0, (Integer)posAndLine.o1)).endsWith(" ")) {
                boolean allEqual = true;
                for (String line : lines) {
                    if (line.startsWith(sub)) continue;
                    if (line.trim().length() <= 0) break;
                    allEqual = false;
                    break;
                }
                if (allEqual) {
                    if (sub.startsWith("\t")) {
                        int j = sub.length() - 1;
                        while (j >= 0) {
                            char c = sub.charAt(j);
                            if (c != ' ') {
                                ++j;
                                break;
                            }
                            --j;
                        }
                        String newSub = sub.substring(0, j);
                        strbuf.clear();
                        for (String line : lines) {
                            strbuf.append(newSub);
                            strbuf.append(line.substring(sub.length()));
                        }
                    } else {
                        IIndentPrefs indentPrefs;
                        if (this.targetEditor instanceof PyEdit) {
                            PyEdit pyEdit = (PyEdit)this.targetEditor;
                            indentPrefs = pyEdit.getIndentPrefs();
                        } else {
                            indentPrefs = DefaultIndentPrefs.get();
                        }
                        String indentationString = indentPrefs.getIndentationString();
                        int subLen = sub.length();
                        int indentLen = indentationString.length();
                        int mod = subLen % indentLen;
                        if (mod != 0) {
                            String substring = sub.substring(subLen - mod, subLen);
                            boolean onlyWhitespaces = true;
                            int k = 0;
                            while (k < substring.length()) {
                                if (substring.charAt(k) != ' ') {
                                    onlyWhitespaces = false;
                                    break;
                                }
                                ++k;
                            }
                            if (onlyWhitespaces) {
                                String newSub = sub.substring(0, subLen - mod);
                                strbuf.clear();
                                for (String line : lines) {
                                    if (line.trim().length() == 0) {
                                        strbuf.append(line);
                                        continue;
                                    }
                                    strbuf.append(newSub);
                                    strbuf.append(line.substring(sub.length()));
                                }
                            }
                        }
                    }
                }
            }
            int startLineOffset = ps.getLineOffset(startLineIndex);
            int endLineOffset = ps.getEndLineOffset(endLineIndex);
            String endLineDelimiter = ps.getDoc().getLineDelimiter(endLineIndex);
            int endLen = 0;
            if (endLineDelimiter != null) {
                endLen = endLineDelimiter.length();
                endLineOffset += endLen;
            }
            String str = strbuf.toString();
            ps.getDoc().replace(startLineOffset, endLineOffset - startLineOffset, str);
            int len = str.length();
            if (len > endLen) {
                len -= endLen;
            }
            return new Tuple((Object)startLineOffset, (Object)len);
        }
        catch (Exception e) {
            PyRemoveBlockComment.beep(e);
            return null;
        }
    }

    private int getEndIndex(PySelection ps) {
        String line;
        int endLineIndex = -1;
        int i = ps.getEndLineIndex();
        while (PySelection.isCommentLine((String)(line = ps.getLine(i)))) {
            endLineIndex = i++;
        }
        return endLineIndex;
    }

    private int getStartIndex(PySelection ps) {
        String line;
        int startLineIndex = -1;
        int i = ps.getStartLineIndex();
        while (PySelection.isCommentLine((String)(line = ps.getLine(i)))) {
            startLineIndex = i--;
        }
        return startLineIndex;
    }
}

