/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.changed_lines;

import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.changed_lines.LineComparator;
import org.python.pydev.core.log.Log;

public class ChangedLinesComputer {
    public static int[] calculateChangedLines(ITextFileBuffer buffer, IProgressMonitor monitor) throws CoreException {
        int[] result = null;
        try {
            monitor.beginTask("Calculating changed lines", 20);
            IFileStore fileStore = buffer.getFileStore();
            ITextFileBufferManager fileBufferManager = FileBuffers.createTextFileBufferManager();
            fileBufferManager.connectFileStore(fileStore, ChangedLinesComputer.getSubProgressMonitor(monitor, 15));
            try {
                IDocument currentDocument = buffer.getDocument();
                IDocument oldDocument = ((ITextFileBuffer)fileBufferManager.getFileStoreFileBuffer(fileStore)).getDocument();
                result = ChangedLinesComputer.getChangedLines(oldDocument, currentDocument);
            }
            finally {
                fileBufferManager.disconnectFileStore(fileStore, ChangedLinesComputer.getSubProgressMonitor(monitor, 5));
                monitor.done();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            return null;
        }
        return result;
    }

    private static int[] getChangedLines(IDocument oldDocument, IDocument currentDocument) throws BadLocationException {
        LineComparator leftSide = new LineComparator(oldDocument);
        LineComparator rightSide = new LineComparator(currentDocument);
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)leftSide, (IRangeComparator)rightSide);
        ArrayList<Integer> regions = new ArrayList<Integer>();
        int i = 0;
        while (i < differences.length) {
            RangeDifference curr = differences[i];
            if (curr.kind() == 2 && curr.rightLength() > 0) {
                int endLine;
                int startLine = curr.rightStart();
                if (startLine == (endLine = curr.rightEnd() - 1)) {
                    regions.add(startLine);
                } else {
                    int iLine = startLine;
                    while (iLine <= endLine) {
                        regions.add(iLine);
                        ++iLine;
                    }
                }
            }
            ++i;
        }
        int size = regions.size();
        int[] ret = new int[size];
        int i2 = 0;
        while (i2 < size) {
            ret[i2] = (Integer)regions.get(i2);
            ++i2;
        }
        return ret;
    }

    private static IProgressMonitor getSubProgressMonitor(IProgressMonitor monitor, int ticks) {
        if (monitor != null) {
            return new SubProgressMonitor(monitor, ticks, 4);
        }
        return new NullProgressMonitor();
    }
}

