/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.facets.WlsGarFacet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetProjectCreationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.plugin.WTPCommonPlugin;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;

public class GarProjectCreationDataModelProvider
extends J2EEFacetProjectCreationDataModelProvider {
    public void init() {
        super.init();
        ArrayList<IProjectFacet> requiredFacets = new ArrayList<IProjectFacet>();
        requiredFacets.add(JavaFacet.FACET);
        requiredFacets.add(WlsGarFacet.FACET);
        this.setProperty("FacetProjectCreationDataModelProvider.REQUIRED_FACETS_COLLECTION", requiredFacets);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel javaFacet = map.getFacetDataModel("java");
        javaFacet.setProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", (Object)J2EEPlugin.getDefault().getJ2EEPreferences().getDefaultJavaSrcFolder());
        javaFacet.setProperty("IJavaFacetInstallDataModelProperties.DEFAULT_OUTPUT_FOLDER_NAME", (Object)J2EEPlugin.getDefault().getJ2EEPreferences().getDefaultOutputFolderName());
        IDataModel garFacet = map.getFacetDataModel("oracle.coherence.gar");
        garFacet.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if ("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME".equals(event.getPropertyName())) {
                    if (GarProjectCreationDataModelProvider.this.isPropertySet("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME")) {
                        GarProjectCreationDataModelProvider.this.setProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", event.getProperty());
                    } else {
                        GarProjectCreationDataModelProvider.this.model.notifyPropertyChange("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME", 2);
                    }
                } else if ("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR".equals(event.getPropertyName())) {
                    GarProjectCreationDataModelProvider.this.setProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR", event.getProperty());
                }
            }
        });
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if ("IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(propertyName)) {
            IFacetedProjectWorkingCopy fpjwc = (IFacetedProjectWorkingCopy)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACETED_PROJECT_WORKING_COPY");
            Set fixedFacets = fpjwc.getFixedProjectFacets();
            ArrayList<IRuntime> list = new ArrayList<IRuntime>();
            for (IRuntime runtime : RuntimeManager.getRuntimes()) {
                IRuntimeComponent rtComp = WlsRuntimeUtil.getWlsRuntimeComponent((IRuntime)runtime);
                if (rtComp == null || !rtComp.getRuntimeComponentVersion().getVersionString().equals("12.1.2")) continue;
                boolean supportsFacets = true;
                for (IProjectFacet facet : fixedFacets) {
                    if (runtime.supports(facet)) continue;
                    supportsFacets = false;
                    break;
                }
                if (!supportsFacets) continue;
                list.add(runtime);
            }
            DataModelPropertyDescriptor[] descriptors = new DataModelPropertyDescriptor[list.size() + 1];
            Iterator iterator = list.iterator();
            int i = 0;
            while (i < descriptors.length - 1) {
                IRuntime runtime = (IRuntime)iterator.next();
                descriptors[i] = new DataModelPropertyDescriptor((Object)runtime, runtime.getLocalizedName());
                ++i;
            }
            if (descriptors.length > 2) {
                Arrays.sort(descriptors, 0, descriptors.length - 1, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        DataModelPropertyDescriptor d1 = (DataModelPropertyDescriptor)arg0;
                        DataModelPropertyDescriptor d2 = (DataModelPropertyDescriptor)arg1;
                        return d1.getPropertyDescription().compareTo(d2.getPropertyDescription());
                    }
                });
            }
            descriptors[descriptors.length - 1] = new DataModelPropertyDescriptor(null, WTPCommonPlugin.getResourceString((String)"44", null));
            return descriptors;
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        if (propertyName.equals("IJ2EEFacetProjectCreationDataModelProperties.MODULE_URI")) {
            IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
            IDataModel garFacet = map.getFacetDataModel("oracle.coherence.gar");
            garFacet.setProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI", propertyValue);
        }
        return super.propertySet(propertyName, propertyValue);
    }

    public IStatus validate(String propertyName) {
        if (("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR".equals(propertyName) || "IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME".equals(propertyName)) && this.model.getBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR")) {
            String earProjName = this.model.getStringProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
            IProject earProj = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjName);
            IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProj, (boolean)true);
            if (earComp != null) {
                IVirtualReference[] refs;
                IVirtualReference[] iVirtualReferenceArray = refs = earComp.getReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    IVirtualComponent comp = ref.getReferencedComponent();
                    IProject p = comp.getProject();
                    try {
                        IFacetedProject fp = ProjectFacetsManager.create((IProject)p);
                        for (IProjectFacetVersion fv : fp.getProjectFacets()) {
                            if (!fv.getProjectFacet().getId().equals("oracle.coherence.gar")) continue;
                            return new Status(4, "oracle.eclipse.tools.coherence", "Found GAR project in select EAR. Only one GAR project can be added to EAR.");
                        }
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
        }
        return super.validate(propertyName);
    }
}

