/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import oracle.eclipse.tools.weblogic.descriptors.IModuleDefinition;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.descriptors.ModuleType;
import oracle.eclipse.tools.weblogic.descriptors.WebLogicDescriptorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.project.facet.J2EEFacetInstallDelegate;
import org.eclipse.jst.jee.JEEPlugin;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.VirtualReferenceUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public class GarFacetPostInstallDelegate
extends J2EEFacetInstallDelegate
implements IDelegate {
    private static boolean runOnce = false;

    public void execute(IProject project, IProjectFacetVersion fv, Object cfg, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            try {
                this.addGarToFacetExtMapping();
                IDataModel model = (IDataModel)cfg;
                this.addModuleToEar(project, model);
            }
            catch (Exception e) {
                J2EEPlugin.logError((Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void addModuleToEar(final IProject project, final IDataModel model) {
        if (model.getBooleanProperty("IJ2EEFacetInstallDataModelProperties.ADD_TO_EAR")) {
            Job job = new Job("Adding to EAR"){

                protected IStatus run(IProgressMonitor monitor) {
                    String earProjectName = model.getStringProperty("IJ2EEFacetInstallDataModelProperties.EAR_PROJECT_NAME");
                    if (earProjectName != null && earProjectName != "") {
                        IWebLogicAppDescriptor wlsAppXml;
                        boolean createWebModule;
                        IProject earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName);
                        String moduleURI = model.getStringProperty("IJ2EEModuleFacetInstallDataModelProperties.MODULE_URI");
                        IRuntime runtime = (IRuntime)model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
                        GarFacetPostInstallDelegate.this.installAndAddModuletoEAR(null, earProjectName, runtime, project, moduleURI, monitor);
                        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject, (boolean)true);
                        IVirtualReference[] refs = earComp.getReferences();
                        boolean bl = createWebModule = refs.length == 1;
                        if (createWebModule) {
                            String webProjectName;
                            IProject webProj;
                            IVirtualFolder earroot = earComp.getRootFolder();
                            IFile appXmlFile = earroot.getUnderlyingFolder().getFile((IPath)new Path("META-INF/application.xml"));
                            if (!appXmlFile.exists()) {
                                try {
                                    if (!appXmlFile.getParent().exists() && appXmlFile.getParent().getType() == 2) {
                                        ((IFolder)appXmlFile.getParent()).create(true, true, monitor);
                                    }
                                    String appXmlContents = null;
                                    appXmlContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<application id=\"Application_ID\" version=\"6\" xmlns=\"http://java.sun.com/xml/ns/javaee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_6.xsd\">\n <display-name>" + earProject.getName() + "</display-name> \n </application> ";
                                    appXmlFile.create((InputStream)new ByteArrayInputStream(appXmlContents.getBytes(StandardCharsets.UTF_8)), true, monitor);
                                }
                                catch (Exception e) {
                                    JEEPlugin.logError((Throwable)e);
                                }
                            }
                            if ((webProj = GarFacetPostInstallDelegate.this.createWebProject(webProjectName = String.valueOf(project.getName()) + "Web", runtime, monitor)) != null) {
                                IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProj);
                                String webModuleURI = webProjectName;
                                GarFacetPostInstallDelegate.this.addToEar(earComp, webComp, webModuleURI);
                            }
                        }
                        if ((wlsAppXml = WebLogicDescriptorFactory.getAppDescriptor((IProject)earProject)) != null) {
                            IModuleDefinition m = (IModuleDefinition)wlsAppXml.getModules().insert();
                            m.setName(project.getName());
                            m.setType(ModuleType.GAR);
                            m.setGarPath(moduleURI);
                            try {
                                wlsAppXml.resource().save();
                            }
                            catch (ResourceStoreException e) {
                                e.printStackTrace();
                            }
                            wlsAppXml.dispose();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule(500L);
        }
    }

    public static IProject getProject(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    private IProject createWebProject(String webProjectName, IRuntime runtime, IProgressMonitor monitor) {
        IProject project = GarFacetPostInstallDelegate.getProject(webProjectName);
        if (project.exists()) {
            return project;
        }
        IFacetedProjectWorkingCopy fpjwc = null;
        try {
            List runtimeComponents;
            fpjwc = FacetedProjectFramework.createNewProject();
            fpjwc.setProjectName(webProjectName);
            if (runtime != null) {
                fpjwc.setTargetedRuntimes(Collections.singleton(runtime));
            }
            HashSet<IProjectFacet> fixedFacets = new HashSet<IProjectFacet>();
            fixedFacets.add(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            IProjectFacet JAVA_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.java");
            fixedFacets.add(JAVA_FACET);
            fpjwc.setFixedProjectFacets(fixedFacets);
            fpjwc.setSelectedPreset("default.configuration");
            IProjectFacet wlsWebFacet = ProjectFacetsManager.getProjectFacet((String)"wls.web");
            String wlsWebFacetVersionString = "12.1.2";
            if (runtime != null && (runtimeComponents = runtime.getRuntimeComponents()) != null) {
                for (IRuntimeComponent runtimeComponent : runtimeComponents) {
                    IRuntimeComponentVersion runtimeComponentVersion = runtimeComponent.getRuntimeComponentVersion();
                    if (runtimeComponentVersion == null || !runtimeComponentVersion.getRuntimeComponentType().getId().equals("com.bea.weblogic")) continue;
                    wlsWebFacetVersionString = runtimeComponentVersion.getVersionString();
                }
            }
            IProjectFacetVersion wlsWebFacetVersion = wlsWebFacet.getVersion(wlsWebFacetVersionString);
            fpjwc.addProjectFacet(wlsWebFacetVersion);
            try {
                fpjwc.commitChanges(null);
                IProject iProject = fpjwc.getProject();
                return iProject;
            }
            catch (CoreException e) {
                J2EEPlugin.logError((CoreException)e);
            }
        }
        finally {
            if (fpjwc != null) {
                fpjwc.dispose();
            }
        }
        return null;
    }

    private void addGarToFacetExtMapping() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (!runOnce) {
            runOnce = true;
            Field mappingField = VirtualReferenceUtilities.class.getDeclaredField("mapping");
            mappingField.setAccessible(true);
            VirtualReferenceUtilities refUtil = VirtualReferenceUtilities.INSTANCE;
            HashMap facetExtMapping = (HashMap)mappingField.get(refUtil);
            if (facetExtMapping.get("oracle.coherence.gar") == null) {
                facetExtMapping.put("oracle.coherence.gar", ".gar");
            }
        }
    }
}

