/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.facets.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.eclipse.tools.common.util.fileio.ZipUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.common.project.facet.core.libprov.user.KeyClassesValidator;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class CoherenceVersionValidator
extends KeyClassesValidator {
    private static final String COHERENCE_CLASS = "com.tangosol.net.CacheFactory";
    private static final String IMPLEMENTATION_VERSION_KEY = "Implementation-Version";
    private static final String IMPLEMENTATION_TITLE_KEY = "Implementation-Title";
    private static final String COHERENCE_3_5 = "Coherence Core API";
    private static final String COHERENCE_3_6 = "Coherence";

    public IStatus validate(UserLibraryProviderInstallOperationConfig config) {
        IStatus ret = super.validate(config);
        if (ret.getSeverity() != 0) {
            return ret;
        }
        String coherenceVersion = null;
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (IClasspathEntry cpe : config.resolve()) {
                IWorkspaceRoot root;
                IResource resource;
                File file;
                if (cpe.getEntryKind() != 1 || !(file = (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(cpe.getPath())) == null ? cpe.getPath().toFile() : resource.getLocation().toFile()).exists()) continue;
                urls.add(file.toURI().toURL());
                if (!file.isFile()) continue;
                try {
                    String version = this.getCoherenceVersion(file);
                    if (coherenceVersion != null || version == null) continue;
                    coherenceVersion = version;
                }
                catch (IOException iOException) {}
            }
        }
        catch (MalformedURLException malformedURLException) {}
        URLClassLoader loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
        try {
            loader.loadClass(COHERENCE_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new Status(4, "oracle.eclipse.tools.coherence", Resources.bind((String)Resources.errorRequiredClass, (Object)COHERENCE_CLASS));
        }
        if (coherenceVersion != null) {
            IProjectFacetVersion requiredVersion = config.getProjectFacetVersion();
            String facetVersion = requiredVersion.getVersionString();
            String string = facetVersion = facetVersion.equals("3.7") ? "3.7.0" : facetVersion;
            if (coherenceVersion.indexOf(facetVersion) < 0) {
                String message = Resources.bind((String)Resources.versionMismatch, (Object)coherenceVersion, (Object)facetVersion);
                return new Status(4, "oracle.eclipse.tools.coherence", message);
            }
        } else {
            return new Status(4, "oracle.eclipse.tools.coherence", Resources.errorValidateCoherenceVersion);
        }
        return Status.OK_STATUS;
    }

    /*
     * Loose catch block
     */
    private String getCoherenceVersion(File location) throws IOException {
        ZipFile zip;
        block15: {
            zip = ZipUtil.open((File)location);
            ZipEntry zipentry = ZipUtil.getZipEntry((ZipFile)zip, (String)"META-INF/MANIFEST.MF");
            if (zipentry == null) break block15;
            InputStream in = zip.getInputStream(zipentry);
            String string = this.getCoherenceVersion(in);
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                zip.close();
            }
            catch (IOException iOException) {}
            return string;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                }
            }
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {}
        return null;
    }

    private String getCoherenceVersion(InputStream stream) throws IOException {
        Scanner scanner = new Scanner(stream);
        String coherenceVersion = null;
        boolean isCoherence = false;
        try {
            while (scanner.hasNextLine()) {
                String value;
                String line = scanner.nextLine();
                StringTokenizer tokenizer = new StringTokenizer(line, ":", false);
                String key = null;
                if (tokenizer.hasMoreTokens()) {
                    key = tokenizer.nextToken();
                }
                if (IMPLEMENTATION_VERSION_KEY.equals(key)) {
                    if (!tokenizer.hasMoreTokens()) continue;
                    value = tokenizer.nextToken().trim();
                    int fromIndex = value.indexOf("v");
                    int toIndex = value.indexOf("b");
                    if (fromIndex >= 0 && toIndex >= 0 && fromIndex < toIndex) {
                        coherenceVersion = value.substring(fromIndex + 1, toIndex);
                        continue;
                    }
                    coherenceVersion = value;
                    continue;
                }
                if (!IMPLEMENTATION_TITLE_KEY.equals(key) || !tokenizer.hasMoreTokens() || !COHERENCE_3_5.equalsIgnoreCase(value = tokenizer.nextToken().trim()) && !COHERENCE_3_6.equalsIgnoreCase(value)) continue;
                isCoherence = true;
            }
        }
        finally {
            scanner.close();
        }
        return isCoherence ? coherenceVersion : null;
    }

    private static final class Resources
    extends NLS {
        public static String errorRequiredClass;
        public static String versionMismatch;
        public static String errorValidateCoherenceVersion;

        static {
            Resources.initializeMessages((String)CoherenceVersionValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

