/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Counter;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.services.ValidationService;

public class UniqueValueValidationService
extends ValidationService {
    private ModelPath path;
    private Listener listener;

    protected void initValidationService() {
        final Element element = (Element)this.context(Element.class);
        this.path = new ModelPath("#/" + ((PropertyDef)this.context(PropertyDef.class)).name());
        this.listener = new FilteredListener<PropertyContentEvent>(){

            protected void handleTypedEvent(PropertyContentEvent event) {
                if (event.property().element() != element && !element.disposed()) {
                    UniqueValueValidationService.this.refresh();
                }
            }
        };
        element.attach(this.listener, this.path);
    }

    public Status compute() {
        Counter.increment(UniqueValueValidationService.class);
        Value value = (Value)this.context(Value.class);
        if (!this.isUniqueValue(value)) {
            ValueProperty property = value.definition();
            String label = property.getLabel(true, CapitalizationType.NO_CAPS, false);
            String str = value.text();
            String msg = NLS.bind((String)Resources.message, (Object)label, (Object)str);
            return Status.createErrorStatus((String)msg);
        }
        return Status.createOkStatus();
    }

    protected boolean isUniqueValue(Value<?> value) {
        String str = value.text();
        if (str != null) {
            Element modelElement = value.element();
            ValueProperty property = value.definition();
            Property parent = modelElement.parent();
            if (parent instanceof ElementList) {
                ElementList list = (ElementList)parent;
                for (Element x : list) {
                    Value xval;
                    if (x == modelElement || !str.equals((xval = x.property(property)).text())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void dispose() {
        ((Element)this.context(Element.class)).detach(this.listener, this.path);
    }

    private static final class Resources
    extends NLS {
        public static String message;

        static {
            Resources.initializeMessages((String)UniqueValueValidationService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

