/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.eclipse.tools.coherence.descriptors.override.IService;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceDistributedCache;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceGeneric;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceInvocation;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceLocalCache;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceName;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceOptimisticCache;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceProxy;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceRemote;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceRemoteInvocation;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceReplicatedCache;
import oracle.eclipse.tools.coherence.descriptors.override.IServiceSimpleCache;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItem;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ListItemsController;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceDistributedCacheResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceGenericResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceInvocationResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceLocalCacheResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceNameResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceOptimisticCacheResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceProxyResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceRemoteInvocationResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceRemoteResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceReplicatedCacheResource;
import oracle.eclipse.tools.coherence.descriptors.override.internal.ServiceSimpleCacheResource;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.modeling.xml.StandardXmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlNamespaceResolver;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlResource;
import org.w3c.dom.Element;

public class ServicesListController
extends ListItemsController {
    static final String PARENT_PATH = "cluster-config/services";
    private static final String ELEMENT_PATH = "services";
    private static final String PATH = "service";
    private static final StandardXmlNamespaceResolver NAMESPACE_RESOLVER = new StandardXmlNamespaceResolver(IService.TYPE);
    private static final XmlPath ELEMENT_XML_PATH = new XmlPath("services", (XmlNamespaceResolver)NAMESPACE_RESOLVER);
    public static final Map<ElementType, String> TYPE_TO_ID;

    static {
        HashMap<ElementType, String> map = new HashMap<ElementType, String>();
        map.put(IServiceReplicatedCache.TYPE, "1");
        map.put(IServiceOptimisticCache.TYPE, "2");
        map.put(IServiceDistributedCache.TYPE, "3");
        map.put(IServiceInvocation.TYPE, "4");
        map.put(IServiceLocalCache.TYPE, "5");
        map.put(IServiceSimpleCache.TYPE, "6");
        map.put(IServiceProxy.TYPE, "7");
        map.put(IServiceRemote.TYPE, "8");
        map.put(IServiceRemoteInvocation.TYPE, "9");
        map.put(IServiceName.TYPE, "10");
        TYPE_TO_ID = Collections.unmodifiableMap(map);
    }

    public ServicesListController() {
        super(PATH);
    }

    protected Resource resource(Object obj) {
        ListItem item = (ListItem)obj;
        XmlResource parentResource = (XmlResource)this.property().element().resource();
        if (item.getBaseElement() != null) {
            Element elem = item.getBaseElement();
            String id = elem.getAttribute("id");
            if ("1".equals(id)) {
                return new ServiceReplicatedCacheResource(parentResource, item);
            }
            if ("2".equals(id)) {
                return new ServiceOptimisticCacheResource(parentResource, item);
            }
            if ("3".equals(id)) {
                return new ServiceDistributedCacheResource(parentResource, item);
            }
            if ("4".equals(id)) {
                return new ServiceInvocationResource(parentResource, item);
            }
            if ("5".equals(id)) {
                return new ServiceLocalCacheResource(parentResource, item);
            }
            if ("6".equals(id)) {
                return new ServiceSimpleCacheResource(parentResource, item);
            }
            if ("7".equals(id)) {
                return new ServiceProxyResource(parentResource, item);
            }
            if ("8".equals(id)) {
                return new ServiceRemoteResource(parentResource, item);
            }
            if ("9".equals(id)) {
                return new ServiceRemoteInvocationResource(parentResource, item);
            }
            if ("10".equals(id)) {
                return new ServiceNameResource(parentResource, item);
            }
        }
        return new ServiceGenericResource(parentResource, item);
    }

    public ElementType type(Resource resource) {
        if (resource instanceof ServiceReplicatedCacheResource) {
            return IServiceReplicatedCache.TYPE;
        }
        if (resource instanceof ServiceOptimisticCacheResource) {
            return IServiceOptimisticCache.TYPE;
        }
        if (resource instanceof ServiceDistributedCacheResource) {
            return IServiceDistributedCache.TYPE;
        }
        if (resource instanceof ServiceInvocationResource) {
            return IServiceInvocation.TYPE;
        }
        if (resource instanceof ServiceLocalCacheResource) {
            return IServiceLocalCache.TYPE;
        }
        if (resource instanceof ServiceSimpleCacheResource) {
            return IServiceSimpleCache.TYPE;
        }
        if (resource instanceof ServiceProxyResource) {
            return IServiceProxy.TYPE;
        }
        if (resource instanceof ServiceRemoteResource) {
            return IServiceRemote.TYPE;
        }
        if (resource instanceof ServiceRemoteInvocationResource) {
            return IServiceRemoteInvocation.TYPE;
        }
        if (resource instanceof ServiceNameResource) {
            return IServiceName.TYPE;
        }
        return IServiceGeneric.TYPE;
    }

    @Override
    protected String getParentPath() {
        return PARENT_PATH;
    }

    @Override
    protected String getElementPath() {
        return ELEMENT_PATH;
    }

    @Override
    protected XmlPath getElementXmlPath() {
        return ELEMENT_XML_PATH;
    }

    @Override
    protected String getPath() {
        return PATH;
    }

    @Override
    protected String typeToId(ElementType type) {
        return TYPE_TO_ID.get(type);
    }
}

