/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideService;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.modeling.xml.XmlElement;
import org.eclipse.sapphire.modeling.xml.XmlNode;
import org.eclipse.sapphire.modeling.xml.XmlPath;
import org.eclipse.sapphire.modeling.xml.XmlValueBindingImpl;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class OverrideValuePropertyCustomBinding
extends XmlValueBindingImpl {
    private String path;

    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        if (params.length > 0) {
            this.path = params[0];
        }
    }

    public String getPath() {
        return this.path;
    }

    public XmlNode getXmlNode() {
        XmlElement el = this.xml(false);
        if (this.path != null && el != null) {
            XmlPath xmlPath = new XmlPath(this.path);
            XmlElement child = (XmlElement)el.getChildNode(xmlPath, false);
            return child;
        }
        return el;
    }

    public String read() {
        XmlNode child = this.getXmlNode();
        if (child != null) {
            return child.getText();
        }
        return null;
    }

    public void write(String value) {
        this.write(value, true);
    }

    public void write(String value, boolean removeNodeWhenEmpty) {
        XmlElement el = this.xml(true);
        if (this.path != null) {
            XmlPath xmlPath = new XmlPath(this.path);
            if (value != null && (value.length() > 0 || value.length() == 0 && !removeNodeWhenEmpty)) {
                String existingSystemProperty;
                String fullPath;
                XmlElement child = (XmlElement)el.getChildNode(xmlPath, true);
                IProject project = (IProject)this.property().element().adapt(IProject.class);
                String systemProperty = CoherenceOverrideService.getSystemProperty(project, fullPath = CoherenceOverrideService.getFullXmlPath(el, this.path));
                if (systemProperty != null && systemProperty.length() > 0 && ((existingSystemProperty = child.getDomNode().getAttribute("system-property")) == null || existingSystemProperty.length() == 0)) {
                    child.getDomNode().setAttribute("system-property", systemProperty);
                }
                child.setText(value);
            } else {
                el.removeChildNode(xmlPath);
            }
        } else {
            el.setText(value);
        }
    }
}

