/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.coherence.descriptors.override.internal;

import java.math.BigDecimal;
import oracle.eclipse.tools.coherence.descriptors.internal.NumberWithUnit;
import oracle.eclipse.tools.coherence.descriptors.override.CoherenceOverrideService;
import oracle.eclipse.tools.coherence.descriptors.override.internal.OverrideValuePropertyCustomBinding;
import org.eclipse.core.resources.IProject;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.xml.annotations.CustomXmlValueBinding;

public class NumberWithUnitPropertyCustomBinding
extends OverrideValuePropertyCustomBinding {
    private boolean isNumber;
    private String genericDefault = null;

    @Override
    public void init(Property property) {
        super.init(property);
        String[] params = ((CustomXmlValueBinding)property.definition().getAnnotation(CustomXmlValueBinding.class)).params();
        if (params.length > 1) {
            this.isNumber = Boolean.parseBoolean(params[1]);
            if (params.length > 2) {
                this.genericDefault = params[2];
            }
        }
    }

    @Override
    public String read() {
        String value = super.read();
        NumberWithUnit nu = NumberWithUnit.parse(value);
        if (this.isNumber) {
            return nu.getNumber();
        }
        return nu.getUnit();
    }

    private boolean isValidNumber(String value) {
        if (this.isNumber) {
            if (value == null) {
                return false;
            }
            ValueProperty numberProp = (ValueProperty)this.property().definition();
            if (numberProp.isOfType(Long.class)) {
                long number = 0L;
                try {
                    number = Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number > 0L;
            }
            if (numberProp.isOfType(Integer.class)) {
                int number = 0;
                try {
                    number = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number > 0;
            }
            if (numberProp.isOfType(BigDecimal.class)) {
                BigDecimal number = BigDecimal.ZERO;
                try {
                    number = new BigDecimal(value);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return number.compareTo(BigDecimal.ZERO) > 0;
            }
        }
        return true;
    }

    @Override
    public void write(String value) {
        if ((value == null || !this.isValidNumber(value)) && this.isNumber) {
            super.write(value);
        } else {
            String oldValue = super.read();
            NumberWithUnit nu = NumberWithUnit.parse(oldValue);
            if (this.isNumber) {
                nu.setNumber(value);
            } else {
                nu.setUnit(value);
            }
            if (nu.getNumber() == null || nu.getUnit() == null) {
                IProject project = (IProject)this.property().element().adapt(IProject.class);
                String defaultExpiry = CoherenceOverrideService.getTextValue(project, this.getPath());
                if (defaultExpiry == null) {
                    defaultExpiry = this.genericDefault;
                }
                NumberWithUnit defaultNu = NumberWithUnit.parse(defaultExpiry);
                nu.addDefault(defaultNu);
            }
            super.write(nu.toString());
        }
    }
}

